/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.computer.ComputerEnvironment;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.metrics.MetricsObserver;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.InputHandler;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.network.client.ComputerTerminalClientMessage;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ServerComputer
implements InputHandler,
ComputerEnvironment {
    private final int instanceID;
    private ServerLevel level;
    private BlockPos position;
    private final ComputerFamily family;
    private final MetricsObserver metrics;
    private final Computer computer;
    private final NetworkedTerminal terminal;
    private final AtomicBoolean terminalChanged = new AtomicBoolean(false);
    private boolean changedLastFrame;
    private int ticksSincePing;

    public ServerComputer(ServerLevel level, BlockPos position, int computerID, @Nullable String label, ComputerFamily family, int terminalWidth, int terminalHeight) {
        this.level = level;
        this.position = position;
        this.family = family;
        ServerContext context = ServerContext.get(level.m_7654_());
        this.instanceID = context.registry().getUnusedInstanceID();
        this.terminal = new NetworkedTerminal(terminalWidth, terminalHeight, family != ComputerFamily.NORMAL, this::markTerminalChanged);
        this.metrics = context.metrics().createMetricObserver(this);
        this.computer = new Computer(context.computerContext(), this, this.terminal, computerID);
        this.computer.setLabel(label);
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public void setLevel(ServerLevel level) {
        this.level = level;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public void setPosition(BlockPos pos) {
        this.position = new BlockPos((Vec3i)pos);
    }

    public IAPIEnvironment getAPIEnvironment() {
        return this.computer.getAPIEnvironment();
    }

    public Computer getComputer() {
        return this.computer;
    }

    protected void markTerminalChanged() {
        this.terminalChanged.set(true);
    }

    public void tickServer() {
        ++this.ticksSincePing;
        this.computer.tick();
        this.changedLastFrame = this.computer.pollAndResetChanged();
        if (this.terminalChanged.getAndSet(false)) {
            this.onTerminalChanged();
        }
    }

    protected void onTerminalChanged() {
        this.sendToAllInteracting(c -> new ComputerTerminalClientMessage((AbstractContainerMenu)c, this.getTerminalState()));
    }

    public TerminalState getTerminalState() {
        return new TerminalState(this.terminal);
    }

    public void keepAlive() {
        this.ticksSincePing = 0;
    }

    public boolean hasTimedOut() {
        return this.ticksSincePing > 100;
    }

    public boolean hasOutputChanged() {
        return this.changedLastFrame;
    }

    public int register() {
        ServerContext.get(this.level.m_7654_()).registry().add(this.instanceID, this);
        return this.instanceID;
    }

    void unload() {
        this.computer.unload();
    }

    public void close() {
        this.unload();
        ServerContext.get(this.level.m_7654_()).registry().remove(this.instanceID);
    }

    private void sendToAllInteracting(Function<AbstractContainerMenu, NetworkMessage<ClientNetworkContext>> createPacket) {
        MinecraftServer server = this.level.m_7654_();
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            if (!(player.f_36096_ instanceof ComputerMenu) || ((ComputerMenu)player.f_36096_).getComputer() != this) continue;
            PlatformHelper.get().sendToPlayer(createPacket.apply(player.f_36096_), player);
        }
    }

    protected void onRemoved() {
    }

    public int getInstanceID() {
        return this.instanceID;
    }

    public int getID() {
        return this.computer.getID();
    }

    @Nullable
    public String getLabel() {
        return this.computer.getLabel();
    }

    public boolean isOn() {
        return this.computer.isOn();
    }

    public ComputerState getState() {
        if (!this.isOn()) {
            return ComputerState.OFF;
        }
        return this.computer.isBlinking() ? ComputerState.BLINKING : ComputerState.ON;
    }

    @Override
    public void turnOn() {
        this.computer.turnOn();
    }

    @Override
    public void shutdown() {
        this.computer.shutdown();
    }

    @Override
    public void reboot() {
        this.computer.reboot();
    }

    @Override
    public void queueEvent(String event, @Nullable Object[] arguments) {
        this.computer.queueEvent(event, arguments);
    }

    public int getRedstoneOutput(ComputerSide side) {
        return this.computer.getEnvironment().getExternalRedstoneOutput(side);
    }

    public void setRedstoneInput(ComputerSide side, int level) {
        this.computer.getEnvironment().setRedstoneInput(side, level);
    }

    public int getBundledRedstoneOutput(ComputerSide side) {
        return this.computer.getEnvironment().getExternalBundledRedstoneOutput(side);
    }

    public void setBundledRedstoneInput(ComputerSide side, int combination) {
        this.computer.getEnvironment().setBundledRedstoneInput(side, combination);
    }

    public void addAPI(ILuaAPI api) {
        this.computer.addApi(api);
    }

    public void setPeripheral(ComputerSide side, @Nullable IPeripheral peripheral) {
        this.computer.getEnvironment().setPeripheral(side, peripheral);
    }

    @Nullable
    public IPeripheral getPeripheral(ComputerSide side) {
        return this.computer.getEnvironment().getPeripheral(side);
    }

    public void setLabel(@Nullable String label) {
        this.computer.setLabel(label);
    }

    @Override
    public double getTimeOfDay() {
        return (double)((this.level.m_46468_() + 6000L) % 24000L) / 1000.0;
    }

    @Override
    public int getDay() {
        return (int)((this.level.m_46468_() + 6000L) / 24000L) + 1;
    }

    @Override
    public MetricsObserver getMetrics() {
        return this.metrics;
    }

    @Override
    @Nullable
    public WritableMount createRootMount() {
        return ComputerCraftAPI.createSaveDirMount(this.level.m_7654_(), "computer/" + this.computer.getID(), Config.computerSpaceLimit);
    }
}

