/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import com.google.common.annotations.VisibleForTesting;
import dan200.computercraft.api.filesystem.FileOperationException;
import dan200.computercraft.core.filesystem.ArchiveMount;
import dan200.computercraft.core.filesystem.FileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceMount
extends ArchiveMount<FileEntry> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceMount.class);
    private static final byte[] TEMP_BUFFER = new byte[8192];
    private static final Map<ResourceLocation, ResourceMount> MOUNT_CACHE = new HashMap<ResourceLocation, ResourceMount>(2);
    private final String namespace;
    private final String subPath;
    private ResourceManager manager;
    public static final SimplePreparableReloadListener<Void> RELOAD_LISTENER = new SimplePreparableReloadListener<Void>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void prepare(ResourceManager manager, ProfilerFiller profiler) {
            profiler.m_6180_("Reloading ComputerCraft mounts");
            try {
                for (ResourceMount mount : MOUNT_CACHE.values()) {
                    mount.load(manager);
                }
            }
            finally {
                profiler.m_7238_();
            }
            return null;
        }

        protected void apply(Void result, ResourceManager manager, ProfilerFiller profiler) {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceMount get(String namespace, String subPath, ResourceManager manager) {
        ResourceLocation path = new ResourceLocation(namespace, subPath);
        Map<ResourceLocation, ResourceMount> map = MOUNT_CACHE;
        synchronized (map) {
            ResourceMount mount = MOUNT_CACHE.get(path);
            if (mount == null) {
                mount = new ResourceMount(namespace, subPath, manager);
                MOUNT_CACHE.put(path, mount);
            }
            return mount;
        }
    }

    @VisibleForTesting
    ResourceMount(String namespace, String subPath, ResourceManager manager) {
        this.namespace = namespace;
        this.subPath = subPath;
        this.load(manager);
    }

    private void load(ResourceManager manager) {
        boolean hasAny = false;
        String existingNamespace = null;
        FileEntry newRoot = new FileEntry("", new ResourceLocation(this.namespace, this.subPath));
        for (ResourceLocation file : manager.m_214159_(this.subPath, s -> true).keySet()) {
            existingNamespace = file.m_135827_();
            if (!file.m_135827_().equals(this.namespace) || !FileSystem.contains(this.subPath, file.m_135815_())) continue;
            String localPath = FileSystem.toLocal(file.m_135815_(), this.subPath);
            this.create(newRoot, localPath);
            hasAny = true;
        }
        this.manager = manager;
        ArchiveMount.FileEntry fileEntry = this.root = hasAny ? newRoot : null;
        if (!hasAny) {
            LOG.warn("Cannot find any files under /data/{}/{} for resource mount.", (Object)this.namespace, (Object)this.subPath);
            if (existingNamespace != null) {
                LOG.warn("There are files under /data/{}/{} though. Did you get the wrong namespace?", (Object)existingNamespace, (Object)this.subPath);
            }
        }
    }

    private void create(FileEntry lastEntry, String path) {
        int lastIndex = 0;
        while (lastIndex < path.length()) {
            FileEntry nextEntry;
            int nextIndex = path.indexOf(47, lastIndex);
            if (nextIndex < 0) {
                nextIndex = path.length();
            }
            String part = path.substring(lastIndex, nextIndex);
            if (lastEntry.children == null) {
                lastEntry.children = new HashMap();
            }
            if ((nextEntry = (FileEntry)lastEntry.children.get(part)) == null) {
                ResourceLocation childPath;
                try {
                    childPath = new ResourceLocation(this.namespace, this.subPath + "/" + path);
                }
                catch (ResourceLocationException e) {
                    LOG.warn("Cannot create resource location for {} ({})", (Object)part, (Object)e.getMessage());
                    return;
                }
                nextEntry = new FileEntry(path, childPath);
                lastEntry.children.put(part, nextEntry);
            }
            lastEntry = nextEntry;
            lastIndex = nextIndex + 1;
        }
    }

    @Override
    public long getSize(FileEntry file) {
        long l;
        block10: {
            Resource resource = this.manager.m_213713_(file.identifier).orElse(null);
            if (resource == null) {
                return 0L;
            }
            InputStream stream = resource.m_215507_();
            try {
                int total = 0;
                int read = 0;
                do {
                    total += read;
                } while ((read = stream.read(TEMP_BUFFER)) > 0);
                l = total;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return 0L;
                }
            }
            stream.close();
        }
        return l;
    }

    @Override
    public byte[] getContents(FileEntry file) throws IOException {
        Resource resource = this.manager.m_213713_(file.identifier).orElse(null);
        if (resource == null) {
            throw new FileOperationException(file.path, "No such file");
        }
        try (InputStream stream = resource.m_215507_();){
            byte[] byArray = stream.readAllBytes();
            return byArray;
        }
    }

    protected static class FileEntry
    extends ArchiveMount.FileEntry<FileEntry> {
        final ResourceLocation identifier;

        FileEntry(String path, ResourceLocation identifier) {
            super(path);
            this.identifier = identifier;
        }
    }
}

