/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.lua;

import dan200.computercraft.api.lua.IDynamicLuaObject;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaFunction;
import dan200.computercraft.core.CoreConfig;
import dan200.computercraft.core.Logging;
import dan200.computercraft.core.computer.TimeoutState;
import dan200.computercraft.core.lua.BasicFunction;
import dan200.computercraft.core.lua.ILuaMachine;
import dan200.computercraft.core.lua.MachineEnvironment;
import dan200.computercraft.core.lua.MachineException;
import dan200.computercraft.core.lua.MachineResult;
import dan200.computercraft.core.lua.ResultInterpreterFunction;
import dan200.computercraft.core.methods.LuaMethod;
import dan200.computercraft.core.methods.MethodSupplier;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.core.util.SanitisedError;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaThread;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.compiler.CompileException;
import org.squiddev.cobalt.compiler.LoadState;
import org.squiddev.cobalt.function.LuaClosure;
import org.squiddev.cobalt.function.LuaFunction;
import org.squiddev.cobalt.interrupt.InterruptAction;
import org.squiddev.cobalt.lib.Bit32Lib;
import org.squiddev.cobalt.lib.CoreLibraries;

public class CobaltLuaMachine
implements ILuaMachine {
    private static final Logger LOG = LoggerFactory.getLogger(CobaltLuaMachine.class);
    private static final LuaMethod FUNCTION_METHOD = (target, context, args) -> ((ILuaFunction)target).call(args);
    private final TimeoutState timeout;
    private final Runnable timeoutListener = this::updateTimeout;
    private final ILuaContext context;
    private final MethodSupplier<LuaMethod> luaMethods;
    private final LuaState state;
    private final LuaThread mainRoutine;
    private volatile boolean isDisposed = false;
    private boolean thrownSoftAbort;
    @Nullable
    private String eventFilter = null;

    public CobaltLuaMachine(MachineEnvironment environment, InputStream bios) throws MachineException, IOException {
        this.timeout = environment.timeout();
        this.context = environment.context();
        this.luaMethods = environment.luaMethods();
        LuaState state = this.state = LuaState.builder().interruptHandler(() -> {
            if (this.timeout.isHardAborted() || this.isDisposed) {
                throw new HardAbortError();
            }
            if (this.timeout.isSoftAborted() && !this.thrownSoftAbort) {
                this.thrownSoftAbort = true;
                throw new LuaError("Too long without yielding");
            }
            return this.timeout.isPaused() ? InterruptAction.SUSPEND : InterruptAction.CONTINUE;
        }).errorReporter((e, msg) -> {
            if (LOG.isErrorEnabled(Logging.VM_ERROR)) {
                LOG.error(Logging.VM_ERROR, "Error occurred in the Lua runtime. Computer will continue to execute:\n{}", msg.get(), (Object)e);
            }
        }).build();
        LuaTable globals = state.getMainThread().getfenv();
        CoreLibraries.debugGlobals((LuaState)state);
        Bit32Lib.add((LuaState)state, (LuaTable)globals);
        globals.rawset("_HOST", (LuaValue)ValueFactory.valueOf((String)environment.hostString()));
        globals.rawset("_CC_DEFAULT_SETTINGS", (LuaValue)ValueFactory.valueOf((String)CoreConfig.defaultComputerSettings));
        if (CoreConfig.disableLua51Features) {
            globals.rawset("_CC_DISABLE_LUA51_FEATURES", (LuaValue)Constants.TRUE);
        }
        for (ILuaAPI api : environment.apis()) {
            this.addAPI(globals, api);
        }
        try {
            LuaClosure value = LoadState.load((LuaState)state, (InputStream)bios, (String)"@bios.lua", (LuaTable)globals);
            this.mainRoutine = new LuaThread(state, (LuaFunction)value, globals);
        }
        catch (CompileException e2) {
            throw new MachineException(Nullability.assertNonNull(e2.getMessage()));
        }
        this.timeout.addListener(this.timeoutListener);
    }

    private void addAPI(LuaTable globals, ILuaAPI api) {
        String[] names;
        LuaTable table = this.wrapLuaObject(api);
        if (table == null) {
            LOG.warn("API {} does not provide any methods", (Object)api);
            table = new LuaTable();
        }
        for (String name : names = api.getNames()) {
            globals.rawset(name, (LuaValue)table);
        }
    }

    private void updateTimeout() {
        if (this.isDisposed) {
            return;
        }
        if (!this.timeout.isSoftAborted()) {
            this.thrownSoftAbort = false;
        }
        if (this.timeout.isSoftAborted() || this.timeout.isPaused()) {
            this.state.interrupt();
        }
    }

    @Override
    public MachineResult handleEvent(@Nullable String eventName, @Nullable Object[] arguments) {
        if (this.isDisposed) {
            throw new IllegalStateException("Machine has been closed");
        }
        if (this.eventFilter != null && eventName != null && !eventName.equals(this.eventFilter) && !eventName.equals("terminate")) {
            return MachineResult.OK;
        }
        try {
            Varargs resumeArgs = eventName == null ? Constants.NONE : ValueFactory.varargsOf((LuaValue)ValueFactory.valueOf((String)eventName), (Varargs)this.toValues(arguments));
            LuaThread thread = this.state.getCurrentThread();
            if (thread == null || thread == this.state.getMainThread()) {
                thread = this.mainRoutine;
            }
            Varargs results = LuaThread.run((LuaThread)thread, (Varargs)resumeArgs);
            if (this.timeout.isHardAborted()) {
                throw new HardAbortError();
            }
            if (results == null) {
                return MachineResult.PAUSE;
            }
            LuaValue filter = results.first();
            String string = this.eventFilter = filter.isString() ? filter.toString() : null;
            if (!this.mainRoutine.isAlive()) {
                this.close();
                return MachineResult.GENERIC_ERROR;
            }
            return MachineResult.OK;
        }
        catch (HardAbortError e) {
            this.close();
            return MachineResult.TIMEOUT;
        }
        catch (LuaError e) {
            this.close();
            LOG.warn("Top level coroutine errored: {}", (Object)new SanitisedError(e));
            return MachineResult.error((Exception)((Object)e));
        }
    }

    @Override
    public void printExecutionState(StringBuilder out) {
    }

    @Override
    public void close() {
        this.isDisposed = true;
        this.state.interrupt();
        this.timeout.removeListener(this.timeoutListener);
    }

    @Nullable
    private LuaTable wrapLuaObject(Object object) {
        LuaTable table = new LuaTable();
        boolean found = this.luaMethods.forEachMethod(object, (target, name, method, info) -> table.rawset(name, (LuaValue)(info != null && info.nonYielding() ? new BasicFunction(this, (LuaMethod)method, target, this.context, name) : new ResultInterpreterFunction(this, (LuaMethod)method, target, this.context, name))));
        return found ? table : null;
    }

    private LuaValue toValue(@Nullable Object object, @Nullable IdentityHashMap<Object, LuaValue> values) {
        LuaValue result;
        if (object == null) {
            return Constants.NIL;
        }
        if (object instanceof Number) {
            Number num = (Number)object;
            return ValueFactory.valueOf((double)num.doubleValue());
        }
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return ValueFactory.valueOf((boolean)bool);
        }
        if (object instanceof String) {
            String str = (String)object;
            return ValueFactory.valueOf((String)str);
        }
        if (object instanceof byte[]) {
            byte[] b = (byte[])object;
            return ValueFactory.valueOf((byte[])Arrays.copyOf(b, b.length));
        }
        if (object instanceof ByteBuffer) {
            ByteBuffer b = (ByteBuffer)object;
            byte[] bytes = new byte[b.remaining()];
            b.get(bytes);
            return ValueFactory.valueOf((byte[])bytes);
        }
        if (values == null) {
            values = new IdentityHashMap(1);
        }
        if ((result = values.get(object)) != null) {
            return result;
        }
        if (object instanceof ILuaFunction) {
            return new ResultInterpreterFunction(this, FUNCTION_METHOD, object, this.context, object.toString());
        }
        if (object instanceof IDynamicLuaObject) {
            LuaTable wrapped = this.wrapLuaObject(object);
            if (wrapped == null) {
                wrapped = new LuaTable();
            }
            values.put(object, (LuaValue)wrapped);
            return wrapped;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            LuaTable table = new LuaTable();
            values.put(object, table);
            for (Map.Entry pair : map.entrySet()) {
                LuaValue key = this.toValue(pair.getKey(), values);
                LuaValue value = this.toValue(pair.getValue(), values);
                if (key.isNil() || value.isNil()) continue;
                table.rawset(key, value);
            }
            return table;
        }
        if (object instanceof Collection) {
            Collection objects = (Collection)object;
            LuaTable table = new LuaTable(objects.size(), 0);
            values.put(object, table);
            int i = 0;
            for (Object child : objects) {
                table.rawset(++i, this.toValue(child, values));
            }
            return table;
        }
        if (object instanceof Object[]) {
            Object[] objects = (Object[])object;
            LuaTable table = new LuaTable(objects.length, 0);
            values.put(object, table);
            for (int i = 0; i < objects.length; ++i) {
                table.rawset(i + 1, this.toValue(objects[i], values));
            }
            return table;
        }
        LuaTable wrapped = this.wrapLuaObject(object);
        if (wrapped != null) {
            values.put(object, wrapped);
            return wrapped;
        }
        LOG.warn(Logging.JAVA_ERROR, "Received unknown type '{}', returning nil.", (Object)object.getClass().getName());
        return Constants.NIL;
    }

    Varargs toValues(@Nullable Object[] objects) {
        if (objects == null || objects.length == 0) {
            return Constants.NONE;
        }
        if (objects.length == 1) {
            return this.toValue(objects[0], null);
        }
        IdentityHashMap<Object, LuaValue> result = new IdentityHashMap<Object, LuaValue>(0);
        LuaValue[] values = new LuaValue[objects.length];
        for (int i = 0; i < values.length; ++i) {
            Object object = objects[i];
            values[i] = this.toValue(object, result);
        }
        return ValueFactory.varargsOf((LuaValue[])values);
    }

    @Nullable
    static Object toObject(LuaValue value, @Nullable IdentityHashMap<LuaValue, Object> objects) {
        return switch (value.type()) {
            case 0 -> {
                String var2_2 = null;
                yield var2_2;
            }
            case -2, 3 -> {
                Double var2_3 = value.toDouble();
                yield var2_3;
            }
            case 1 -> {
                Boolean var2_4 = value.toBoolean();
                yield var2_4;
            }
            case 4 -> {
                String var2_5 = value.toString();
                yield var2_5;
            }
            case 5 -> {
                HashMap<Object, Object> var2_7;
                if (objects == null) {
                    objects = new IdentityHashMap(1);
                } else {
                    Object existing = objects.get(value);
                    if (existing != null) {
                        Object var2_6 = existing;
                        yield var2_6;
                    }
                }
                HashMap<Object, Object> table = new HashMap<Object, Object>();
                objects.put(value, table);
                LuaTable luaTable = (LuaTable)value;
                LuaValue k = Constants.NIL;
                while (true) {
                    Varargs keyValue;
                    try {
                        keyValue = luaTable.next(k);
                    }
                    catch (LuaError luaError) {
                        break;
                    }
                    k = keyValue.first();
                    if (k.isNil()) break;
                    LuaValue v = keyValue.arg(2);
                    Object keyObject = CobaltLuaMachine.toObject(k, objects);
                    Object valueObject = CobaltLuaMachine.toObject(v, objects);
                    if (keyObject == null || valueObject == null) continue;
                    table.put(keyObject, valueObject);
                }
                yield var2_7 = table;
            }
            default -> {
                String var2_8 = null;
                yield var2_8;
            }
        };
    }

    static Object[] toObjects(Varargs values) {
        int count = values.count();
        Object[] objects = new Object[count];
        for (int i = 0; i < count; ++i) {
            objects[i] = CobaltLuaMachine.toObject(values.arg(i + 1), null);
        }
        return objects;
    }

    private static final class HardAbortError
    extends Error {
        private static final long serialVersionUID = 7954092008586367501L;

        private HardAbortError() {
            super("Hard Abort");
        }
    }
}

