/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import dan200.computercraft.api.filesystem.FileAttributes;
import dan200.computercraft.api.filesystem.FileOperationException;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.core.apis.handles.ArrayByteChannel;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public abstract class ArchiveMount<T extends FileEntry<T>>
implements Mount {
    protected static final String NO_SUCH_FILE = "No such file";
    private static final int MAX_CACHE_SIZE = 0x4000000;
    private static final Cache<FileEntry<?>, byte[]> CONTENTS_CACHE = CacheBuilder.newBuilder().concurrencyLevel(4).expireAfterAccess(60L, TimeUnit.SECONDS).maximumWeight(0x4000000L).weakKeys().weigher((k, v) -> ((byte[])v).length).build();
    @Nullable
    protected T root;

    @Nullable
    private T get(String path) {
        T lastEntry = this.root;
        int lastIndex = 0;
        while (lastEntry != null && lastIndex < path.length()) {
            int nextIndex = path.indexOf(47, lastIndex);
            if (nextIndex < 0) {
                nextIndex = path.length();
            }
            lastEntry = ((FileEntry)lastEntry).children == null ? null : (FileEntry)((FileEntry)lastEntry).children.get(path.substring(lastIndex, nextIndex));
            lastIndex = nextIndex + 1;
        }
        return lastEntry;
    }

    @Override
    public final boolean exists(String path) {
        return this.get(path) != null;
    }

    @Override
    public final boolean isDirectory(String path) {
        T file = this.get(path);
        return file != null && ((FileEntry)file).isDirectory();
    }

    @Override
    public final void list(String path, List<String> contents) throws IOException {
        T file = this.get(path);
        if (file == null || !((FileEntry)file).isDirectory()) {
            throw new FileOperationException(path, "Not a directory");
        }
        ((FileEntry)file).list(contents);
    }

    @Override
    public final long getSize(String path) throws IOException {
        T file = this.get(path);
        if (file == null) {
            throw new FileOperationException(path, NO_SUCH_FILE);
        }
        return this.getCachedSize(file);
    }

    private long getCachedSize(T file) throws IOException {
        if (((FileEntry)file).size != -1L) {
            return ((FileEntry)file).size;
        }
        if (((FileEntry)file).isDirectory()) {
            ((FileEntry)file).size = 0L;
            return 0L;
        }
        byte[] contents = (byte[])CONTENTS_CACHE.getIfPresent(file);
        if (contents != null) {
            ((FileEntry)file).size = contents.length;
            return ((FileEntry)file).size;
        }
        ((FileEntry)file).size = this.getSize(file);
        return ((FileEntry)file).size;
    }

    protected abstract long getSize(T var1) throws IOException;

    @Override
    public SeekableByteChannel openForRead(String path) throws IOException {
        T file = this.get(path);
        if (file == null || ((FileEntry)file).isDirectory()) {
            throw new FileOperationException(path, NO_SUCH_FILE);
        }
        byte[] cachedContents = (byte[])CONTENTS_CACHE.getIfPresent(file);
        if (cachedContents != null) {
            return new ArrayByteChannel(cachedContents);
        }
        byte[] contents = this.getContents(file);
        CONTENTS_CACHE.put(file, (Object)contents);
        return new ArrayByteChannel(contents);
    }

    protected abstract byte[] getContents(T var1) throws IOException;

    @Override
    public final BasicFileAttributes getAttributes(String path) throws IOException {
        T file = this.get(path);
        if (file == null) {
            throw new FileOperationException(path, NO_SUCH_FILE);
        }
        return this.getAttributes(file);
    }

    protected BasicFileAttributes getAttributes(T file) throws IOException {
        return new FileAttributes(((FileEntry)file).isDirectory(), this.getCachedSize(file));
    }

    protected static class FileEntry<T extends FileEntry<T>> {
        public final String path;
        @Nullable
        public Map<String, T> children;
        long size = -1L;

        protected FileEntry(String path) {
            this.path = path;
        }

        protected boolean isDirectory() {
            return this.children != null;
        }

        protected void list(List<String> contents) {
            if (this.children != null) {
                contents.addAll(this.children.keySet());
            }
        }
    }
}

