/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.computer;

import com.google.common.base.Objects;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.peripheral.WorkMonitor;
import dan200.computercraft.core.ComputerContext;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.computer.ComputerEnvironment;
import dan200.computercraft.core.computer.ComputerExecutor;
import dan200.computercraft.core.computer.Environment;
import dan200.computercraft.core.computer.GlobalEnvironment;
import dan200.computercraft.core.computer.mainthread.MainThreadScheduler;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.terminal.Terminal;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class Computer {
    private static final int START_DELAY = 50;
    private final int id;
    @Nullable
    private String label = null;
    private final GlobalEnvironment globalEnvironment;
    private final Terminal terminal;
    private final ComputerExecutor executor;
    private final MainThreadScheduler.Executor serverExecutor;
    private final AtomicLong lastTaskId = new AtomicLong();
    private boolean blinking = false;
    private final Environment internalEnvironment;
    private final AtomicBoolean externalOutputChanged = new AtomicBoolean();
    private boolean startRequested;
    private int ticksSinceStart = -1;

    public Computer(ComputerContext context, ComputerEnvironment environment, Terminal terminal, int id) {
        if (id < 0) {
            throw new IllegalStateException("Id has not been assigned");
        }
        this.id = id;
        this.globalEnvironment = context.globalEnvironment();
        this.terminal = terminal;
        this.internalEnvironment = new Environment(this, environment);
        this.executor = new ComputerExecutor(this, environment, context);
        this.serverExecutor = context.mainThreadScheduler().createExecutor(environment.getMetrics());
    }

    GlobalEnvironment getGlobalEnvironment() {
        return this.globalEnvironment;
    }

    FileSystem getFileSystem() {
        return this.executor.getFileSystem();
    }

    Terminal getTerminal() {
        return this.terminal;
    }

    public Environment getEnvironment() {
        return this.internalEnvironment;
    }

    public IAPIEnvironment getAPIEnvironment() {
        return this.internalEnvironment;
    }

    public boolean isOn() {
        return this.executor.isOn();
    }

    public void turnOn() {
        this.startRequested = true;
    }

    public void shutdown() {
        this.executor.queueStop(false, false);
    }

    public void reboot() {
        this.executor.queueStop(true, false);
    }

    public void unload() {
        this.executor.queueStop(false, true);
    }

    public void queueEvent(String event, @Nullable Object[] args) {
        this.executor.queueEvent(event, args);
    }

    public boolean queueMainThread(Runnable runnable) {
        return this.serverExecutor.enqueue(runnable);
    }

    public WorkMonitor getMainThreadMonitor() {
        return this.serverExecutor;
    }

    public int getID() {
        return this.id;
    }

    @Nullable
    public String getLabel() {
        return this.label;
    }

    public void setLabel(@Nullable String label) {
        if (!Objects.equal((Object)label, (Object)this.label)) {
            this.label = label;
            this.externalOutputChanged.set(true);
        }
    }

    public void tick() {
        boolean blinking;
        if (this.ticksSinceStart >= 0 && this.ticksSinceStart <= 50) {
            ++this.ticksSinceStart;
        }
        if (this.startRequested && (this.ticksSinceStart < 0 || this.ticksSinceStart > 50)) {
            this.startRequested = false;
            if (!this.executor.isOn()) {
                this.ticksSinceStart = 0;
                this.executor.queueStart();
            }
        }
        this.executor.tick();
        this.internalEnvironment.tick();
        if (this.internalEnvironment.updateOutput()) {
            this.externalOutputChanged.set(true);
        }
        boolean bl = blinking = this.terminal.getCursorBlink() && this.terminal.getCursorX() >= 0 && this.terminal.getCursorX() < this.terminal.getWidth() && this.terminal.getCursorY() >= 0 && this.terminal.getCursorY() < this.terminal.getHeight();
        if (blinking != this.blinking) {
            this.blinking = blinking;
            this.externalOutputChanged.set(true);
        }
    }

    void markChanged() {
        this.externalOutputChanged.set(true);
    }

    public boolean pollAndResetChanged() {
        return this.externalOutputChanged.getAndSet(false);
    }

    public boolean isBlinking() {
        return this.isOn() && this.blinking;
    }

    public void addApi(ILuaAPI api) {
        this.executor.addApi(api);
    }

    long getUniqueTaskId() {
        return this.lastTaskId.incrementAndGet();
    }
}

