/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client;

import com.mojang.blaze3d.audio.Channel;
import com.mojang.blaze3d.vertex.PoseStack;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.client.FrameInfo;
import dan200.computercraft.client.pocket.ClientPocketComputers;
import dan200.computercraft.client.render.CableHighlightRenderer;
import dan200.computercraft.client.render.PocketItemRenderer;
import dan200.computercraft.client.render.PrintoutItemRenderer;
import dan200.computercraft.client.render.monitor.MonitorBlockEntityRenderer;
import dan200.computercraft.client.render.monitor.MonitorHighlightRenderer;
import dan200.computercraft.client.render.monitor.MonitorRenderState;
import dan200.computercraft.client.sound.SpeakerManager;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.media.items.PrintoutItem;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.CableShapes;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import dan200.computercraft.shared.util.PauseAwareTimer;
import dan200.computercraft.shared.util.WorldUtil;
import java.io.File;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public final class ClientHooks {
    private ClientHooks() {
    }

    public static void onTick() {
        FrameInfo.onTick();
    }

    public static void onRenderTick() {
        PauseAwareTimer.tick(Minecraft.m_91087_().m_91104_());
        FrameInfo.onRenderTick();
    }

    public static void onWorldUnload() {
        MonitorRenderState.destroyAll();
        SpeakerManager.reset();
        ClientPocketComputers.reset();
    }

    public static boolean onChatMessage(String message) {
        return ClientHooks.handleOpenComputerCommand(message);
    }

    public static boolean drawHighlight(PoseStack transform, MultiBufferSource bufferSource, Camera camera, BlockHitResult hit) {
        return CableHighlightRenderer.drawHighlight(transform, bufferSource, camera, hit) || MonitorHighlightRenderer.drawHighlight(transform, bufferSource, camera, hit);
    }

    public static boolean onRenderHeldItem(PoseStack transform, MultiBufferSource render, int lightTexture, InteractionHand hand, float pitch, float equipProgress, float swingProgress, ItemStack stack) {
        if (stack.m_41720_() instanceof PocketComputerItem) {
            PocketItemRenderer.INSTANCE.renderItemFirstPerson(transform, render, lightTexture, hand, pitch, equipProgress, swingProgress, stack);
            return true;
        }
        if (stack.m_41720_() instanceof PrintoutItem) {
            PrintoutItemRenderer.INSTANCE.renderItemFirstPerson(transform, render, lightTexture, hand, pitch, equipProgress, swingProgress, stack);
            return true;
        }
        return false;
    }

    public static boolean onRenderItemFrame(PoseStack transform, MultiBufferSource render, ItemFrame frame, ItemStack stack, int light) {
        if (stack.m_41720_() instanceof PrintoutItem) {
            PrintoutItemRenderer.onRenderInFrame(transform, render, frame, stack, light);
            return true;
        }
        return false;
    }

    public static void onPlayStreaming(SoundEngine engine, Channel channel, AudioStream stream) {
        SpeakerManager.onPlayStreaming(engine, channel, stream);
    }

    private static boolean handleOpenComputerCommand(String message) {
        int id;
        if (!message.startsWith("computercraft open-computer ")) {
            return false;
        }
        IntegratedServer server = Minecraft.m_91087_().m_91092_();
        if (server == null) {
            return false;
        }
        String idStr = message.substring("computercraft open-computer ".length()).trim();
        try {
            id = Integer.parseInt(idStr);
        }
        catch (NumberFormatException ignore) {
            return false;
        }
        File file = new File(ServerContext.get((MinecraftServer)server).storageDir().toFile(), "computer/" + id);
        if (!file.isDirectory()) {
            return false;
        }
        Util.m_137581_().m_137644_(file);
        return true;
    }

    public static void addBlockDebugInfo(Consumer<String> addText) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!minecraft.f_91066_.f_92063_ || minecraft.f_91073_ == null) {
            return;
        }
        if (minecraft.f_91077_ == null || minecraft.f_91077_.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockEntity tile = minecraft.f_91073_.m_7702_(((BlockHitResult)minecraft.f_91077_).m_82425_());
        if (tile instanceof MonitorBlockEntity) {
            MonitorBlockEntity monitor = (MonitorBlockEntity)tile;
            addText.accept("");
            addText.accept(String.format("Targeted monitor: (%d, %d), %d x %d", monitor.getXIndex(), monitor.getYIndex(), monitor.getWidth(), monitor.getHeight()));
        } else if (tile instanceof TurtleBlockEntity) {
            TurtleBlockEntity turtle = (TurtleBlockEntity)tile;
            addText.accept("");
            addText.accept("Targeted turtle:");
            addText.accept(String.format("Id: %d", turtle.getComputerID()));
            ClientHooks.addTurtleUpgrade(addText, turtle, TurtleSide.LEFT);
            ClientHooks.addTurtleUpgrade(addText, turtle, TurtleSide.RIGHT);
        }
    }

    private static void addTurtleUpgrade(Consumer<String> out, TurtleBlockEntity turtle, TurtleSide side) {
        ITurtleUpgrade upgrade = turtle.getUpgrade(side);
        if (upgrade != null) {
            out.accept(String.format("Upgrade[%s]: %s", new Object[]{side, upgrade.getUpgradeID()}));
        }
    }

    public static void addGameDebugInfo(Consumer<String> addText) {
        if (MonitorBlockEntityRenderer.hasRenderedThisFrame() && Minecraft.m_91087_().f_91066_.f_92063_) {
            addText.accept("[CC:T] Monitor renderer: " + MonitorBlockEntityRenderer.currentRenderer());
        }
    }

    @Nullable
    public static BlockState getBlockBreakingState(BlockState state, BlockPos pos) {
        if (state.m_60734_() != ModRegistry.Blocks.CABLE.get() || !((Boolean)state.m_61143_((Property)CableBlock.CABLE)).booleanValue() || state.m_61143_(CableBlock.MODEM) == CableModemVariant.None) {
            return null;
        }
        HitResult hit = Minecraft.m_91087_().f_91077_;
        if (hit == null || hit.m_6662_() != HitResult.Type.BLOCK) {
            return null;
        }
        BlockPos hitPos = ((BlockHitResult)hit).m_82425_();
        if (!hitPos.equals((Object)pos)) {
            return null;
        }
        return WorldUtil.isVecInside(CableShapes.getModemShape(state), hit.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())) ? (BlockState)state.m_60734_().m_49966_().m_61124_(CableBlock.MODEM, (Comparable)((Object)((CableModemVariant)((Object)state.m_61143_(CableBlock.MODEM))))) : (BlockState)state.m_61124_(CableBlock.MODEM, (Comparable)((Object)CableModemVariant.None));
    }
}

