/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.function.Supplier;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketServerCommandTyped {
    private final BlockPos pos;
    private final ResourceKey<Level> dimensionId;
    private final String command;
    private final TypedMap params;

    public PacketServerCommandTyped(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.command = buf.m_130136_(Short.MAX_VALUE);
        this.params = TypedMapTools.readArguments(buf);
        this.dimensionId = buf.readBoolean() ? LevelTools.getId(buf.m_130281_()) : null;
    }

    public PacketServerCommandTyped(BlockPos pos, ResourceKey<Level> dimensionId, String command, TypedMap params) {
        this.pos = pos;
        this.command = command;
        this.params = params;
        this.dimensionId = dimensionId;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130070_(this.command);
        TypedMapTools.writeArguments(buf, this.params);
        if (this.dimensionId != null) {
            buf.writeBoolean(true);
            buf.m_130085_(this.dimensionId.m_135782_());
        } else {
            buf.writeBoolean(false);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer playerEntity = ctx.getSender();
            Object world = this.dimensionId == null ? playerEntity.m_20193_() : LevelTools.getLevel(playerEntity.m_9236_(), this.dimensionId);
            if (world == null) {
                return;
            }
            if (world.m_46805_(this.pos)) {
                GenericTileEntity generic;
                BlockEntity patt2526$temp = world.m_7702_(this.pos);
                if (patt2526$temp instanceof GenericTileEntity && (generic = (GenericTileEntity)patt2526$temp).executeServerCommand(this.command, (Player)playerEntity, this.params)) {
                    return;
                }
                Logging.log("Command " + this.command + " was not handled!");
            }
        });
        ctx.setPacketHandled(true);
    }
}

