/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.localization;

import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.common.server.player.data.ServerPlayerData;
import xaero.pac.common.server.player.localization.api.IAdaptiveLocalizerAPI;

public class AdaptiveLocalizer
implements IAdaptiveLocalizerAPI {
    private final Map<String, String> defaultTranslations;

    public AdaptiveLocalizer(Map<String, String> defaultTranslations) {
        this.defaultTranslations = defaultTranslations;
    }

    @Override
    @Nonnull
    public MutableComponent getFor(@Nonnull ServerPlayer player, @Nonnull String key, Object ... args) {
        ServerPlayerData playerDataAPI = (ServerPlayerData)ServerPlayerData.from(player);
        if (playerDataAPI.hasMod()) {
            return Component.m_237110_((String)key, (Object[])args);
        }
        return this.getServerLocalizedComponent(key, args);
    }

    @Override
    @Nonnull
    public Component getFor(@Nonnull ServerPlayer player, @Nonnull Component component) {
        ComponentContents componentContents = component.m_214077_();
        if (!(componentContents instanceof TranslatableContents)) {
            return component;
        }
        TranslatableContents translatableContents = (TranslatableContents)componentContents;
        ServerPlayerData playerDataAPI = (ServerPlayerData)ServerPlayerData.from(player);
        if (playerDataAPI.hasMod()) {
            return component;
        }
        String key = translatableContents.m_237508_();
        Object[] args = translatableContents.m_237523_();
        MutableComponent result = this.getServerLocalizedComponent(key, args).m_6270_(component.m_7383_());
        if (component.m_7360_() != null) {
            result.m_7360_().addAll(component.m_7360_());
        }
        return result;
    }

    private MutableComponent getServerLocalizedComponent(String key, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Component component;
            Object object = args[i];
            if (!(object instanceof Component) || !((object = (component = (Component)object).m_214077_()) instanceof TranslatableContents)) continue;
            TranslatableContents translatableContents = (TranslatableContents)object;
            args[i] = this.getServerLocalizedComponent(translatableContents.m_237508_(), translatableContents.m_237523_());
        }
        return Component.m_237110_((String)this.defaultTranslations.getOrDefault(key, key), (Object[])args);
    }

    public String getDefaultTranslation(String key, Object ... args) {
        return I18n.m_118938_((String)this.defaultTranslations.getOrDefault(key, key), (Object[])args);
    }
}

