/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.party;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.parties.party.member.PartyMember;
import xaero.pac.common.server.parties.party.PartyManager;
import xaero.pac.common.server.parties.party.ServerParty;

public final class PartyManagerFixer {
    public void fix(PartyManager partyManager) {
        OpenPartiesAndClaims.LOGGER.info("Fixing party inconsistencies...");
        ArrayList partiesToRemove = new ArrayList();
        partyManager.getAllStream().forEach(party -> party.getMemberInfoStream().forEach(p -> this.fixPlayer((ServerParty)party, partyManager, (PartyMember)p, partiesToRemove)));
        partiesToRemove.forEach(party -> partyManager.removeParty((ServerParty)party));
    }

    private void fixPlayer(ServerParty fixingParty, PartyManager partyManager, PartyMember player, List<ServerParty> partiesToRemove) {
        UUID playerId = player.getUUID();
        ServerParty correctParty = partyManager.getPartyByMember(playerId);
        if (correctParty != fixingParty) {
            if (fixingParty.getOwner().getUUID().equals(playerId)) {
                partiesToRemove.add(fixingParty);
            } else {
                fixingParty.removeMember(player.getUUID());
            }
        }
    }
}

