/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.ally.api.IPartyAllyAPI;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.PartyMemberRank;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.parties.command.CommandRequirementProvider;
import xaero.pac.common.server.parties.command.PartyOnCommandUpdater;
import xaero.pac.common.server.parties.party.IPartyManager;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.api.IPartyManagerAPI;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class UnallyPartyCommand {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment, CommandRequirementProvider commandRequirementProvider) {
        Predicate<CommandSourceStack> requirement = commandRequirementProvider.getMemberRequirement((party, mi) -> mi.getRank().ordinal() >= PartyMemberRank.MODERATOR.ordinal());
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"openpac-parties").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get())).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"ally").requires(requirement)).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"owner", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            Stream partyAllyStream;
            ServerPlayer commandPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(((CommandSourceStack)context.getSource()).m_81377_());
            IPartyManagerAPI partyManager = serverData.getPartyManager();
            IServerParty playerParty = (IServerParty)partyManager.getPartyByMember(commandPlayer.m_20148_());
            String lowercaseInput = builder.getRemainingLowerCase();
            if (playerParty.getAllyCount() > 1024) {
                Object exactAlly = playerParty.getAlly(lowercaseInput);
                partyAllyStream = Stream.ofNullable(exactAlly);
            } else {
                partyAllyStream = playerParty.getAllyPartiesStream();
            }
            return SharedSuggestionProvider.m_82981_(partyAllyStream.map(IPartyAllyAPI::getPartyId).map(((IPartyManager)partyManager)::getPartyById).filter(Objects::nonNull).map(party -> ((IPartyMember)party.getOwner()).getUsername()).filter(ownerName -> ownerName.toLowerCase().startsWith(lowercaseInput)).limit(16L), (SuggestionsBuilder)builder);
        }).executes(context -> {
            IServerParty targetPlayerParty;
            String targetOwnerName;
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            UUID playerId = player.m_20148_();
            MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            IPartyManagerAPI partyManager = serverData.getPartyManager();
            IServerParty playerParty = (IServerParty)partyManager.getPartyByMember(playerId);
            Object targetAlly = playerParty.getAlly(targetOwnerName = StringArgumentType.getString((CommandContext)context, (String)"owner"));
            IServerParty iServerParty = targetPlayerParty = targetAlly == null ? null : (IServerParty)partyManager.getPartyById(targetAlly.getPartyId());
            if (targetPlayerParty == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)adaptiveLocalizer.getFor(player, "gui.xaero_parties_unally_party_not_found", targetOwnerName));
                return 0;
            }
            playerParty.removeAllyParty(targetPlayerParty.getId());
            new PartyOnCommandUpdater().update(playerId, serverData, targetPlayerParty, serverData.getPlayerConfigs(), mi -> false, (Component)Component.m_237110_((String)"gui.xaero_parties_unally_target_party_message", (Object[])new Object[]{Component.m_237113_((String)playerParty.getDefaultName()).m_130938_(s -> s.m_131140_(ChatFormatting.DARK_GREEN)), Component.m_237113_((String)targetPlayerParty.getDefaultName())}));
            IPartyMember casterInfo = (IPartyMember)playerParty.getMemberInfo(playerId);
            new PartyOnCommandUpdater().update(playerId, serverData, playerParty, serverData.getPlayerConfigs(), mi -> false, (Component)Component.m_237110_((String)"gui.xaero_parties_unally_caster_party_message", (Object[])new Object[]{Component.m_237113_((String)casterInfo.getUsername()).m_130938_(s -> s.m_131140_(ChatFormatting.DARK_GREEN)), Component.m_237113_((String)targetPlayerParty.getDefaultName()).m_130938_(s -> s.m_131140_(ChatFormatting.YELLOW))}));
            return 1;
        }))));
        dispatcher.register(command);
    }
}

