/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.lazypacket;

import java.util.Deque;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.lazypacket.LazyPacket;
import xaero.pac.common.server.lazypacket.LazyPacketManager;
import xaero.pac.common.server.parties.party.IServerParty;

public class PlayerLazyPacketManager {
    private final MinecraftServer server;
    private final UUID playerId;
    private final Deque<LazyPacket<?, ?>> storage;
    private int sentSinceConfirmation;
    private boolean waitingForConfirmation;
    private long startedWaitingAt;
    private boolean dropped;

    private PlayerLazyPacketManager(MinecraftServer server, UUID playerId, Deque<LazyPacket<?, ?>> storage) {
        this.server = server;
        this.playerId = playerId;
        this.storage = storage;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    LazyPacket<?, ?> getNext() {
        return this.storage.removeFirst();
    }

    boolean hasNext(boolean overCapacity, LazyPacketManager manager) {
        if (this.dropped) {
            return false;
        }
        if (this.waitingForConfirmation && System.currentTimeMillis() - this.startedWaitingAt > 60000L) {
            this.storage.forEach(manager::countSentBytes);
            this.storage.clear();
            ServerPlayer serverPlayer = this.server.m_6846_().m_11259_(this.playerId);
            this.onDropped(serverPlayer);
            OpenPartiesAndClaims.LOGGER.info("Dropped lazy packets for player " + serverPlayer.m_36316_().getName() + " because the client isn't responding. Probably no mod on their side.");
            this.dropped = true;
            return false;
        }
        if (!overCapacity && this.waitingForConfirmation) {
            return false;
        }
        return !this.storage.isEmpty();
    }

    protected void onDropped(ServerPlayer serverPlayer) {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(this.server);
        serverData.getPartyManager().getPartySynchronizer().onLazyPacketsDropped(serverPlayer);
        serverData.getServerClaimsManager().getClaimsManagerSynchronizer().onLazyPacketsDropped(serverPlayer);
    }

    boolean enqueue(LazyPacket<?, ?> packet) {
        if (this.dropped) {
            return false;
        }
        this.storage.addLast(packet);
        return true;
    }

    public void clientConfirm() {
        this.sentSinceConfirmation = 0;
        this.waitingForConfirmation = false;
    }

    public void startWaitingForConfirmation() {
        this.waitingForConfirmation = true;
        this.startedWaitingAt = System.currentTimeMillis();
    }

    public boolean isWaitingForConfirmation() {
        return this.waitingForConfirmation;
    }

    public void onSend(LazyPacket<?, ?> packet) {
        this.sentSinceConfirmation += packet.getPreparedSize();
    }

    public boolean needsConfirmation(int bytesPerConfirmation) {
        return this.sentSinceConfirmation >= bytesPerConfirmation;
    }

    public boolean isClogged() {
        return this.isWaitingForConfirmation() && System.currentTimeMillis() - this.startedWaitingAt > 1000L;
    }

    public static final class Builder {
        private MinecraftServer server;
        private UUID playerId;

        public Builder setDefault() {
            this.setServer(null);
            this.setPlayerId(null);
            return this;
        }

        public Builder setServer(MinecraftServer server) {
            this.server = server;
            return this;
        }

        public Builder setPlayerId(UUID playerId) {
            this.playerId = playerId;
            return this;
        }

        public PlayerLazyPacketManager build() {
            if (this.server == null || this.playerId == null) {
                throw new IllegalStateException();
            }
            return new PlayerLazyPacketManager(this.server, this.playerId, new ConcurrentLinkedDeque());
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

