/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.core;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FrostedIceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.entity.IEntity;
import xaero.pac.common.entity.IItemEntity;
import xaero.pac.common.packet.ClientboundPacDimensionHandshakePacket;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.platform.Services;
import xaero.pac.common.reflect.Reflection;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.claims.protection.ChunkProtection;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.core.accessor.ICreateArmInteractionPoint;
import xaero.pac.common.server.core.accessor.IServerGamePacketListenerImpl;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.world.ServerLevelHelper;

public class ServerCore {
    public static Block DETECTING_ENTITY_BLOCK_COLLISION = null;
    public static BlockPos DETECTING_ENTITY_BLOCK_COLLISION_POS = null;
    private static final Component TRAIN_CONTROLS_MESSAGE = Component.m_237115_((String)"gui.xaero_claims_protection_create_train_controls_protected").m_130938_(s -> s.m_131140_(ChatFormatting.RED));
    public static BlockPos CAPTURED_TARGET_POS;
    public static Map<BlockPos, BlockState> CAPTURED_POS_STATE_MAP;
    private static Level CREATE_DISASSEMBLE_SUPER_GLUE_LEVEL;
    private static BlockPos CREATE_DISASSEMBLE_SUPER_GLUE_ANCHOR;
    private static InteractionHand ENTITY_INTERACTION_HAND;
    public static final BlockPos.MutableBlockPos FROSTWALK_BLOCKPOS;
    private static LivingEntity FROSTWALK_ENTITY;
    private static Level FROSTWALK_LEVEL;
    private static boolean FROSTWALK_CAPTURE_USABLE;
    private static final Field ENTITY_INSIDE_PORTAL_FIELD;
    private static boolean FINDING_RAID_SPAWN_POS;
    private static boolean RAID_SPAWN_POS_CAPTURE_USABLE;
    private static int RAID_SPAWN_POS_CAPTURE_TICK;
    private static LivingEntity DYING_LIVING;
    private static DamageSource DYING_LIVING_FROM;
    private static boolean DYING_LIVING_USABLE;
    private static int DYING_LIVING_TICK;
    private static LivingEntity DROPPING_LOOT_LIVING;
    private static DamageSource DROPPING_LOOT_LIVING_FROM;
    private static boolean DROPPING_LOOT_LIVING_USABLE;
    private static int DROPPING_LOOT_LIVING_TICK;
    private static final String LOOT_OWNER_KEY = "xaero_OPAC_lootOwnerId";
    private static final BiConsumer<IEntity, UUID> LOOT_OWNER_SETTER;
    private static final Function<IEntity, UUID> LOOT_OWNER_GETTER;
    private static final String DEAD_PLAYER_KEY = "xaero_OPAC_deadPlayer";
    private static final BiConsumer<IEntity, UUID> DEAD_PLAYER_SETTER;
    private static final Function<IEntity, UUID> DEAD_PLAYER_GETTER;
    private static final String THROWER_ACCESSOR_KEY = "xaero_OPAC_throwerAccessor";
    private static final BiConsumer<IEntity, UUID> THROWER_ACCESSOR_SETTER;
    private static final Function<IEntity, UUID> THROWER_ACCESSOR_GETTER;
    private static boolean MOB_GRIEFING_IS_FOR_ITEMS;
    private static boolean MOB_GRIEFING_IS_FOR_ITEMS_USABLE;
    private static int MOB_GRIEFING_IS_FOR_ITEMS_TICK;
    private static Entity BEHAVIOR_UTILS_THROW_ITEM_LIVING;
    private static boolean BEHAVIOR_UTILS_THROW_ITEM_USABLE;
    private static int BEHAVIOR_UTILS_THROW_ITEM_TICK;
    private static boolean RESOURCES_DROP_OWNER_CAPTURE_USABLE;
    private static Entity RESOURCES_DROP_OWNER;
    private static int RESOURCES_DROP_OWNER_TICK;

    public static void onServerTickStart(MinecraftServer server) {
        OpenPartiesAndClaims.INSTANCE.startupCrashHandler.check();
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
        if (serverData != null) {
            try {
                serverData.getServerTickHandler().onTick(serverData);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void onServerWorldInfo(ServerPlayer player) {
        OpenPartiesAndClaims.INSTANCE.getPacketHandler().sendToPlayer(player, new ClientboundPacDimensionHandshakePacket((Boolean)ServerConfig.CONFIG.claimsEnabled.get(), (Boolean)ServerConfig.CONFIG.partiesEnabled.get()));
    }

    public static boolean canAddLivingEntityEffect(LivingEntity target, MobEffectInstance effect, @Nullable Entity source) {
        if (source == null || source.m_20194_() == null) {
            return true;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(source.m_20194_());
        if (serverData == null) {
            return true;
        }
        boolean shouldProtect = ((ChunkProtection)serverData.getChunkProtection()).onEntityInteraction(serverData, source, source, (Entity)target, null, null, true, false);
        return !shouldProtect;
    }

    public static boolean canSpreadFire(LevelReader levelReader, BlockPos pos) {
        if (!(levelReader instanceof Level)) {
            return true;
        }
        Level level = (Level)levelReader;
        if (level.m_7654_() == null) {
            return true;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(level.m_7654_());
        if (serverData == null) {
            return true;
        }
        ServerLevel serverLevel = ServerLevelHelper.getServerLevel(level);
        boolean shouldProtect = ((ChunkProtection)serverData.getChunkProtection()).onFireSpread(serverData, serverLevel, pos);
        return !shouldProtect;
    }

    public static boolean mayUseItemAt(Player player, BlockPos pos, Direction direction, ItemStack itemStack) {
        if (player.m_20194_() == null) {
            return true;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(player.m_20194_());
        if (serverData == null) {
            return true;
        }
        ServerLevel serverLevel = ServerLevelHelper.getServerLevel(player.m_9236_());
        boolean shouldProtect = ((ChunkProtection)serverData.getChunkProtection()).onUseItemAt(serverData, (Entity)player, serverLevel, pos, direction, itemStack, null, false, false, true);
        return !shouldProtect;
    }

    public static boolean replaceFluidCanPassThrough(boolean currentValue, BlockGetter blockGetter, BlockPos from, BlockPos to) {
        if (!currentValue) {
            return false;
        }
        if (!(blockGetter instanceof Level)) {
            return true;
        }
        Level level = (Level)blockGetter;
        if (level.m_7654_() == null) {
            return true;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(level.m_7654_());
        if (serverData == null) {
            return true;
        }
        ServerLevel serverLevel = ServerLevelHelper.getServerLevel(level);
        boolean shouldProtect = ((ChunkProtection)serverData.getChunkProtection()).onFluidSpread(serverData, serverLevel, from, to);
        return !shouldProtect;
    }

    public static DispenseItemBehavior replaceDispenseBehavior(DispenseItemBehavior defaultValue, ServerLevel level, BlockPos blockPos) {
        if (defaultValue == DispenseItemBehavior.f_123393_) {
            return defaultValue;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(level.m_7654_());
        if (serverData == null) {
            return defaultValue;
        }
        boolean shouldProtect = ((ChunkProtection)serverData.getChunkProtection()).onDispenseFrom(serverData, level, blockPos);
        return shouldProtect ? DispenseItemBehavior.f_123393_ : defaultValue;
    }

    public static boolean canPistonPush(PistonStructureResolver pistonStructureResolver, Level level, BlockPos pistonPos, Direction direction, boolean extending) {
        if (level.m_7654_() == null) {
            return true;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(level.m_7654_());
        if (serverData == null) {
            return true;
        }
        boolean shouldProtect = ((ChunkProtection)serverData.getChunkProtection()).onPistonPush(serverData, ServerLevelHelper.getServerLevel(level), pistonStructureResolver.m_60436_(), pistonStructureResolver.m_60437_(), pistonPos, direction, extending);
        return !shouldProtect;
    }

    private static boolean isCreateModAllowed(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, Level level, int posChunkX, int posChunkZ, BlockPos sourceOrAnchor, boolean checkNeighborBlocks, boolean affectsBlocks, boolean affectsEntities) {
        boolean shouldProtect = ((ChunkProtection)serverData.getChunkProtection()).onCreateMod(serverData, ServerLevelHelper.getServerLevel(level), posChunkX, posChunkZ, sourceOrAnchor, checkNeighborBlocks, affectsBlocks, affectsEntities);
        return !shouldProtect;
    }

    private static boolean isCreateModAllowed(Level level, BlockPos pos, BlockPos sourceOrAnchor, boolean affectsBlocks, boolean affectsEntities) {
        if (level.m_7654_() == null) {
            return true;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(level.m_7654_());
        if (serverData == null) {
            return true;
        }
        return ServerCore.isCreateModAllowed(serverData, level, pos.m_123341_() >> 4, pos.m_123343_() >> 4, sourceOrAnchor, true, affectsBlocks, affectsEntities);
    }

    public static boolean isCreateModAllowed(Level level, BlockPos pos, BlockPos sourceOrAnchor) {
        if (level.m_7654_() == null) {
            return true;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(level.m_7654_());
        if (serverData == null) {
            return true;
        }
        return ServerCore.isCreateModAllowed(serverData, level, pos.m_123341_() >> 4, pos.m_123343_() >> 4, sourceOrAnchor, true, true, false);
    }

    public static BlockState replaceBlockFetchOnCreateModBreak(BlockState actual, Level level, BlockPos sourceOrAnchor) {
        if (!ServerCore.isCreateModAllowed(level, CAPTURED_TARGET_POS, sourceOrAnchor, true, false)) {
            return Blocks.f_50752_.m_49966_();
        }
        return actual;
    }

    public static void onCreateModSymmetryProcessed(Level level, Player player) {
        if (level.m_7654_() == null) {
            return;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(level.m_7654_());
        if (serverData == null) {
            return;
        }
        if (CAPTURED_POS_STATE_MAP == null) {
            return;
        }
        Iterator<BlockPos> posIterator = CAPTURED_POS_STATE_MAP.keySet().iterator();
        ServerLevel serverLevel = ServerLevelHelper.getServerLevel(level);
        while (posIterator.hasNext()) {
            BlockPos pos = posIterator.next();
            if (!((ChunkProtection)serverData.getChunkProtection()).onEntityPlaceBlock(serverData, (Entity)player, serverLevel, pos, null)) continue;
            posIterator.remove();
        }
    }

    public static boolean canCreateCannonPlaceBlock(BlockEntity placer, BlockPos pos) {
        Level level = placer.m_58904_();
        if (level == null || level.m_7654_() == null) {
            return true;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(level.m_7654_());
        if (serverData == null) {
            return true;
        }
        return ServerCore.isCreateModAllowed(serverData, level, pos.m_123341_() >> 4, pos.m_123343_() >> 4, placer.m_58899_(), false, true, false);
    }

    public static void onCreateCollideEntities(List<Entity> entities, Entity contraption, BlockPos contraptionAnchor) {
        Level level = contraption.m_9236_();
        if (level == null || level.m_7654_() == null) {
            return;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(level.m_7654_());
        if (serverData == null) {
            return;
        }
        ServerLevel serverLevel = ServerLevelHelper.getServerLevel(level);
        ((ChunkProtection)serverData.getChunkProtection()).onCreateModAffectPositionedObjects(serverData, serverLevel, entities, Entity::m_146902_, contraptionAnchor, true, true, false, true);
    }

    public static boolean isCreateMechanicalArmValid(BlockEntity arm, List<ICreateArmInteractionPoint> points) {
        Level level = arm.m_58904_();
        if (level == null || level.m_7654_() == null) {
            return true;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(level.m_7654_());
        if (serverData == null) {
            return true;
        }
        ServerLevel serverLevel = ServerLevelHelper.getServerLevel(level);
        if (((ChunkProtection)serverData.getChunkProtection()).onCreateModAffectPositionedObjects(serverData, serverLevel, points, p -> new ChunkPos(p.xaero_OPAC_getPos()), arm.m_58899_(), false, false, true, false)) {
            points.clear();
            return false;
        }
        return true;
    }

    @Deprecated(forRemoval=true)
    public static boolean isCreateTileEntityPacketAllowed(BlockEntity tileEntity, ServerPlayer player) {
        return ServerCore.isCreateTileEntityPacketAllowed(tileEntity.m_58899_(), player);
    }

    public static boolean isCreateTileEntityPacketAllowed(BlockPos pos, ServerPlayer player) {
        if (pos == null) {
            return true;
        }
        ServerLevel level = player.m_284548_();
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity == null) {
            return true;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(level.m_7654_());
        if (serverData == null) {
            return true;
        }
        boolean shouldProtect = ((ChunkProtection)serverData.getChunkProtection()).onBlockSpecialInteraction(serverData, (Player)player, level, pos);
        return !shouldProtect;
    }

    public static boolean isCreateContraptionInteractionPacketAllowed(int contraptionId, InteractionHand interactionHand, ServerPlayer player) {
        if (player.m_20194_() == null) {
            return true;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(player.m_20194_());
        if (serverData == null) {
            return true;
        }
        Entity contraption = player.m_284548_().m_6815_(contraptionId);
        boolean shouldProtect = ((ChunkProtection)serverData.getChunkProtection()).onEntityInteraction(serverData, null, (Entity)player, contraption, null, interactionHand, false, true);
        return !shouldProtect;
    }

    public static boolean isCreateTrainRelocationPacketAllowed(int contraptionId, BlockPos pos, ServerPlayer player) {
        if (player.m_20194_() == null) {
            return true;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(player.m_20194_());
        if (serverData == null) {
            return true;
        }
        Entity contraption = player.m_284548_().m_6815_(contraptionId);
        boolean shouldProtect = ((ChunkProtection)serverData.getChunkProtection()).onEntityInteraction(serverData, null, (Entity)player, contraption, null, null, false, true);
        if (!shouldProtect) {
            shouldProtect = ((ChunkProtection)serverData.getChunkProtection()).onBlockInteraction(serverData, (Entity)player, null, null, player.m_284548_(), pos, Direction.UP, false, true);
        }
        return !shouldProtect;
    }

    public static boolean isCreateTrainControlsPacketAllowed(int contraptionId, ServerPlayer player) {
        if (player.m_20194_() == null) {
            return true;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(player.m_20194_());
        if (serverData == null) {
            return true;
        }
        Entity contraption = player.m_284548_().m_6815_(contraptionId);
        boolean shouldProtect = ((ChunkProtection)serverData.getChunkProtection()).onEntityInteraction(serverData, null, (Entity)player, contraption, null, null, false, false);
        if (shouldProtect) {
            player.m_213846_(serverData.getAdaptiveLocalizer().getFor(player, TRAIN_CONTROLS_MESSAGE));
        }
        return !shouldProtect;
    }

    public static boolean isCreateDeployerBlockInteractionAllowed(Level level, BlockPos anchor, BlockPos pos) {
        return ServerCore.isCreateModAllowed(level, pos, anchor, true, true);
    }

    public static boolean isCreateTileDeployerBlockInteractionAllowed(BlockEntity tileEntity) {
        Direction direction = (Direction)tileEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        BlockPos pos = tileEntity.m_58899_().m_5484_(direction, 2);
        return ServerCore.isCreateDeployerBlockInteractionAllowed(tileEntity.m_58904_(), tileEntity.m_58899_(), pos);
    }

    public static boolean isCreateGlueSelectionAllowed(BlockPos from, BlockPos to, ServerPlayer player) {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(player.m_20194_());
        if (serverData == null) {
            return true;
        }
        boolean shouldProtect = ((ChunkProtection)serverData.getChunkProtection()).onCreateGlueSelection(serverData, from, to, player);
        return !shouldProtect;
    }

    public static boolean isCreateGlueRemovalAllowed(int entityId, ServerPlayer player) {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(player.m_20194_());
        if (serverData == null) {
            return true;
        }
        boolean shouldProtect = ((ChunkProtection)serverData.getChunkProtection()).onCreateGlueRemoval(serverData, entityId, player);
        return !shouldProtect;
    }

    public static boolean isProjectileHitAllowed(Projectile entity, EntityHitResult hitResult) {
        Entity target = hitResult.m_82443_();
        if (target.m_20194_() == null) {
            return true;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(target.m_20194_());
        if (serverData == null) {
            return true;
        }
        boolean shouldProtect = ((ChunkProtection)serverData.getChunkProtection()).onEntityInteraction(serverData, entity.m_19749_(), (Entity)entity, target, null, null, true, false);
        return !shouldProtect;
    }

    public static void preCreateDisassembleSuperGlue(Level level, BlockPos anchor) {
        CREATE_DISASSEMBLE_SUPER_GLUE_LEVEL = level;
        CREATE_DISASSEMBLE_SUPER_GLUE_ANCHOR = anchor;
    }

    public static void postCreateDisassembleSuperGlue() {
        CREATE_DISASSEMBLE_SUPER_GLUE_LEVEL = null;
        CREATE_DISASSEMBLE_SUPER_GLUE_ANCHOR = null;
    }

    public static BlockPos getFreshAddedSuperGlueAnchor(Level level) {
        if (level != null && level == CREATE_DISASSEMBLE_SUPER_GLUE_LEVEL) {
            return CREATE_DISASSEMBLE_SUPER_GLUE_ANCHOR;
        }
        return null;
    }

    public static boolean canInteract(ServerGamePacketListenerImpl packetListener, ServerboundInteractPacket packet) {
        ENTITY_INTERACTION_HAND = null;
        packet.m_179617_(new ServerboundInteractPacket.Handler(){

            public void m_142299_(@Nonnull InteractionHand interactionHand) {
            }

            public void m_142143_(@Nonnull InteractionHand interactionHand, @Nonnull Vec3 vec3) {
                ENTITY_INTERACTION_HAND = interactionHand;
            }

            public void m_141994_() {
            }
        });
        if (ENTITY_INTERACTION_HAND == null) {
            return true;
        }
        ServerPlayer player = packetListener.f_9743_;
        ServerLevel level = player.m_284548_();
        Entity entity = packet.m_179603_(level);
        if (entity == null) {
            return true;
        }
        return !OpenPartiesAndClaims.INSTANCE.getCommonEvents().onInteractEntitySpecific((Entity)player, entity, ENTITY_INTERACTION_HAND);
    }

    public static boolean replaceEntityIsInvulnerable(boolean actual, DamageSource damageSource, Entity entity) {
        if (!actual) {
            return OpenPartiesAndClaims.INSTANCE.getCommonEvents().onLivingHurt(damageSource, entity);
        }
        return actual;
    }

    public static boolean canDestroyBlock(Level level, BlockPos pos, Entity entity) {
        return entity == null || !OpenPartiesAndClaims.INSTANCE.getCommonEvents().onEntityDestroyBlock(level, pos, entity);
    }

    public static void onEntitiesPushBlock(List<? extends Entity> entities, Block block, BlockPos pos) {
        if (entities.isEmpty() || entities.get(0).m_20194_() == null) {
            return;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(entities.get(0).m_20194_());
        if (serverData == null) {
            return;
        }
        ((ChunkProtection)serverData.getChunkProtection()).onEntitiesPushBlock(serverData, ServerLevelHelper.getServerLevel(entities.get(0).m_9236_()), pos, block, entities);
    }

    public static boolean onEntityPushBlock(Block block, Entity entity, BlockHitResult blockHitResult) {
        if (entity == null || entity.m_20194_() == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(entity.m_20194_());
        if (serverData == null) {
            return false;
        }
        ArrayList helpList = Lists.newArrayList((Object[])new Entity[]{entity});
        ((ChunkProtection)serverData.getChunkProtection()).onEntitiesPushBlock(serverData, ServerLevelHelper.getServerLevel(entity.m_9236_()), blockHitResult.m_82425_(), block, helpList);
        return helpList.isEmpty();
    }

    public static boolean isHandlingFrostWalk() {
        return FROSTWALK_ENTITY != null;
    }

    public static boolean preFrostWalkHandle(LivingEntity living, Level level) {
        if (level.m_7654_() == null) {
            return false;
        }
        if (((Boolean)ServerConfig.CONFIG.completelyDisableFrostWalking.get()).booleanValue()) {
            return true;
        }
        if (!FROSTWALK_CAPTURE_USABLE) {
            return false;
        }
        if (FROSTWALK_ENTITY != null) {
            OpenPartiesAndClaims.LOGGER.error("Frost walk capture isn't working properly. Likely a compatibility issue. Turning off frost walking protection... Please use the option in the main server config file to disable frost walking across the server.");
            FROSTWALK_CAPTURE_USABLE = false;
            ServerCore.postFrostWalkHandle(level);
            return false;
        }
        FROSTWALK_ENTITY = living;
        FROSTWALK_LEVEL = level;
        return false;
    }

    public static BlockPos preBlockStateFetchOnFrostwalk(BlockPos pos) {
        if (FROSTWALK_ENTITY == null || FROSTWALK_LEVEL.m_7654_() == null || !FROSTWALK_LEVEL.m_7654_().m_18695_()) {
            return pos;
        }
        BlockState actualState = FROSTWALK_LEVEL.m_8055_(pos);
        if (actualState != FrostedIceBlock.m_278844_()) {
            return pos;
        }
        FROSTWALK_BLOCKPOS.m_122190_((Vec3i)pos);
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(FROSTWALK_LEVEL.m_7654_());
        if (serverData == null) {
            return pos;
        }
        ServerLevel serverLevel = ServerLevelHelper.getServerLevel(FROSTWALK_LEVEL);
        if (((ChunkProtection)serverData.getChunkProtection()).onFrostWalk(serverData, FROSTWALK_ENTITY, serverLevel, (BlockPos)FROSTWALK_BLOCKPOS)) {
            return FROSTWALK_BLOCKPOS.m_142448_(FROSTWALK_LEVEL.m_151558_());
        }
        return pos;
    }

    public static void postFrostWalkHandle(Level level) {
        if (level.m_7654_() == null) {
            return;
        }
        FROSTWALK_ENTITY = null;
        FROSTWALK_LEVEL = null;
    }

    public static boolean onHandleNetherPortal(Entity entity) {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(entity.m_20194_());
        if (serverData == null) {
            return false;
        }
        ServerLevel serverLevel = ServerLevelHelper.getServerLevel(entity.m_9236_());
        if (((ChunkProtection)serverData.getChunkProtection()).onNetherPortal(serverData, entity, serverLevel, entity.m_20183_())) {
            entity.m_9236_().m_46473_().m_7238_();
            Reflection.setReflectFieldValue(entity, ENTITY_INSIDE_PORTAL_FIELD, false);
            return true;
        }
        return false;
    }

    public static void onFindRandomSpawnPosPre(Raid raid) {
        if (!RAID_SPAWN_POS_CAPTURE_USABLE) {
            return;
        }
        FINDING_RAID_SPAWN_POS = true;
        RAID_SPAWN_POS_CAPTURE_TICK = raid.m_37769_().m_7654_().m_129921_();
    }

    public static void onFindRandomSpawnPosPost() {
        FINDING_RAID_SPAWN_POS = false;
    }

    public static boolean replaceIsPositionEntityTicking(boolean currentReturn, ServerLevel level, BlockPos pos) {
        if (!currentReturn) {
            return false;
        }
        if (FINDING_RAID_SPAWN_POS) {
            if (level.m_7654_().m_129921_() != RAID_SPAWN_POS_CAPTURE_TICK) {
                OpenPartiesAndClaims.LOGGER.error("Raid spawn capture isn't working properly. Likely a compatibility issue. Turning off raid protection... Please use the disableRaids game rule to disable raids across the server.");
                RAID_SPAWN_POS_CAPTURE_USABLE = false;
                ServerCore.onFindRandomSpawnPosPost();
                return false;
            }
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(level.m_7654_());
            if (serverData == null) {
                return true;
            }
            return !((ChunkProtection)serverData.getChunkProtection()).onRaidSpawn(serverData, level, pos);
        }
        return true;
    }

    public static void onLivingEntityDiePre(LivingEntity living, DamageSource source) {
        if (living.m_20194_() != null && DYING_LIVING == null && DYING_LIVING_USABLE) {
            DYING_LIVING_FROM = source;
            DYING_LIVING = living;
            DYING_LIVING_TICK = living.m_20194_().m_129921_();
        }
    }

    public static void onLivingEntityDiePost(LivingEntity living) {
        if (living.m_20194_() != null && DYING_LIVING == living) {
            DYING_LIVING_FROM = null;
            DYING_LIVING = null;
        }
    }

    public static void onLivingEntityDropDeathLootPre(LivingEntity living, DamageSource source) {
        if (living.m_20194_() != null && DROPPING_LOOT_LIVING == null && DROPPING_LOOT_LIVING_USABLE) {
            DROPPING_LOOT_LIVING_FROM = source;
            DROPPING_LOOT_LIVING = living;
            DROPPING_LOOT_LIVING_TICK = living.m_20194_().m_129921_();
        }
    }

    public static void onLivingEntityDropDeathLootPost(LivingEntity living) {
        if (living.m_20194_() != null && DROPPING_LOOT_LIVING == living) {
            DROPPING_LOOT_LIVING_FROM = null;
            DROPPING_LOOT_LIVING = null;
        }
    }

    private static void testLivingLootCapture(int currentTickCount) {
        boolean disabledCapture = false;
        if (DYING_LIVING_FROM != null && DYING_LIVING_TICK != currentTickCount) {
            disabledCapture = !DROPPING_LOOT_LIVING_USABLE;
            DYING_LIVING_USABLE = false;
            DYING_LIVING_FROM = null;
            DYING_LIVING = null;
        }
        if (DROPPING_LOOT_LIVING_FROM != null && DROPPING_LOOT_LIVING_TICK != currentTickCount) {
            disabledCapture = !DYING_LIVING_USABLE;
            DROPPING_LOOT_LIVING_USABLE = false;
            DROPPING_LOOT_LIVING_FROM = null;
            DROPPING_LOOT_LIVING = null;
        }
        if (disabledCapture) {
            OpenPartiesAndClaims.LOGGER.error("Living entity loot capture isn't working properly. Likely a compatibility issue. Turning off loot-related protection... Please use keepInventory and other stuff, if this is an issue.");
        }
    }

    public static DamageSource getDyingDamageSourceForCurrentEntitySpawns(int currentTickCount) {
        ServerCore.testLivingLootCapture(currentTickCount);
        if (DYING_LIVING_FROM != null) {
            return DYING_LIVING_FROM;
        }
        return DROPPING_LOOT_LIVING_FROM;
    }

    public static LivingEntity getDyingLivingForCurrentEntitySpawns(int currentTickCount) {
        ServerCore.testLivingLootCapture(currentTickCount);
        if (DYING_LIVING != null) {
            return DYING_LIVING;
        }
        return DROPPING_LOOT_LIVING;
    }

    public static void setEntityGenericUUID(Entity entity, String key, UUID uuid, BiConsumer<IEntity, UUID> setter) {
        setter.accept((IEntity)entity, uuid);
        CompoundTag persistentData = Services.PLATFORM.getEntityAccess().getPersistentData(entity);
        if (uuid == null) {
            persistentData.m_128473_(key);
        } else {
            persistentData.m_128362_(key, uuid);
        }
    }

    public static UUID getEntityGenericUUID(Entity entity, String key, Function<IEntity, UUID> getter, BiConsumer<IEntity, UUID> setter) {
        CompoundTag persistentData;
        UUID result = getter.apply((IEntity)entity);
        if (result == null && (persistentData = Services.PLATFORM.getEntityAccess().getPersistentData(entity)).m_128441_(key)) {
            result = persistentData.m_128342_(key);
            setter.accept((IEntity)entity, result);
        }
        return result;
    }

    public static void setLootOwner(Entity entity, UUID lootOwner) {
        ServerCore.setEntityGenericUUID(entity, LOOT_OWNER_KEY, lootOwner, LOOT_OWNER_SETTER);
    }

    public static UUID getLootOwner(Entity entity) {
        return ServerCore.getEntityGenericUUID(entity, LOOT_OWNER_KEY, LOOT_OWNER_GETTER, LOOT_OWNER_SETTER);
    }

    public static void setDeadPlayer(Entity entity, UUID deadPlayer) {
        ServerCore.setEntityGenericUUID(entity, DEAD_PLAYER_KEY, deadPlayer, DEAD_PLAYER_SETTER);
    }

    public static UUID getDeadPlayer(Entity entity) {
        return ServerCore.getEntityGenericUUID(entity, DEAD_PLAYER_KEY, DEAD_PLAYER_GETTER, DEAD_PLAYER_SETTER);
    }

    public static void setThrowerAccessor(ItemEntity entity, UUID throwerAccessor) {
        ServerCore.setEntityGenericUUID((Entity)entity, THROWER_ACCESSOR_KEY, throwerAccessor, THROWER_ACCESSOR_SETTER);
    }

    public static UUID getThrowerAccessor(ItemEntity entity) {
        return ServerCore.getEntityGenericUUID((Entity)entity, THROWER_ACCESSOR_KEY, THROWER_ACCESSOR_GETTER, THROWER_ACCESSOR_SETTER);
    }

    public static boolean onEntityItemPickup(Entity entity, ItemEntity itemEntity) {
        return OpenPartiesAndClaims.INSTANCE.getCommonEvents().onItemPickup(entity, itemEntity);
    }

    public static boolean onMobItemPickup(ItemEntity itemEntity, Mob mob) {
        if (OpenPartiesAndClaims.INSTANCE.getCommonEvents().onItemPickup((Entity)mob, itemEntity)) {
            mob.m_9236_().m_46473_().m_7238_();
            return true;
        }
        return false;
    }

    public static Player onExperiencePickup(Player player, ExperienceOrb orb) {
        if (orb == null || player == null) {
            return player;
        }
        if (orb.m_20194_() == null) {
            return player;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(orb.m_20194_());
        if (serverData == null) {
            return player;
        }
        if (((ChunkProtection)serverData.getChunkProtection()).onExperiencePickup(serverData, orb, player)) {
            return null;
        }
        return player;
    }

    public static void forgePreItemMobGriefingCheck(Mob mob) {
        if (!MOB_GRIEFING_IS_FOR_ITEMS_USABLE) {
            return;
        }
        if (mob.m_20194_() != null) {
            MOB_GRIEFING_IS_FOR_ITEMS = true;
            MOB_GRIEFING_IS_FOR_ITEMS_TICK = mob.m_20194_().m_129921_();
        }
    }

    public static void forgePostItemMobGriefingCheck(Mob mob) {
        if (mob.m_20194_() != null) {
            MOB_GRIEFING_IS_FOR_ITEMS = false;
        }
    }

    public static boolean isMobGriefingForItems(int currentTick) {
        if (MOB_GRIEFING_IS_FOR_ITEMS && MOB_GRIEFING_IS_FOR_ITEMS_TICK != currentTick) {
            OpenPartiesAndClaims.LOGGER.error("Mob griefing rule check for item pickups capture is not working properly. Turning it off... If this is a problem, please manually configure which mobs grief dropped items in the main server config file with options \"nonBlockGriefingMobs\" and \"droppedItemGriefingMobs\".");
            MOB_GRIEFING_IS_FOR_ITEMS_USABLE = false;
            MOB_GRIEFING_IS_FOR_ITEMS = false;
        }
        return MOB_GRIEFING_IS_FOR_ITEMS;
    }

    public static void preThrowItem(Entity entity) {
        if (!BEHAVIOR_UTILS_THROW_ITEM_USABLE) {
            return;
        }
        if (entity != null && entity.m_20194_() != null) {
            if (BEHAVIOR_UTILS_THROW_ITEM_LIVING == null) {
                BEHAVIOR_UTILS_THROW_ITEM_LIVING = entity;
                BEHAVIOR_UTILS_THROW_ITEM_TICK = entity.m_20194_().m_129921_();
            } else if (BEHAVIOR_UTILS_THROW_ITEM_TICK != entity.m_20194_().m_129921_()) {
                OpenPartiesAndClaims.LOGGER.error("Part of the non-player entity item toss capture isn't working properly. Turning it off...");
                BEHAVIOR_UTILS_THROW_ITEM_USABLE = false;
                BEHAVIOR_UTILS_THROW_ITEM_LIVING = null;
            }
        }
    }

    public static void onThrowItem(ItemEntity itemEntity) {
        if (BEHAVIOR_UTILS_THROW_ITEM_LIVING != null && itemEntity.m_20194_() != null) {
            itemEntity.m_32052_(BEHAVIOR_UTILS_THROW_ITEM_LIVING.m_20148_());
            BEHAVIOR_UTILS_THROW_ITEM_LIVING = null;
        }
    }

    public static void preResourcesDrop(Entity entity) {
        if (RESOURCES_DROP_OWNER_CAPTURE_USABLE && RESOURCES_DROP_OWNER == null && entity != null && entity.m_20194_() != null) {
            RESOURCES_DROP_OWNER = entity;
            RESOURCES_DROP_OWNER_TICK = entity.m_20194_().m_129921_();
        }
    }

    public static void postResourcesDrop(Entity entity) {
        if (entity == RESOURCES_DROP_OWNER) {
            RESOURCES_DROP_OWNER = null;
        }
    }

    public static Entity getResourcesDropOwner() {
        if (RESOURCES_DROP_OWNER != null && RESOURCES_DROP_OWNER_TICK != RESOURCES_DROP_OWNER.m_20194_().m_129921_()) {
            OpenPartiesAndClaims.LOGGER.error("Block/entity resource drop owner capture isn't working properly. Likely a compatibility issue. Turning it off...");
            RESOURCES_DROP_OWNER = null;
            RESOURCES_DROP_OWNER_CAPTURE_USABLE = false;
        }
        return RESOURCES_DROP_OWNER;
    }

    public static void onFishingHookAddEntity(Entity entity, FishingHook hook) {
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            ServerCore.preThrowItem(hook.m_19749_());
            ServerCore.onThrowItem(itemEntity);
        }
    }

    public static boolean onItemMerge(ItemEntity first, ItemEntity second) {
        if (first.m_20194_() == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(first.m_20194_());
        if (serverData == null) {
            return false;
        }
        return ((ChunkProtection)serverData.getChunkProtection()).onItemStackMerge(serverData, first, second);
    }

    public static boolean onExperienceMerge(ExperienceOrb from, ExperienceOrb into) {
        if (into.m_20194_() == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(into.m_20194_());
        if (serverData == null) {
            return false;
        }
        return ((ChunkProtection)serverData.getChunkProtection()).onExperienceMerge(serverData, from, into);
    }

    public static boolean onSetFishingHookedEntity(FishingHook hook, Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity.m_20194_() == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(entity.m_20194_());
        if (serverData == null) {
            return false;
        }
        return ((ChunkProtection)serverData.getChunkProtection()).onFishingHookedEntity(serverData, hook, entity);
    }

    public static List<Entity> onEntitiesPushEntity(List<Entity> entities, Entity target) {
        if (target == null) {
            return entities;
        }
        if (target.m_20194_() == null) {
            return entities;
        }
        if (entities.isEmpty()) {
            return entities;
        }
        if (!(target instanceof HangingEntity)) {
            return entities;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(target.m_20194_());
        if (serverData == null) {
            return entities;
        }
        ((ChunkProtection)serverData.getChunkProtection()).onEntitiesCollideWithEntity(serverData, target, entities);
        return entities;
    }

    public static List<Entity> onEntityAffectsEntities(List<Entity> targets, Entity entity) {
        if (entity == null) {
            return targets;
        }
        if (entity.m_20194_() == null) {
            return targets;
        }
        if (targets.isEmpty()) {
            return targets;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(entity.m_20194_());
        if (serverData == null) {
            return targets;
        }
        ((ChunkProtection)serverData.getChunkProtection()).onEntityAffectsEntities(serverData, entity, targets);
        return targets;
    }

    public static boolean onEntityPushed(Entity target, MoverType moverType) {
        if (target == null) {
            return false;
        }
        if (target.m_20194_() == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(target.m_20194_());
        if (serverData == null) {
            return false;
        }
        return ((ChunkProtection)serverData.getChunkProtection()).onEntityPushed(serverData, target, moverType);
    }

    public static void preServerLevelTick(ServerLevel level) {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(level.m_7654_());
        if (serverData == null) {
            return;
        }
        if (serverData.getForceLoadManager().hasEnabledTickets(level)) {
            level.m_8886_();
        }
    }

    public static UUID getItemEntityThrower(ItemEntity itemEntity) {
        return ((IItemEntity)itemEntity).getXaero_OPAC_thrower();
    }

    public static UUID getItemEntityOwner(ItemEntity itemEntity) {
        return ((IItemEntity)itemEntity).getXaero_OPAC_target();
    }

    public static Connection getServerGamePacketListenerConnection(ServerGamePacketListenerImpl serverGamePacketListener) {
        return ((IServerGamePacketListenerImpl)serverGamePacketListener).getXaero_OPAC_connection();
    }

    public static void beforePressurePlateCheckPressed(Level level, Block block, BlockPos blockPos) {
        if (level instanceof ServerLevel) {
            DETECTING_ENTITY_BLOCK_COLLISION = block;
            DETECTING_ENTITY_BLOCK_COLLISION_POS = blockPos;
        }
    }

    public static void afterPressurePlateCheckPressed(Level level) {
        if (level instanceof ServerLevel) {
            DETECTING_ENTITY_BLOCK_COLLISION = null;
        }
    }

    public static void reset() {
        CAPTURED_TARGET_POS = null;
        CAPTURED_POS_STATE_MAP = null;
        ENTITY_INTERACTION_HAND = null;
        FROSTWALK_ENTITY = null;
        FROSTWALK_LEVEL = null;
        FINDING_RAID_SPAWN_POS = false;
        DYING_LIVING = null;
        DYING_LIVING_FROM = null;
        DROPPING_LOOT_LIVING = null;
        DROPPING_LOOT_LIVING_FROM = null;
        MOB_GRIEFING_IS_FOR_ITEMS = false;
        BEHAVIOR_UTILS_THROW_ITEM_LIVING = null;
        RESOURCES_DROP_OWNER = null;
        DETECTING_ENTITY_BLOCK_COLLISION = null;
        DETECTING_ENTITY_BLOCK_COLLISION_POS = null;
    }

    static {
        FROSTWALK_BLOCKPOS = new BlockPos.MutableBlockPos();
        FROSTWALK_CAPTURE_USABLE = true;
        ENTITY_INSIDE_PORTAL_FIELD = Reflection.getFieldReflection(Entity.class, "f_19817_", "field_5963", "Z");
        RAID_SPAWN_POS_CAPTURE_USABLE = true;
        DYING_LIVING_USABLE = true;
        DROPPING_LOOT_LIVING_USABLE = true;
        LOOT_OWNER_SETTER = IEntity::setXaero_OPAC_lootOwner;
        LOOT_OWNER_GETTER = IEntity::getXaero_OPAC_lootOwner;
        DEAD_PLAYER_SETTER = IEntity::setXaero_OPAC_deadPlayer;
        DEAD_PLAYER_GETTER = IEntity::getXaero_OPAC_deadPlayer;
        THROWER_ACCESSOR_SETTER = (ie, id) -> ((IItemEntity)((Object)ie)).setXaero_OPAC_throwerAccessor((UUID)id);
        THROWER_ACCESSOR_GETTER = ie -> ((IItemEntity)((Object)ie)).getXaero_OPAC_throwerAccessor();
        MOB_GRIEFING_IS_FOR_ITEMS_USABLE = true;
        BEHAVIOR_UTILS_THROW_ITEM_USABLE = true;
        RESOURCES_DROP_OWNER_CAPTURE_USABLE = true;
    }
}

