/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.parties;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.parties.party.IClientParty;
import xaero.pac.client.parties.party.IClientPartyStorage;
import xaero.pac.common.packet.parties.PartyPlayerInfoCodec;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.PartyPlayerInfo;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.PartyInvite;
import xaero.pac.common.parties.party.member.PartyMember;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundPartyPlayerPacket
extends LazyPacket<Codec, ClientboundPartyPlayerPacket> {
    public static final Codec CODEC = new Codec(new PartyPlayerInfoCodec());
    private final Type type;
    private final Action action;
    private final IPartyPlayerInfo playerInfo;

    public ClientboundPartyPlayerPacket(Type type, Action action, IPartyPlayerInfo playerInfo) {
        this.type = type;
        this.action = action;
        this.playerInfo = playerInfo;
    }

    @Override
    protected Codec getEncoder() {
        return CODEC;
    }

    @Override
    protected void writeOnPrepare(Codec encoder, FriendlyByteBuf u) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("t", this.type.toString());
        tag.m_128359_("a", this.action.toString());
        CompoundTag playerTag = this.type == Type.INVITE ? encoder.playerInfoCodec.toPartyInviteTag((PartyInvite)this.playerInfo) : encoder.playerInfoCodec.toMemberTag((PartyMember)this.playerInfo);
        tag.m_128365_("pi", (Tag)playerTag);
        u.m_130079_(tag);
    }

    public String toString() {
        return String.format("[%s, %s, %s]", new Object[]{this.type, this.action, this.playerInfo.getUsername()});
    }

    public static enum Type {
        MEMBER,
        INVITE,
        OWNER;

    }

    public static enum Action {
        ADD,
        REMOVE,
        UPDATE;

    }

    protected static class Codec
    extends LazyPacket.Encoder<ClientboundPartyPlayerPacket>
    implements Function<FriendlyByteBuf, ClientboundPartyPlayerPacket> {
        private final PartyPlayerInfoCodec playerInfoCodec;

        public Codec(PartyPlayerInfoCodec playerInfoCodec) {
            this.playerInfoCodec = playerInfoCodec;
        }

        @Override
        public ClientboundPartyPlayerPacket apply(FriendlyByteBuf input) {
            try {
                PartyInvite playerInfo;
                if (input.readableBytes() > 102400) {
                    return null;
                }
                CompoundTag tag = input.m_130261_();
                if (tag == null) {
                    return null;
                }
                String typeString = tag.m_128461_("t");
                if (typeString.isEmpty() || typeString.length() > 128) {
                    return null;
                }
                Type type = Type.valueOf(typeString);
                String actionString = tag.m_128461_("a");
                if (actionString.isEmpty() || actionString.length() > 128) {
                    return null;
                }
                Action action = Action.valueOf(actionString);
                CompoundTag playerTag = tag.m_128469_("pi");
                PartyPlayerInfo partyPlayerInfo = type == Type.INVITE ? this.playerInfoCodec.fromPartyInviteTag(playerTag) : (playerInfo = this.playerInfoCodec.fromMemberTag(playerTag, type == Type.OWNER));
                if (playerInfo == null) {
                    OpenPartiesAndClaims.LOGGER.info("Received party player packet with invalid data.");
                    return null;
                }
                return new ClientboundPartyPlayerPacket(type, action, playerInfo);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet ", t);
                return null;
            }
        }
    }

    public static class ClientHandler
    implements Consumer<ClientboundPartyPlayerPacket> {
        @Override
        public void accept(ClientboundPartyPlayerPacket t) {
            IClientParty party = (IClientParty)((IClientPartyStorage)OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage()).getParty();
            if (party == null) {
                return;
            }
            if (t.type == Type.MEMBER) {
                IPartyMember memberInfo = (IPartyMember)t.playerInfo;
                if (t.action == Action.ADD) {
                    party.addMember(memberInfo.getUUID(), memberInfo.getRank(), memberInfo.getUsername());
                } else {
                    party.removeMember(memberInfo.getUUID());
                }
                if (t.action == Action.UPDATE) {
                    party.addMember(memberInfo.getUUID(), memberInfo.getRank(), memberInfo.getUsername());
                }
            } else if (t.type == Type.OWNER) {
                if (t.action != Action.UPDATE) {
                    OpenPartiesAndClaims.LOGGER.info("Received invalid party owner update packet!");
                    return;
                }
                IPartyMember newInfo = (IPartyMember)t.playerInfo;
                IPartyMember owner = (IPartyMember)party.getOwner();
                if (owner.getUUID() != newInfo.getUUID()) {
                    party.changeOwner(newInfo.getUUID(), newInfo.getUsername());
                } else {
                    ((PartyMember)party.getOwner()).setUsername(newInfo.getUsername());
                }
            } else if (t.action == Action.ADD) {
                party.invitePlayer(t.playerInfo.getUUID(), t.playerInfo.getUsername());
            } else if (t.action == Action.REMOVE) {
                party.uninvitePlayer(t.playerInfo.getUUID());
            } else {
                OpenPartiesAndClaims.LOGGER.info("Received invalid party invites update packet!");
                return;
            }
        }
    }
}

