/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundClaimsClaimUpdatePacket
extends LazyPacket<LazyPacket.Encoder<ClientboundClaimsClaimUpdatePacket>, ClientboundClaimsClaimUpdatePacket> {
    public static final LazyPacket.Encoder<ClientboundClaimsClaimUpdatePacket> ENCODER = new LazyPacket.Encoder();
    private final ResourceLocation dimension;
    private final int x;
    private final int z;
    private final UUID playerId;
    private final int subConfigIndex;
    private final boolean forceLoaded;
    private final int claimSyncIndex;

    public ClientboundClaimsClaimUpdatePacket(ResourceLocation dimension, int x, int z, UUID playerId, int subConfigIndex, boolean forceLoaded, int claimSyncIndex) {
        this.dimension = dimension;
        this.x = x;
        this.z = z;
        this.playerId = playerId;
        this.subConfigIndex = subConfigIndex;
        this.forceLoaded = forceLoaded;
        this.claimSyncIndex = claimSyncIndex;
    }

    @Override
    protected LazyPacket.Encoder<ClientboundClaimsClaimUpdatePacket> getEncoder() {
        return ENCODER;
    }

    @Override
    protected void writeOnPrepare(LazyPacket.Encoder<ClientboundClaimsClaimUpdatePacket> encoder, FriendlyByteBuf u) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("d", this.dimension.toString());
        nbt.m_128405_("x", this.x);
        nbt.m_128405_("z", this.z);
        if (this.playerId != null) {
            nbt.m_128405_("i", this.claimSyncIndex);
            nbt.m_128362_("p", this.playerId);
            nbt.m_128405_("s", this.subConfigIndex);
            nbt.m_128379_("f", this.forceLoaded);
        }
        u.m_130079_(nbt);
    }

    public String toString() {
        return String.format("[%s, %d, %d, %s, %s, %d, %d]", this.dimension, this.x, this.z, this.playerId, this.forceLoaded, this.subConfigIndex, this.claimSyncIndex);
    }

    public static class ClientHandler
    implements Consumer<ClientboundClaimsClaimUpdatePacket> {
        @Override
        public void accept(ClientboundClaimsClaimUpdatePacket t) {
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onClaimUpdate(t.dimension, t.x, t.z, t.playerId, t.subConfigIndex, t.forceLoaded, t.claimSyncIndex);
        }
    }

    public static class Decoder
    implements Function<FriendlyByteBuf, ClientboundClaimsClaimUpdatePacket> {
        @Override
        public ClientboundClaimsClaimUpdatePacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 10000) {
                    return null;
                }
                CompoundTag nbt = input.m_130261_();
                if (nbt == null) {
                    return null;
                }
                String dimensionString = nbt.m_128461_("d");
                if (dimensionString.isEmpty() || dimensionString.length() > 2048) {
                    return null;
                }
                int x = nbt.m_128451_("x");
                int z = nbt.m_128451_("z");
                int claimStateIndex = -1;
                UUID playerId = null;
                int subConfigIndex = -1;
                boolean forceload = false;
                if (nbt.m_128441_("p")) {
                    claimStateIndex = nbt.m_128451_("i");
                    playerId = nbt.m_128342_("p");
                    subConfigIndex = nbt.m_128451_("s");
                    forceload = nbt.m_128471_("f");
                }
                return new ClientboundClaimsClaimUpdatePacket(new ResourceLocation(dimensionString), x, z, playerId, subConfigIndex, forceload, claimStateIndex);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet", t);
                return null;
            }
        }
    }
}

