/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundClaimLimitsPacket
extends LazyPacket<LazyPacket.Encoder<ClientboundClaimLimitsPacket>, ClientboundClaimLimitsPacket> {
    public static final LazyPacket.Encoder<ClientboundClaimLimitsPacket> ENCODER = new LazyPacket.Encoder();
    private final int loadingClaimCount;
    private final int loadingForceloadCount;
    private final int claimLimit;
    private final int forceloadLimit;
    private final int maxClaimDistance;
    private final boolean alwaysUseLoadingValues;

    public ClientboundClaimLimitsPacket(int loadingClaimCount, int loadingForceloadCount, int claimLimit, int forceloadLimit, int maxClaimDistance, boolean alwaysUseLoadingValues) {
        this.loadingClaimCount = loadingClaimCount;
        this.loadingForceloadCount = loadingForceloadCount;
        this.claimLimit = claimLimit;
        this.forceloadLimit = forceloadLimit;
        this.maxClaimDistance = maxClaimDistance;
        this.alwaysUseLoadingValues = alwaysUseLoadingValues;
    }

    @Override
    protected void writeOnPrepare(LazyPacket.Encoder<ClientboundClaimLimitsPacket> encoder, FriendlyByteBuf u) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("cc", this.loadingClaimCount);
        tag.m_128405_("fc", this.loadingForceloadCount);
        tag.m_128405_("cl", this.claimLimit);
        tag.m_128405_("fl", this.forceloadLimit);
        tag.m_128405_("d", this.maxClaimDistance);
        tag.m_128379_("a", this.alwaysUseLoadingValues);
        u.m_130079_(tag);
    }

    @Override
    protected LazyPacket.Encoder<ClientboundClaimLimitsPacket> getEncoder() {
        return ENCODER;
    }

    public static class ClientHandler
    implements Consumer<ClientboundClaimLimitsPacket> {
        @Override
        public void accept(ClientboundClaimLimitsPacket t) {
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onClaimLimits(t.loadingClaimCount, t.loadingForceloadCount, t.claimLimit, t.forceloadLimit, t.maxClaimDistance, t.alwaysUseLoadingValues);
        }
    }

    public static class Decoder
    implements Function<FriendlyByteBuf, ClientboundClaimLimitsPacket> {
        @Override
        public ClientboundClaimLimitsPacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 2048) {
                    return null;
                }
                CompoundTag tag = input.m_130261_();
                if (tag == null) {
                    return null;
                }
                int loadingClaimCount = tag.m_128451_("cc");
                int loadingForceloadCount = tag.m_128451_("fc");
                int claimLimit = tag.m_128451_("cl");
                int forceloadLimit = tag.m_128451_("fl");
                int maxClaimDistance = tag.m_128451_("d");
                boolean alwaysUseLoadingValues = tag.m_128471_("a");
                return new ClientboundClaimLimitsPacket(loadingClaimCount, loadingForceloadCount, claimLimit, forceloadLimit, maxClaimDistance, alwaysUseLoadingValues);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet ", t);
                return null;
            }
        }
    }
}

