/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.parties.party;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import xaero.pac.client.parties.party.ClientParty;
import xaero.pac.client.parties.party.ClientPartyAllyInfo;
import xaero.pac.client.parties.party.ClientPartyAllyInfoStorage;
import xaero.pac.client.parties.party.ClientPartyMemberDynamicInfoSyncableStorage;
import xaero.pac.client.parties.party.IClientPartyStorage;
import xaero.pac.common.parties.party.IParty;

public class ClientPartyStorage
implements IClientPartyStorage<ClientPartyAllyInfo, ClientParty, ClientPartyMemberDynamicInfoSyncableStorage> {
    private String partyName;
    private boolean loading;
    private ClientParty party;
    private int loadingMemberCount;
    private int loadingInviteCount;
    private int loadingAllyCount;
    private int loadingMemberLimit;
    private int loadingInviteLimit;
    private int loadingAllyLimit;
    private final ClientPartyAllyInfoStorage allyInfoStorage;
    private final ClientPartyMemberDynamicInfoSyncableStorage partyMemberDynamicInfoSyncableStorage;

    private ClientPartyStorage(ClientPartyAllyInfoStorage allyInfoStorage, ClientPartyMemberDynamicInfoSyncableStorage partyMemberDynamicInfoSyncableStorage) {
        this.allyInfoStorage = allyInfoStorage;
        this.partyMemberDynamicInfoSyncableStorage = partyMemberDynamicInfoSyncableStorage;
    }

    @Override
    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    @Override
    public void setLoadingMemberCount(int loadingMemberCount) {
        this.loadingMemberCount = loadingMemberCount;
    }

    @Override
    public void setLoadingAllyCount(int loadingAllyCount) {
        this.loadingAllyCount = loadingAllyCount;
    }

    @Override
    public void setLoadingInviteCount(int loadingInviteCount) {
        this.loadingInviteCount = loadingInviteCount;
    }

    @Override
    public void setMemberLimit(int loadingMemberLimit) {
        this.loadingMemberLimit = loadingMemberLimit;
    }

    @Override
    public void setAllyLimit(int loadingAllyLimit) {
        this.loadingAllyLimit = loadingAllyLimit;
    }

    @Override
    public void setInviteLimit(int loadingInviteLimit) {
        this.loadingInviteLimit = loadingInviteLimit;
    }

    @Override
    public int getUIMemberCount() {
        if (this.loading || this.party == null) {
            return this.loadingMemberCount;
        }
        return this.party.getMemberCount();
    }

    @Override
    public int getUIAllyCount() {
        if (this.loading || this.party == null) {
            return this.loadingAllyCount;
        }
        return this.party.getAllyCount();
    }

    @Override
    public int getUIInviteCount() {
        if (this.loading || this.party == null) {
            return this.loadingInviteCount;
        }
        return this.party.getInviteCount();
    }

    @Override
    public int getMemberLimit() {
        return this.loadingMemberLimit;
    }

    @Override
    public int getAllyLimit() {
        return this.loadingAllyLimit;
    }

    @Override
    public int getInviteLimit() {
        return this.loadingInviteLimit;
    }

    @Override
    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public void setParty(ClientParty party) {
        this.party = party;
        if (party == null) {
            this.setPartyName(null);
            this.allyInfoStorage.clear();
            this.partyMemberDynamicInfoSyncableStorage.clear();
        }
    }

    @Override
    public void setPartyCast(IParty<?, ?, ?> party) {
        this.setParty((ClientParty)party);
    }

    @Override
    @Nullable
    public ClientParty getParty() {
        return this.party;
    }

    @Override
    public void setPartyName(String partyName) {
        this.partyName = partyName;
    }

    @Override
    @Nullable
    public String getPartyName() {
        if ((this.partyName == null || this.partyName.isEmpty()) && this.party != null) {
            return this.party.getDefaultName();
        }
        return this.partyName;
    }

    @Override
    @Nonnull
    public ClientPartyAllyInfoStorage getAllyInfoStorage() {
        return this.allyInfoStorage;
    }

    @Override
    @Nonnull
    public ClientPartyMemberDynamicInfoSyncableStorage getPartyMemberDynamicInfoSyncableStorage() {
        return this.partyMemberDynamicInfoSyncableStorage;
    }

    public void reset() {
        this.setParty((ClientParty)null);
    }

    public static final class Builder {
        private Builder() {
        }

        public ClientPartyStorage build() {
            return new ClientPartyStorage(ClientPartyAllyInfoStorage.Builder.begin().build(), ClientPartyMemberDynamicInfoSyncableStorage.Builder.begin().build());
        }

        public static Builder begin() {
            return new Builder();
        }
    }
}

