/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map;

import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CustomMapData {
    public Type<?> getType();

    default public boolean onItemUpdate(MapItemSavedData data, Entity entity) {
        return false;
    }

    @Nullable
    default public Component onItemTooltip(MapItemSavedData data, ItemStack stack) {
        return null;
    }

    public void save(CompoundTag var1);

    default public void saveToBuffer(FriendlyByteBuf buffer) {
        CompoundTag tag = new CompoundTag();
        this.save(tag);
        buffer.m_130079_(tag);
    }

    public record Type<T extends CustomMapData>(ResourceLocation id, Function<CompoundTag, T> factory) {
        @NotNull
        public CustomMapData createFromBuffer(FriendlyByteBuf buffer) {
            return (CustomMapData)this.factory.apply(buffer.m_130260_());
        }

        @Nullable
        public T get(MapItemSavedData mapData) {
            return (T)((ExpandedMapData)mapData).getCustomData().get(this.id);
        }

        public T getOrCreate(MapItemSavedData mapData, Supplier<T> constructor) {
            return (T)((ExpandedMapData)mapData).getCustomData().computeIfAbsent(this.id, r -> (CustomMapData)constructor.get());
        }
    }
}

