/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.integration;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.client.MapAtlasesClient;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;

public class MapAtlasCompat {
    public static boolean isAtlas(Item item) {
        return item instanceof MapAtlasItem;
    }

    @Nullable
    public static MapItemSavedData getSavedDataFromAtlas(ItemStack item, Level level, Player player) {
        try {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Map.Entry data = MapAtlasesAccessUtils.getActiveAtlasMapStateServer((Map)MapAtlasesAccessUtils.getAllMapInfoFromAtlas((Level)level, (ItemStack)item), (ServerPlayer)serverPlayer);
                if (data == null) {
                    return null;
                }
                return (MapItemSavedData)data.getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public static Integer getMapIdFromAtlas(ItemStack item, Level level, Object data) {
        try {
            Map mapInfo = MapAtlasesAccessUtils.getAllMapInfoFromAtlas((Level)level, (ItemStack)item);
            for (Map.Entry e : mapInfo.entrySet()) {
                if (e.getValue() != data) continue;
                return MapAtlasesAccessUtils.getMapIntFromString((String)((String)e.getKey()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void scaleDecoration(PoseStack poseStack) {
        float multiplier = MapAtlasesClient.getWorldMapZoomLevel();
        poseStack.m_85841_(multiplier, multiplier, 1.0f);
    }
}

