/*
 * Decompiled with CFR 0.152.
 */
package sc_libs.net.kyori.adventure.util;

import java.util.function.BooleanSupplier;
import sc_libs.org.jetbrains.annotations.NotNull;
import sc_libs.org.jetbrains.annotations.Nullable;

public enum TriState {
    NOT_SET,
    FALSE,
    TRUE;


    @Nullable
    public Boolean toBoolean() {
        switch (this) {
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public boolean toBooleanOrElse(boolean other) {
        switch (this) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
        }
        return other;
    }

    public boolean toBooleanOrElseGet(@NotNull BooleanSupplier supplier) {
        switch (this) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
        }
        return supplier.getAsBoolean();
    }

    @NotNull
    public static TriState byBoolean(boolean value) {
        return value ? TRUE : FALSE;
    }

    @NotNull
    public static TriState byBoolean(@Nullable Boolean value) {
        return value == null ? NOT_SET : TriState.byBoolean((boolean)value);
    }
}

