/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.mixin.features.ticking;

import com.llamalad7.mixinextras.injector.WrapWithCondition;
import me.wesley1808.servercore.common.config.tables.FeatureConfig;
import me.wesley1808.servercore.common.utils.ChunkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager {
    @Unique
    private boolean servercore$lobotomized = false;
    @Unique
    private int servercore$notLobotomizedCount = 0;

    private VillagerMixin(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
    }

    @WrapWithCondition(method={"customServerAiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/Brain;tick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)V")})
    private boolean servercore$shouldTickBrain(Brain<Villager> brain, ServerLevel level, LivingEntity livingEntity) {
        return FeatureConfig.LOBOTOMIZE_VILLAGERS.get() == false || !this.servercore$isLobotomized() || this.f_19797_ % FeatureConfig.LOBOTOMIZED_TICK_INTERVAL.get() == 0;
    }

    @Unique
    private boolean servercore$isLobotomized() {
        if (this.f_19797_ % (this.servercore$notLobotomizedCount > 3 ? 600 : 300) == 0) {
            boolean bl = this.servercore$lobotomized = this.m_20159_() || !this.servercore$canTravel(BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() + 0.0625), (double)this.m_20189_()));
            this.servercore$notLobotomizedCount = this.servercore$lobotomized ? 0 : ++this.servercore$notLobotomizedCount;
        }
        return this.servercore$lobotomized;
    }

    @Unique
    private boolean servercore$canTravel(BlockPos center) {
        ChunkAccess chunk = ChunkManager.getChunkNow((LevelReader)this.m_9236_(), center);
        if (chunk == null) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = center.m_122032_();
        boolean canJump = !this.servercore$hasCollisionAt(chunk, (BlockPos)mutable.m_122175_(Direction.UP, 2));
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!this.servercore$canTravelTo(mutable.m_122159_((Vec3i)center, direction), canJump)) continue;
            return true;
        }
        return false;
    }

    @Unique
    private boolean servercore$canTravelTo(BlockPos.MutableBlockPos mutable, boolean canJump) {
        ChunkAccess chunk = ChunkManager.getChunkNow((LevelReader)this.m_9236_(), (BlockPos)mutable);
        if (chunk == null) {
            return false;
        }
        Block bottom = chunk.m_8055_((BlockPos)mutable).m_60734_();
        if (bottom instanceof BedBlock) {
            return true;
        }
        if (this.servercore$hasCollisionAt(chunk, (BlockPos)mutable.m_122173_(Direction.UP))) {
            return false;
        }
        boolean isTallBlock = bottom instanceof FenceBlock || bottom instanceof FenceGateBlock || bottom instanceof WallBlock;
        return !bottom.f_60443_ || canJump && !isTallBlock && !this.servercore$hasCollisionAt(chunk, (BlockPos)mutable.m_122173_(Direction.UP));
    }

    @Unique
    private boolean servercore$hasCollisionAt(ChunkAccess chunk, BlockPos pos) {
        return chunk.m_8055_((BlockPos)pos).m_60734_().f_60443_;
    }
}

