/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.collections;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import me.wesley1808.servercore.common.utils.ChunkManager;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.level.chunk.LevelChunk;

public class CachedChunkList
extends ObjectArrayList<ServerChunkCache.ChunkAndHolder> {
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private boolean trim;
    private int tickCount = COUNTER.incrementAndGet();

    public CachedChunkList() {
        super(1024);
    }

    public void shouldTrim() {
        this.trim = true;
    }

    public void update(ChunkMap chunkMap) {
        if (this.tickCount++ % 20 == 0) {
            this.clear();
            for (ChunkHolder holder : chunkMap.f_140130_.values()) {
                LevelChunk chunk = ChunkManager.getChunkFromFuture(holder.m_140073_());
                if (chunk == null || !chunkMap.m_183879_(holder.m_140092_())) continue;
                this.add(new ServerChunkCache.ChunkAndHolder(chunk, holder));
            }
            if (this.trim) {
                this.trim(1024);
                this.trim = false;
            }
        }
    }
}

