/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.Index;
import com.mrh0.buildersaddition.blocks.VerticalRedstoneDiodeBlock;
import com.mrh0.buildersaddition.tileentity.VerticalComparatorTileEntity;
import com.mrh0.buildersaddition.util.Util;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.ticks.TickPriority;

public class VerticalComparatorBlock
extends VerticalRedstoneDiodeBlock
implements EntityBlock {
    public static final EnumProperty<ComparatorMode> MODE = BlockStateProperties.f_61393_;

    public VerticalComparatorBlock() {
        super("vertical_comparator", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50146_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)VERTICAL_FACING, (Comparable)Direction.UP)).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(MODE, (Comparable)ComparatorMode.COMPARE));
    }

    @Override
    protected int getDelay(BlockState state) {
        return 2;
    }

    @Override
    protected int getOutputSignal(BlockGetter worldIn, BlockPos pos, BlockState state) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        return tileentity instanceof VerticalComparatorTileEntity ? ((VerticalComparatorTileEntity)tileentity).getOutputSignal() : 0;
    }

    private int calculateOutputSignal(Level p_51904_, BlockPos p_51905_, BlockState p_51906_) {
        int i = this.getInputSignal(p_51904_, p_51905_, p_51906_);
        if (i == 0) {
            return 0;
        }
        int j = this.getAlternateSignal((LevelReader)p_51904_, p_51905_, p_51906_);
        if (j > i) {
            return 0;
        }
        return p_51906_.m_61143_(MODE) == ComparatorMode.SUBTRACT ? i - j : i;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = super.m_5573_(context);
        return (BlockState)blockstate.m_61124_(MODE, (Comparable)ComparatorMode.COMPARE);
    }

    @Override
    protected boolean shouldTurnOn(Level worldIn, BlockPos pos, BlockState state) {
        int i = this.getInputSignal(worldIn, pos, state);
        if (i == 0) {
            return false;
        }
        int j = this.getAlternateSignal((LevelReader)worldIn, pos, state);
        if (i > j) {
            return true;
        }
        return i == j && state.m_61143_(MODE) == ComparatorMode.COMPARE;
    }

    @Override
    public int getInputSignal(Level worldIn, BlockPos pos, BlockState state) {
        int i = super.getInputSignal(worldIn, pos, state);
        Direction direction = (Direction)state.m_61143_((Property)VERTICAL_FACING);
        BlockPos blockpos = pos.m_121945_(direction);
        BlockState blockstate = worldIn.m_8055_(blockpos);
        if (blockstate.m_60807_()) {
            i = blockstate.m_60674_(worldIn, blockpos);
        } else if (i < 15 && blockstate.m_60796_((BlockGetter)worldIn, blockpos)) {
            blockpos = blockpos.m_121945_(direction);
            blockstate = worldIn.m_8055_(blockpos);
            ItemFrame itemframeentity = this.getItemFrame(worldIn, direction, blockpos);
            int j = Math.max(itemframeentity == null ? Integer.MIN_VALUE : itemframeentity.m_31824_(), blockstate.m_60807_() ? blockstate.m_60674_(worldIn, blockpos) : Integer.MIN_VALUE);
            if (j != Integer.MIN_VALUE) {
                i = j;
            }
        }
        return i;
    }

    @Nullable
    private ItemFrame getItemFrame(Level worldIn, Direction facing, BlockPos pos) {
        List list = worldIn.m_6443_(ItemFrame.class, new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1)), itemFrame -> itemFrame != null);
        return list.size() == 1 ? (ItemFrame)list.get(0) : null;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.m_150110_().f_35938_) {
            return InteractionResult.PASS;
        }
        float f = (state = (BlockState)state.m_61122_(MODE)).m_61143_(MODE) == ComparatorMode.SUBTRACT ? 0.55f : 0.5f;
        world.m_5594_(player, pos, SoundEvents.f_11762_, SoundSource.BLOCKS, 0.3f, f);
        world.m_7731_(pos, state, 2);
        this.refreshOutputState(world, pos, state);
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    @Override
    public void checkTickOnNeighbor(Level p_51900_, BlockPos p_51901_, BlockState p_51902_) {
        if (!p_51900_.m_183326_().m_183588_(p_51901_, (Object)this)) {
            int j;
            int i = this.calculateOutputSignal(p_51900_, p_51901_, p_51902_);
            BlockEntity blockentity = p_51900_.m_7702_(p_51901_);
            int n = j = blockentity instanceof VerticalComparatorTileEntity ? ((VerticalComparatorTileEntity)blockentity).getOutputSignal() : 0;
            if (i != j || ((Boolean)p_51902_.m_61143_((Property)POWERED)).booleanValue() != this.shouldTurnOn(p_51900_, p_51901_, p_51902_)) {
                TickPriority tickpriority = this.shouldPrioritize((BlockGetter)p_51900_, p_51901_, p_51902_) ? TickPriority.HIGH : TickPriority.NORMAL;
                p_51900_.m_186464_(p_51901_, (Block)this, 2, tickpriority);
            }
        }
    }

    public void refreshOutputState(Level world, BlockPos pos, BlockState state) {
        int i = this.calculateOutputSignal(world, pos, state);
        BlockEntity blockentity = world.m_7702_(pos);
        int j = 0;
        if (blockentity instanceof VerticalComparatorTileEntity) {
            VerticalComparatorTileEntity comparatorblockentity = (VerticalComparatorTileEntity)blockentity;
            j = comparatorblockentity.getOutputSignal();
            comparatorblockentity.setOutputSignal(i);
        }
        if (j != i || state.m_61143_(MODE) == ComparatorMode.COMPARE) {
            boolean flag1 = this.shouldTurnOn(world, pos, state);
            boolean flag = (Boolean)state.m_61143_((Property)POWERED);
            if (flag && !flag1) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
            } else if (!flag && flag1) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
            }
            this.updateNeighborsInFront(world, pos, state);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)Items.f_42351_);
    }

    @Override
    public void tick(BlockState p_51869_, ServerLevel p_51870_, BlockPos p_51871_, Random p_51872_) {
        this.refreshOutputState((Level)p_51870_, p_51871_, p_51869_);
    }

    public boolean m_8133_(BlockState p_51874_, Level p_51875_, BlockPos p_51876_, int p_51877_, int p_51878_) {
        super.m_8133_(p_51874_, p_51875_, p_51876_, p_51877_, p_51878_);
        BlockEntity blockentity = p_51875_.m_7702_(p_51876_);
        return blockentity != null && blockentity.m_7531_(p_51877_, p_51878_);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new VerticalComparatorTileEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HORIZONTAL_FACING, VERTICAL_FACING, MODE, POWERED});
    }

    public boolean getWeakChanges(BlockState state, LevelReader world, BlockPos pos) {
        return state.m_60713_(Blocks.f_50328_) || state.m_60713_((Block)Index.VERTICAL_COMPARATOR.get());
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        if (pos.m_123342_() == neighbor.m_123342_() && world instanceof Level && !((Level)world).m_5776_()) {
            state.m_60690_((Level)world, pos, world.m_8055_(neighbor).m_60734_(), neighbor, false);
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return !world.m_5776_() ? Util.createTickerHelper(type, (BlockEntityType)Index.VERTICAL_COMPARATOR_TILE_ENTITY_TYPE.get(), VerticalComparatorTileEntity::tick) : null;
    }
}

