/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseBlock;
import com.mrh0.buildersaddition.tileentity.CupboardTileEntity;
import com.mrh0.buildersaddition.util.IComparetorOverride;
import com.mrh0.buildersaddition.util.Util;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Cupboard
extends BaseBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty MIRROR = BooleanProperty.m_61465_((String)"mirror");
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static VoxelShape SHAPE_NORTH_LOWER = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)32.0, (double)16.0);
    private static VoxelShape SHAPE_EAST_LOWER = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)32.0, (double)16.0);
    private static VoxelShape SHAPE_SOUTH_LOWER = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)15.0);
    private static VoxelShape SHAPE_WEST_LOWER = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    private static VoxelShape SHAPE_NORTH_UPPER = Block.m_49796_((double)0.0, (double)-16.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
    private static VoxelShape SHAPE_EAST_UPPER = Block.m_49796_((double)0.0, (double)-16.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    private static VoxelShape SHAPE_SOUTH_UPPER = Block.m_49796_((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0);
    private static VoxelShape SHAPE_WEST_UPPER = Block.m_49796_((double)1.0, (double)-16.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public Cupboard(String name, Block source) {
        super("cupboard_" + name, BlockBehaviour.Properties.m_60926_((BlockBehaviour)source));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public PushReaction getPistonPushReaction(BlockState p_60584_) {
        return PushReaction.BLOCK;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        if (blockpos.m_123342_() < 255 && context.m_43725_().m_8055_(blockpos.m_7494_()).m_60629_(context)) {
            return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)MIRROR, (Comparable)Boolean.valueOf(context.m_7078_()))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity end, ItemStack stack) {
        world.m_7731_(pos.m_7494_(), (BlockState)((BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(pos.m_7494_()).m_76152_() == Fluids.f_76193_)), 3);
    }

    public boolean isValidPosition(BlockState state, BlockGetter worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = worldIn.m_8055_(blockpos);
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? true : blockstate.m_60713_((Block)this);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, HALF, MIRROR});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.m_7361_(world, pos, state, fluidStateIn);
    }

    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluidIn) {
        return super.m_6044_(world, pos, state, fluidIn);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        switch (type) {
            case LAND: {
                return false;
            }
            case WATER: {
                return world.m_6425_(pos).m_205070_(FluidTags.f_13131_);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    private VoxelShape getShapeForDirection(Direction d, boolean b) {
        switch (d) {
            case NORTH: {
                return b ? SHAPE_NORTH_UPPER : SHAPE_NORTH_LOWER;
            }
            case SOUTH: {
                return b ? SHAPE_SOUTH_UPPER : SHAPE_SOUTH_LOWER;
            }
            case EAST: {
                return b ? SHAPE_EAST_UPPER : SHAPE_EAST_LOWER;
            }
            case WEST: {
                return b ? SHAPE_WEST_UPPER : SHAPE_WEST_LOWER;
            }
        }
        return SHAPE_NORTH_LOWER;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getShapeForDirection((Direction)state.m_61143_((Property)FACING), state.m_61143_(HALF) == DoubleBlockHalf.UPPER);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            if (!Util.accessCheck(world, pos, (Direction)state.m_61143_((Property)FACING)) || !Util.accessCheck(world, pos.m_7494_(), (Direction)state.m_61143_((Property)FACING))) {
                return InteractionResult.CONSUME;
            }
            BlockEntity tileentity = world.m_7702_(pos);
            if (tileentity instanceof CupboardTileEntity) {
                player.m_5893_((MenuProvider)((CupboardTileEntity)tileentity));
                PiglinAi.m_34873_((Player)player, (boolean)true);
            }
        } else {
            if (!Util.accessCheck(world, pos, (Direction)state.m_61143_((Property)FACING)) || !Util.accessCheck(world, pos.m_7495_(), (Direction)state.m_61143_((Property)FACING))) {
                return InteractionResult.CONSUME;
            }
            BlockEntity tileentity = world.m_7702_(pos.m_7495_());
            if (tileentity instanceof CupboardTileEntity) {
                player.m_5893_((MenuProvider)((CupboardTileEntity)tileentity));
                PiglinAi.m_34873_((Player)player, (boolean)true);
            }
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            CupboardTileEntity tileentity = this.getTE(state, world, pos);
            if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                BlockState upper = world.m_8055_(pos.m_7494_());
                if (upper.m_60734_() == this) {
                    world.m_7731_(pos.m_7494_(), this.m_5888_(upper).m_76152_() == Fluids.f_76193_ ? this.m_5888_(upper).m_76188_() : Blocks.f_50016_.m_49966_(), 35);
                }
                if (tileentity != null) {
                    Containers.m_19002_((Level)world, (BlockPos)pos, (Container)tileentity);
                    world.m_46717_(pos, (Block)this);
                    world.m_46717_(pos.m_7494_(), (Block)this);
                }
            } else {
                BlockState lower = world.m_8055_(pos.m_7495_());
                if (lower.m_60734_() == this) {
                    world.m_7731_(pos.m_7495_(), this.m_5888_(lower).m_76152_() == Fluids.f_76193_ ? this.m_5888_(lower).m_76188_() : Blocks.f_50016_.m_49966_(), 35);
                }
                if (tileentity != null) {
                    Containers.m_19002_((Level)world, (BlockPos)pos.m_7495_(), (Container)tileentity);
                    world.m_46717_(pos, (Block)this);
                    world.m_46717_(pos.m_7495_(), (Block)this);
                }
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    private CupboardTileEntity getTE(BlockState state, Level world, BlockPos pos) {
        BlockEntity tileentity = state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? world.m_7702_(pos) : world.m_7702_(pos.m_7495_());
        if (tileentity != null && tileentity instanceof CupboardTileEntity) {
            return (CupboardTileEntity)tileentity;
        }
        return null;
    }

    public RenderShape m_7514_(BlockState p_60550_) {
        return RenderShape.MODEL;
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int id, int param) {
        super.m_8133_(state, world, pos, id, param);
        BlockEntity tileentity = world.m_7702_(pos);
        return tileentity == null ? false : tileentity.m_7531_(id, param);
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return IComparetorOverride.getComparetorOverride(world, pos);
        }
        return IComparetorOverride.getComparetorOverride(world, pos.m_7495_());
    }

    public boolean m_7278_(BlockState p_60457_) {
        return true;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CupboardTileEntity(pos, state);
    }
}

