/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseDerivativeBlock;
import com.mrh0.buildersaddition.tileentity.BookshelfTileEntity;
import com.mrh0.buildersaddition.util.IComparetorOverride;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class Bookshelf
extends BaseDerivativeBlock
implements EntityBlock {
    public static final BooleanProperty BOOK0 = BooleanProperty.m_61465_((String)"book0");
    public static final BooleanProperty BOOK1 = BooleanProperty.m_61465_((String)"book1");
    public static final BooleanProperty BOOK2 = BooleanProperty.m_61465_((String)"book2");
    public static final BooleanProperty BOOK3 = BooleanProperty.m_61465_((String)"book3");
    public static final BooleanProperty BOOK4 = BooleanProperty.m_61465_((String)"book4");
    public static final BooleanProperty BOOK5 = BooleanProperty.m_61465_((String)"book5");
    public static final BooleanProperty BOOK6 = BooleanProperty.m_61465_((String)"book6");
    public static final BooleanProperty BOOK7 = BooleanProperty.m_61465_((String)"book7");
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public Bookshelf(String name) {
        super("bookshelf_" + name, Blocks.f_50705_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)BOOK0, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOOK1, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOOK2, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOOK3, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOOK4, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOOK5, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOOK6, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOOK7, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, BOOK0, BOOK1, BOOK2, BOOK3, BOOK4, BOOK5, BOOK6, BOOK7});
    }

    public BlockState m_5573_(BlockPlaceContext c) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)c.m_8125_().m_122424_());
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BookshelfTileEntity(pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return NORTH_SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_5833_()) {
            return InteractionResult.PASS;
        }
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BookshelfTileEntity mte = (BookshelfTileEntity)world.m_7702_(pos);
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)mte, extraData -> extraData.m_130064_(pos));
        return InteractionResult.CONSUME;
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader world, BlockPos pos) {
        return Math.min((float)this.getBookSum(state, world, pos) / 3.0f, 6.0f);
    }

    public static BlockState getState(BlockState state, boolean b1, boolean b2, boolean b3, boolean b4, boolean b5, boolean b6, boolean b7, boolean b8) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)BOOK0, (Comparable)Boolean.valueOf(b1))).m_61124_((Property)BOOK1, (Comparable)Boolean.valueOf(b2))).m_61124_((Property)BOOK2, (Comparable)Boolean.valueOf(b3))).m_61124_((Property)BOOK3, (Comparable)Boolean.valueOf(b4))).m_61124_((Property)BOOK4, (Comparable)Boolean.valueOf(b5))).m_61124_((Property)BOOK5, (Comparable)Boolean.valueOf(b6))).m_61124_((Property)BOOK6, (Comparable)Boolean.valueOf(b7))).m_61124_((Property)BOOK7, (Comparable)Boolean.valueOf(b8));
    }

    public int getBookSum(BlockState state, LevelReader world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te != null && te instanceof BookshelfTileEntity) {
            BookshelfTileEntity bte = (BookshelfTileEntity)te;
            int sum = 0;
            for (int i = 0; i < bte.handler.getSlots(); ++i) {
                if (bte.handler.getStackInSlot(i).m_41613_() <= 0) continue;
                ++sum;
            }
            return sum;
        }
        return 0;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileentity;
        if (!state.m_60713_(newState.m_60734_()) && (tileentity = world.m_7702_(pos)) instanceof Container) {
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((Container)tileentity));
            world.m_46672_(pos, (Block)this);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public int m_6782_(BlockState sate, Level world, BlockPos pos) {
        return IComparetorOverride.getComparetorOverride(world, pos);
    }

    public boolean m_7278_(BlockState p_60457_) {
        return true;
    }
}

