/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.Alignment;
import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.Parsers;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.util.records.SizeI;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ButtonImage
extends Button {
    private static final int DEFAULT_BUTTON_SIZE = 20;
    protected ResourceLocation image;
    protected ResourceLocation imageHighlight;
    protected ResourceLocation imageDisabled;
    protected int imageOffsetX = 0;
    protected int imageOffsetY = 0;
    protected int imageWidth = 0;
    protected int imageHeight = 0;
    protected int imageMapWidth = 0;
    protected int imageMapHeight = 0;
    protected int highlightOffsetX = 0;
    protected int highlightOffsetY = 0;
    protected int highlightWidth = 0;
    protected int highlightHeight = 0;
    protected int highlightMapWidth = 0;
    protected int highlightMapHeight = 0;
    protected int disabledOffsetX = 0;
    protected int disabledOffsetY = 0;
    protected int disabledWidth = 0;
    protected int disabledHeight = 0;
    protected int disabledMapWidth = 0;
    protected int disabledMapHeight = 0;

    public ButtonImage() {
        super(Alignment.MIDDLE, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, false, false);
        this.width = 20;
        this.height = 20;
        this.recalcTextRendering();
    }

    public ButtonImage(PaneParams params) {
        super(params, Alignment.MIDDLE, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, false, false);
        this.loadImageInfo(params);
        this.loadHighlightInfo(params);
        this.loadDisabledInfo(params);
        this.loadTextInfo(params);
    }

    private void loadImageInfo(PaneParams params) {
        this.image = params.getResource("source", this::loadImageDimensions);
        params.applyShorthand("imageoffset", Parsers.INT, 2, a -> {
            this.imageOffsetX = (Integer)a.get(0);
            this.imageOffsetY = (Integer)a.get(1);
        });
        params.applyShorthand("imagesize", Parsers.INT, 2, a -> {
            this.imageWidth = (Integer)a.get(0);
            this.imageHeight = (Integer)a.get(1);
        });
    }

    private void loadHighlightInfo(PaneParams params) {
        this.imageHighlight = params.getResource("highlight", this::loadImageHighlightDimensions);
        params.applyShorthand("highlightoffset", Parsers.INT, 2, a -> {
            this.highlightOffsetX = (Integer)a.get(0);
            this.highlightOffsetY = (Integer)a.get(1);
        });
        params.applyShorthand("highlightsize", Parsers.INT, 2, a -> {
            this.highlightWidth = (Integer)a.get(0);
            this.highlightHeight = (Integer)a.get(1);
        });
    }

    private void loadDisabledInfo(PaneParams params) {
        this.imageDisabled = params.getResource("disabled", this::loadImageDisabledDimensions);
        params.applyShorthand("disabledoffset", Parsers.INT, 2, a -> {
            this.disabledOffsetX = (Integer)a.get(0);
            this.disabledOffsetY = (Integer)a.get(1);
        });
        params.applyShorthand("disabledsize", Parsers.INT, 2, a -> {
            this.disabledWidth = (Integer)a.get(0);
            this.disabledHeight = (Integer)a.get(1);
        });
    }

    private void loadTextInfo(PaneParams params) {
        this.textColor = params.getColor("textcolor", this.textColor);
        this.textHoverColor = params.getColor("texthovercolor", this.textColor);
        this.textDisabledColor = params.getColor("textdisabledcolor", this.textColor);
        params.applyShorthand("textoffset", Parsers.INT, 2, a -> {
            this.textOffsetX = (Integer)a.get(0);
            this.textOffsetY = (Integer)a.get(1);
        });
        params.applyShorthand("textbox", Parsers.INT, 2, a -> {
            this.textWidth = (Integer)a.get(0);
            this.textHeight = (Integer)a.get(1);
        });
        this.recalcTextRendering();
    }

    private void loadImageDimensions(ResourceLocation rl) {
        SizeI dimensions = Image.getImageDimensions(rl);
        this.imageMapWidth = dimensions.width();
        this.imageMapHeight = dimensions.height();
    }

    private void loadImageHighlightDimensions(ResourceLocation rl) {
        SizeI dimensions = Image.getImageDimensions(rl);
        this.highlightMapWidth = dimensions.width();
        this.highlightMapHeight = dimensions.height();
    }

    private void loadImageDisabledDimensions(ResourceLocation rl) {
        SizeI dimensions = Image.getImageDimensions(rl);
        this.disabledMapWidth = dimensions.width();
        this.disabledMapHeight = dimensions.height();
    }

    public void setImage(ResourceLocation loc, int offsetX, int offsetY, int w, int h) {
        if (!Objects.equals(loc, this.image)) {
            this.loadImageDimensions(loc);
        }
        this.image = loc;
        this.imageOffsetX = offsetX;
        this.imageOffsetY = offsetY;
        this.imageHeight = w;
        this.imageWidth = h;
    }

    public void setImage(ResourceLocation loc, boolean keepUv) {
        if (!Objects.equals(loc, this.image)) {
            this.loadImageDimensions(loc);
        }
        this.image = loc;
        if (!keepUv) {
            this.imageOffsetX = 0;
            this.imageOffsetY = 0;
            this.imageHeight = 0;
            this.imageWidth = 0;
        }
    }

    public void setImageHighlight(ResourceLocation loc, int offsetX, int offsetY, int w, int h) {
        if (!Objects.equals(loc, this.imageHighlight)) {
            this.loadImageHighlightDimensions(loc);
        }
        this.imageHighlight = loc;
        this.highlightOffsetX = offsetX;
        this.highlightOffsetY = offsetY;
        this.highlightHeight = w;
        this.highlightWidth = h;
    }

    public void setImageHighlight(ResourceLocation loc, boolean keepUv) {
        if (!Objects.equals(loc, this.imageHighlight)) {
            this.loadImageHighlightDimensions(loc);
        }
        this.imageHighlight = loc;
        if (!keepUv) {
            this.highlightOffsetX = 0;
            this.highlightOffsetY = 0;
            this.highlightHeight = 0;
            this.highlightWidth = 0;
        }
    }

    public void setImageDisabled(ResourceLocation loc, boolean keepUv) {
        if (!Objects.equals(loc, this.imageDisabled)) {
            this.loadImageDisabledDimensions(loc);
        }
        this.imageDisabled = loc;
        if (!keepUv) {
            this.disabledOffsetX = 0;
            this.disabledOffsetY = 0;
            this.disabledHeight = 0;
            this.disabledWidth = 0;
        }
    }

    public void setImageDisabled(ResourceLocation loc, int offsetX, int offsetY, int w, int h) {
        if (!Objects.equals(loc, this.imageDisabled)) {
            this.loadImageDisabledDimensions(loc);
        }
        this.imageDisabled = loc;
        this.disabledOffsetX = offsetX;
        this.disabledOffsetY = offsetY;
        this.disabledHeight = w;
        this.disabledWidth = h;
    }

    @Override
    public void drawSelf(BOGuiGraphics target, double mx, double my) {
        PoseStack ms = target.m_280168_();
        Objects.requireNonNull(this.image, () -> this.id + " | " + this.window.getXmlResourceLocation());
        ResourceLocation bind = this.image;
        int u = this.imageOffsetX;
        int v = this.imageOffsetY;
        int w = this.imageWidth == 0 ? this.imageMapWidth : this.imageWidth;
        int h = this.imageHeight == 0 ? this.imageMapHeight : this.imageHeight;
        int mapWidth = this.imageMapWidth;
        int mapHeight = this.imageMapHeight;
        if (!this.enabled) {
            if (this.imageDisabled != null) {
                bind = this.imageDisabled;
                u = this.disabledOffsetX;
                v = this.disabledOffsetY;
                w = this.disabledWidth == 0 ? this.disabledMapWidth : this.disabledWidth;
                h = this.disabledHeight == 0 ? this.disabledMapHeight : this.disabledHeight;
                mapWidth = this.disabledMapWidth;
                mapHeight = this.disabledMapHeight;
            }
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        } else if (this.wasCursorInPane) {
            if (this.imageHighlight != null) {
                bind = this.imageHighlight;
                u = this.highlightOffsetX;
                v = this.highlightOffsetY;
                w = this.highlightWidth == 0 ? this.highlightMapWidth : this.highlightWidth;
                h = this.highlightHeight == 0 ? this.highlightMapHeight : this.highlightHeight;
                mapWidth = this.highlightMapWidth;
                mapHeight = this.highlightMapHeight;
            }
            RenderSystem.setShaderColor((float)1.1f, (float)1.1f, (float)1.1f, (float)1.0f);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        ButtonImage.blit(ms, bind, this.x, this.y, this.width, this.height, u, v, w, h, mapWidth, mapHeight);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.drawSelf(target, mx, my);
    }

    @Override
    public void setSize(int w, int h) {
        int newTextWidth = (int)((double)(this.textWidth * w) / (double)this.width);
        int newTextHeight = (int)((double)(this.textHeight * h) / (double)this.height);
        super.setSize(w, h);
        this.textWidth = newTextWidth;
        this.textHeight = newTextHeight;
        this.recalcTextRendering();
    }

    public void setTextOffset(int textOffsetX, int textOffsetY) {
        this.textOffsetX = Mth.m_14045_((int)textOffsetX, (int)0, (int)this.width);
        this.textOffsetY = Mth.m_14045_((int)textOffsetY, (int)0, (int)this.height);
    }

    public void setTextRenderBox(int textWidth, int textHeight) {
        this.textWidth = Mth.m_14045_((int)textWidth, (int)0, (int)(this.width - this.textOffsetX));
        this.textHeight = Mth.m_14045_((int)textHeight, (int)0, (int)(this.height - this.textOffsetY));
        this.recalcTextRendering();
    }
}

