/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.Alignment;
import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.util.SpacerTextComponent;
import com.ldtteam.blockui.util.ToggleableTextComponent;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.client.ForgeRenderTypes;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public abstract class AbstractTextElement
extends Pane {
    private static final int FILTERING_ROUNDING = 50;
    private static final float FILTERING_THRESHOLD = 0.02f;
    public static final double DEFAULT_TEXT_SCALE = 1.0;
    public static final Alignment DEFAULT_TEXT_ALIGNMENT = Alignment.MIDDLE_LEFT;
    public static final int DEFAULT_TEXT_COLOR = 0xFFFFFF;
    public static final boolean DEFAULT_TEXT_SHADOW = false;
    public static final boolean DEFAULT_TEXT_WRAP = false;
    public static final int DEFAULT_TEXT_LINESPACE = 0;
    public static final int SIZE_FOR_UNLIMITED_ELEMENTS = 1000000;
    protected double textScale = 1.0;
    protected Alignment textAlignment = DEFAULT_TEXT_ALIGNMENT;
    protected int textColor = 0xFFFFFF;
    protected int textHoverColor = 0xFFFFFF;
    protected int textDisabledColor = 0xFFFFFF;
    protected boolean textShadow = false;
    protected boolean textWrap = false;
    protected int textLinespace = 0;
    protected List<MutableComponent> text;
    protected List<FormattedCharSequence> preparedText;
    protected int renderedTextWidth;
    protected int renderedTextHeight;
    protected int textOffsetX = 0;
    protected int textOffsetY = 0;
    protected int textWidth = this.width;
    protected int textHeight = this.height;

    public AbstractTextElement() {
        this(DEFAULT_TEXT_ALIGNMENT, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, false, false);
    }

    public AbstractTextElement(Alignment defaultTextAlignment, int defaultTextColor, int defaultTextHoverColor, int defaultTextDisabledColor, boolean defaultTextShadow, boolean defaultTextWrap) {
        this.textAlignment = defaultTextAlignment;
        this.textColor = defaultTextColor;
        this.textHoverColor = defaultTextHoverColor;
        this.textDisabledColor = defaultTextDisabledColor;
        this.textShadow = defaultTextShadow;
        this.textWrap = defaultTextWrap;
    }

    public AbstractTextElement(PaneParams params) {
        this(params, DEFAULT_TEXT_ALIGNMENT, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, false, false);
    }

    public AbstractTextElement(PaneParams params, Alignment defaultTextAlignment, int defaultTextColor, int defaultTextHoverColor, int defaultTextDisabledColor, boolean defaultTextShadow, boolean defaultTextWrap) {
        super(params);
        this.textAlignment = params.getEnum("textalign", Alignment.class, defaultTextAlignment);
        if (params.hasAttribute("color")) {
            this.setColors(params.getColor("color", defaultTextColor));
        } else {
            this.textColor = params.getColor("textcolor", defaultTextColor);
            this.textHoverColor = params.getColor("texthovercolor", defaultTextHoverColor);
            this.textDisabledColor = params.getColor("textdisabledcolor", defaultTextDisabledColor);
        }
        this.textShadow = params.getBoolean("shadow", defaultTextShadow);
        this.textWrap = params.getBoolean("wrap", defaultTextWrap);
        this.textScale = params.getDouble("textscale", this.textScale);
        this.textLinespace = params.getInteger("linespace", this.textLinespace);
        this.text = params.getMultilineText(params.hasAnyAttribute("label", "text"));
    }

    protected void recalcTextRendering() {
        if (this.textScale <= 0.0 || this.textWidth < 1 || this.textHeight < 1 || this.isTextEmpty()) {
            this.preparedText = Collections.emptyList();
            return;
        }
        int maxWidth = (int)((double)this.textWidth / this.textScale) - (this.textShadow ? 1 : 0);
        this.preparedText = this.text.stream().flatMap(textBlock -> {
            ComponentContents patt6501$temp = textBlock.m_214077_();
            if (patt6501$temp instanceof SpacerTextComponent) {
                SpacerTextComponent spacer = (SpacerTextComponent)patt6501$temp;
                return Stream.of(spacer.getVisualOrderText());
            }
            ComponentContents patt6682$temp = textBlock.m_214077_();
            if (patt6682$temp instanceof ToggleableTextComponent) {
                ToggleableTextComponent toggleable = (ToggleableTextComponent)patt6682$temp;
                return this.mc.f_91062_.m_92923_((FormattedText)toggleable.data(), maxWidth).stream().map(formatted -> new ToggleableTextComponent.FormattedToggleableCharSequence(toggleable.condition(), (FormattedCharSequence)formatted));
            }
            if (textBlock.m_214077_() == ComponentContents.f_237124_ && textBlock.m_7360_().isEmpty()) {
                return Stream.of(textBlock.m_7532_());
            }
            return this.mc.f_91062_.m_92923_((FormattedText)textBlock, maxWidth).stream();
        }).collect(Collectors.toList());
    }

    public void recalcPreparedTextBox() {
        if (this.textWrap) {
            int maxHeight = (int)((double)this.textHeight / this.textScale) + 1;
            Objects.requireNonNull(this.mc.f_91062_);
            int lineHeight = 9 + this.textLinespace;
            this.preparedText = this.preparedText.subList(0, Math.min(this.preparedText.size(), maxHeight / lineHeight));
            int heightSum = 0;
            int widthMax = 0;
            for (FormattedCharSequence textBlock : this.preparedText) {
                if (textBlock instanceof SpacerTextComponent.FormattedSpacerComponent) {
                    SpacerTextComponent.FormattedSpacerComponent spacer = (SpacerTextComponent.FormattedSpacerComponent)textBlock;
                    heightSum += spacer.pixelHeight() + this.textLinespace;
                    continue;
                }
                if (textBlock instanceof ToggleableTextComponent.FormattedToggleableCharSequence) {
                    ToggleableTextComponent.FormattedToggleableCharSequence toggleable = (ToggleableTextComponent.FormattedToggleableCharSequence)textBlock;
                    if (!toggleable.condition().getAsBoolean()) continue;
                    heightSum += lineHeight;
                    widthMax = Math.max(widthMax, this.mc.f_91062_.m_92724_(toggleable.data()));
                    continue;
                }
                heightSum += lineHeight;
                widthMax = Math.max(widthMax, this.mc.f_91062_.m_92724_(textBlock));
            }
            this.renderedTextWidth = (int)((double)widthMax * this.textScale);
            this.renderedTextHeight = (int)((double)(Math.min(heightSum, maxHeight) - 1 - this.textLinespace) * this.textScale);
        } else {
            this.preparedText = this.preparedText.subList(0, 1);
            this.renderedTextWidth = (int)((double)this.mc.f_91062_.m_92724_(this.preparedText.get(0)) * this.textScale);
            Objects.requireNonNull(this.mc.f_91062_);
            this.renderedTextHeight = (int)((double)(9 - 1) * this.textScale);
        }
    }

    protected int getTextRenderingColor(double mx, double my) {
        return this.enabled ? (this.isPointInPane(mx, my) ? this.textHoverColor : this.textColor) : this.textDisabledColor;
    }

    @Override
    public void drawSelf(BOGuiGraphics ms, double mx, double my) {
        if (!this.preparedText.isEmpty()) {
            this.recalcPreparedTextBox();
            this.innerDrawSelf(ms, mx, my);
        }
    }

    protected void innerDrawSelf(BOGuiGraphics target, double mx, double my) {
        PoseStack ms = target.m_280168_();
        int color = this.enabled ? (this.wasCursorInPane ? this.textHoverColor : this.textColor) : this.textDisabledColor;
        int offsetX = this.textOffsetX;
        int offsetY = this.textOffsetY;
        if (this.textAlignment.isRightAligned()) {
            offsetX += this.textWidth - this.renderedTextWidth;
        } else if (this.textAlignment.isHorizontalCentered()) {
            offsetX += (this.textWidth - this.renderedTextWidth) / 2;
        }
        if (this.textAlignment.isBottomAligned()) {
            offsetY += this.textHeight - this.renderedTextHeight;
        } else if (this.textAlignment.isVerticalCentered()) {
            offsetY += (this.textHeight - this.renderedTextHeight) / 2;
        }
        ms.m_85836_();
        ms.m_85837_((double)(this.x + offsetX), (double)(this.y + offsetY), 0.0);
        Matrix4f matrix4f = ms.m_85850_().m_252922_();
        Vector4f temp = new Vector4f(1.0f, 1.0f, 0.0f, 0.0f);
        matrix4f.transform(temp);
        float oldScaleX = temp.x();
        float oldScaleY = temp.y();
        float newScaleX = (float)Math.round((double)oldScaleX * this.textScale * 50.0) / 50.0f;
        float newScaleY = (float)Math.round((double)oldScaleY * this.textScale * 50.0) / 50.0f;
        if (Math.abs((float)Math.round(newScaleX) - newScaleX) > 0.02f || Math.abs((float)Math.round(newScaleY) - newScaleY) > 0.02f) {
            ForgeRenderTypes.enableTextTextureLinearFiltering = true;
            ms.m_85841_((float)this.textScale, (float)this.textScale, 1.0f);
        } else {
            ms.m_85841_(newScaleX / oldScaleX, newScaleY / oldScaleY, 1.0f);
        }
        MultiBufferSource.BufferSource drawBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        int lineShift = 0;
        for (FormattedCharSequence row : this.preparedText) {
            if (row == FormattedCharSequence.f_13691_) {
                Objects.requireNonNull(this.mc.f_91062_);
                lineShift += 9 + this.textLinespace;
                continue;
            }
            if (row instanceof ToggleableTextComponent.FormattedToggleableCharSequence) {
                ToggleableTextComponent.FormattedToggleableCharSequence toggleable = (ToggleableTextComponent.FormattedToggleableCharSequence)row;
                if (!toggleable.condition().getAsBoolean()) continue;
                row = toggleable.data();
            } else if (row instanceof SpacerTextComponent.FormattedSpacerComponent) {
                SpacerTextComponent.FormattedSpacerComponent spacer = (SpacerTextComponent.FormattedSpacerComponent)row;
                lineShift += spacer.pixelHeight() + this.textLinespace;
                continue;
            }
            int xOffset = this.textAlignment.isRightAligned() ? (int)(((double)this.renderedTextWidth - (double)this.mc.f_91062_.m_92724_(row) * this.textScale) / this.textScale) : (this.textAlignment.isHorizontalCentered() ? (int)(((double)this.renderedTextWidth - (double)this.mc.f_91062_.m_92724_(row) * this.textScale) / 2.0 / this.textScale) : 0);
            this.mc.f_91062_.m_272191_(row, (float)xOffset, (float)lineShift, color, this.textShadow, matrix4f, (MultiBufferSource)drawBuffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            Objects.requireNonNull(this.mc.f_91062_);
            lineShift += 9 + this.textLinespace;
        }
        drawBuffer.m_109911_();
        ForgeRenderTypes.enableTextTextureLinearFiltering = false;
        RenderSystem.disableBlend();
        ms.m_85849_();
    }

    public Alignment getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(Alignment textAlignment) {
        this.textAlignment = textAlignment;
    }

    public double getTextScale() {
        return this.textScale;
    }

    public void setTextScale(double textScale) {
        this.textScale = textScale;
        this.recalcTextRendering();
    }

    public void setColors(int color) {
        this.setColors(color, color, color);
    }

    public void setColors(int textColor, int textDisabledColor, int textHoverColor) {
        this.textColor = textColor;
        this.textDisabledColor = textDisabledColor;
        this.textHoverColor = textHoverColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public int getTextHoverColor() {
        return this.textHoverColor;
    }

    public void setTextHoverColor(int textHoverColor) {
        this.textHoverColor = textHoverColor;
    }

    public int getTextDisabledColor() {
        return this.textDisabledColor;
    }

    public void setTextDisabledColor(int textDisabledColor) {
        this.textDisabledColor = textDisabledColor;
    }

    public int getTextLinespace() {
        return this.textLinespace;
    }

    public void setTextLinespace(int textLinespace) {
        this.textLinespace = textLinespace;
    }

    public boolean isTextShadow() {
        return this.textShadow;
    }

    public void setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
    }

    public boolean isTextWrap() {
        return this.textWrap;
    }

    public void setTextWrap(boolean textWrap) {
        this.textWrap = textWrap;
        this.recalcTextRendering();
    }

    @Nullable
    public List<MutableComponent> getTextAsList() {
        return this.text;
    }

    @Nullable
    public MutableComponent getText() {
        return this.isTextEmpty() ? null : this.text.get(0);
    }

    public void setTextOld(List<Component> text) {
        this.setText(text);
    }

    public void setText(List<MutableComponent> text) {
        this.text = text;
        this.recalcTextRendering();
    }

    public void setText(Component text) {
        this.setText((MutableComponent)text);
    }

    public void setText(MutableComponent text) {
        this.setText(Collections.singletonList(text));
    }

    public void clearText() {
        this.setText(Collections.emptyList());
    }

    @Nullable
    public String getTextAsStringStrict() {
        return this.isTextEmpty() ? null : this.text.get(0).getString();
    }

    public String getTextAsString() {
        return this.isTextEmpty() ? "" : this.text.get(0).getString();
    }

    public boolean isTextEmpty() {
        return this.text == null || this.text.stream().allMatch(t -> t.getString().isEmpty());
    }

    public int getRenderedTextWidth() {
        return this.renderedTextWidth;
    }

    public int getRenderedTextHeight() {
        return this.renderedTextHeight;
    }

    public List<FormattedCharSequence> getPreparedText() {
        return this.preparedText;
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.setTextSize(w, h);
    }

    public void setTextSize(int w, int h) {
        this.textWidth = this.width;
        this.textHeight = this.height;
        this.recalcTextRendering();
    }
}

