/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.AbstractTextElement;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.Tooltip;
import com.ldtteam.blockui.util.SpacerTextComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public abstract class AbstractTextBuilder<P extends AbstractTextElement, R extends AbstractTextBuilder<P, R>> {
    private final Supplier<P> paneFactory;
    private int defaultColor = 0;
    private int color = 0;
    private boolean bold = false;
    private boolean italic = false;
    private boolean underlined = false;
    private boolean strikeThrough = false;
    private boolean obfuscated = false;
    private ClickEvent clickEvent = null;
    private String insertionEvent = null;
    private MutableComponent currentComponent;
    private final List<MutableComponent> text = new ArrayList<MutableComponent>();
    private int lastParagraphStart = 0;
    private R thiz = this;

    protected AbstractTextBuilder(Supplier<P> paneFactory, int defaultColor) {
        this.paneFactory = paneFactory;
        this.color = defaultColor;
        this.defaultColor = defaultColor;
    }

    public R appendNL(Component text) {
        return this.appendNL((MutableComponent)text);
    }

    public R appendNL(MutableComponent text) {
        this.newLine();
        this.append(text);
        return this.thiz;
    }

    public R append(Component text) {
        return this.append((MutableComponent)text);
    }

    public R append(MutableComponent text) {
        this.currentComponent = this.currentComponent == null ? text : this.currentComponent.m_7220_((Component)text);
        return this.thiz;
    }

    public R pixelSpacer(int spacerHeight) {
        this.newLine();
        this.text.add(SpacerTextComponent.of(spacerHeight));
        return this.thiz;
    }

    public R newLine() {
        if (this.currentComponent != null) {
            this.text.add(this.currentComponent);
            this.currentComponent = null;
        }
        return this.thiz;
    }

    public R emptyLines(int count) {
        this.newLine();
        for (int i = 0; i < count; ++i) {
            this.text.add(Component.m_237119_());
        }
        return this.thiz;
    }

    public R paragraphBreak() {
        return this.paragraphBreak(false);
    }

    public R paragraphBreak(boolean forceStyle) {
        this.newLine();
        Style style = new Style(Color.toVanilla(this.color), Boolean.valueOf(this.bold), Boolean.valueOf(this.italic), Boolean.valueOf(this.underlined), Boolean.valueOf(this.strikeThrough), Boolean.valueOf(this.obfuscated), this.clickEvent, null, this.insertionEvent, null);
        for (int i = this.lastParagraphStart; i < this.text.size(); ++i) {
            if (!forceStyle && !this.text.get(i).m_7383_().equals((Object)Style.f_131099_)) continue;
            this.text.get(i).m_6270_(style);
        }
        this.lastParagraphStart = this.text.size();
        this.resetStyle();
        return this.thiz;
    }

    public R resetStyle() {
        this.color = this.defaultColor;
        this.bold = false;
        this.italic = false;
        this.underlined = false;
        this.strikeThrough = false;
        this.obfuscated = false;
        this.clickEvent = null;
        this.insertionEvent = null;
        return this.thiz;
    }

    public R style(Style style) {
        if (style == null) {
            return this.resetStyle();
        }
        this.color = style.m_131135_() == null ? this.defaultColor : style.m_131135_().m_131265_();
        this.bold = style.m_131154_();
        this.italic = style.m_131161_();
        this.underlined = style.m_131171_();
        this.strikeThrough = style.m_131168_();
        this.obfuscated = style.m_131176_();
        this.clickEvent = style.m_131182_();
        this.insertionEvent = style.m_131189_();
        return this.thiz;
    }

    public R style(ChatFormatting textFormatting) {
        if (textFormatting == null) {
            return this.resetStyle();
        }
        switch (textFormatting) {
            case BOLD: {
                return this.bold();
            }
            case ITALIC: {
                return this.italic();
            }
            case OBFUSCATED: {
                return this.obfuscated();
            }
            case RESET: {
                return this.resetStyle();
            }
            case STRIKETHROUGH: {
                return this.strikeThrough();
            }
            case UNDERLINE: {
                return this.underlined();
            }
        }
        if (!textFormatting.m_126664_()) {
            throw new IllegalArgumentException("Unknown non-color textformatting.");
        }
        return this.color(textFormatting.m_126665_() == null ? this.defaultColor : textFormatting.m_126665_());
    }

    public R colorVanillaCode(char code) {
        ChatFormatting tf = ChatFormatting.m_126645_((char)code);
        return this.color(tf == null || tf.m_126665_() == null ? this.defaultColor : tf.m_126665_());
    }

    public R colorName(String name) {
        ChatFormatting tf = ChatFormatting.m_126657_((String)name);
        return this.color(Color.getByName(name, tf == null || tf.m_126665_() == null ? this.color : tf.m_126665_()));
    }

    public R colorParse(String colorIn) {
        return this.color(Color.parse(colorIn, this.color));
    }

    public R color(int color) {
        this.color = color;
        return this.thiz;
    }

    public R bold() {
        return this.bold(true);
    }

    public R bold(boolean bold) {
        this.bold = bold;
        return this.thiz;
    }

    public R italic() {
        return this.italic(true);
    }

    public R italic(boolean italic) {
        this.italic = italic;
        return this.thiz;
    }

    public R underlined() {
        return this.underlined(true);
    }

    public R underlined(boolean underlined) {
        this.underlined = underlined;
        return this.thiz;
    }

    public R strikeThrough() {
        return this.strikeThrough(true);
    }

    public R strikeThrough(boolean strikeThrough) {
        this.strikeThrough = strikeThrough;
        return this.thiz;
    }

    public R obfuscated() {
        return this.obfuscated(true);
    }

    public R obfuscated(boolean obfuscated) {
        this.obfuscated = obfuscated;
        return this.thiz;
    }

    public R clickEvent(ClickEvent clickEvent) {
        this.clickEvent = clickEvent;
        return this.thiz;
    }

    public R insertionEvent(String insertionEvent) {
        this.insertionEvent = insertionEvent;
        return this.thiz;
    }

    public P build() {
        this.paragraphBreak();
        AbstractTextElement pane = (AbstractTextElement)this.paneFactory.get();
        pane.setText(this.getText());
        return (P)pane;
    }

    public List<MutableComponent> getText() {
        return new ArrayList<MutableComponent>(this.text);
    }

    public static class TextBuilder
    extends AbstractTextBuilder<Text, TextBuilder> {
        public TextBuilder() {
            super(Text::new, 0xFFFFFF);
        }
    }

    public static class TooltipBuilder
    extends AbstractTextBuilder<Tooltip, TooltipBuilder> {
        private Pane hoverPane;

        public TooltipBuilder() {
            super(Tooltip::new, 0xFFFFFF);
        }

        public TooltipBuilder hoverPane(Pane hoverPane) {
            this.hoverPane = hoverPane;
            return this;
        }

        @Override
        public Tooltip build() {
            if (this.hoverPane == null) {
                throw new IllegalStateException("No hover pane specified.");
            }
            if (this.hoverPane.getWindow() == null) {
                throw new IllegalStateException("Hover pane does not have parent window specified.");
            }
            Tooltip tooltipPane = (Tooltip)super.build();
            this.hoverPane.setHoverPane(tooltipPane);
            return tooltipPane;
        }
    }
}

