/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.eureka.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.eureka.util.RotShape;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J=\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\u000e\u001a\u00020\t2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\f\"\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/valkyrienskies/eureka/util/RotShapes;", "", "", "x1", "y1", "z1", "x2", "y2", "z2", "Lorg/valkyrienskies/eureka/util/RotShape;", "box", "(DDDDDD)Lorg/valkyrienskies/eureka/util/RotShape;", "", "shapes", "or", "([Lorg/valkyrienskies/eureka/util/RotShape;)Lorg/valkyrienskies/eureka/util/RotShape;", "<init>", "()V", "Box", "Union", "eureka-1201"})
public final class RotShapes {
    @NotNull
    public static final RotShapes INSTANCE = new RotShapes();

    private RotShapes() {
    }

    @NotNull
    public final RotShape box(double x1, double y1, double z1, double x2, double y2, double z2) {
        return new Box(x1, y1, z1, x2, y2, z2);
    }

    @NotNull
    public final RotShape or(RotShape ... shapes) {
        Intrinsics.checkNotNullParameter((Object)shapes, (String)"shapes");
        return new Union(ArraysKt.asList((Object[])shapes));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0011\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u0012\u0006\u0010\u0012\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\u0010\u001a\u00020\u0007\u0012\u0006\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\u00020\u0001H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\t\u001a\u0004\b\r\u0010\u000bR\u0017\u0010\u000e\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\u000f\u0010\u000bR\u0017\u0010\u0010\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\t\u001a\u0004\b\u0011\u0010\u000bR\u0017\u0010\u0012\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\t\u001a\u0004\b\u0013\u0010\u000bR\u0017\u0010\u0014\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\t\u001a\u0004\b\u0015\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/valkyrienskies/eureka/util/RotShapes$Box;", "Lorg/valkyrienskies/eureka/util/RotShape;", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "makeMcShape", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "rotate90", "()Lorg/valkyrienskies/eureka/util/RotShape;", "", "x1", "D", "getX1", "()D", "x2", "getX2", "y1", "getY1", "y2", "getY2", "z1", "getZ1", "z2", "getZ2", "<init>", "(DDDDDD)V", "eureka-1201"})
    private static final class Box
    implements RotShape {
        private final double x1;
        private final double y1;
        private final double z1;
        private final double x2;
        private final double y2;
        private final double z2;

        public Box(double x1, double y1, double z1, double x2, double y2, double z2) {
            this.x1 = x1;
            this.y1 = y1;
            this.z1 = z1;
            this.x2 = x2;
            this.y2 = y2;
            this.z2 = z2;
        }

        public final double getX1() {
            return this.x1;
        }

        public final double getY1() {
            return this.y1;
        }

        public final double getZ1() {
            return this.z1;
        }

        public final double getX2() {
            return this.x2;
        }

        public final double getY2() {
            return this.y2;
        }

        public final double getZ2() {
            return this.z2;
        }

        @Override
        @NotNull
        public RotShape rotate90() {
            return new Box((double)16 - this.z1, this.y1, this.x1, (double)16 - this.z2, this.y2, this.x2);
        }

        @Override
        @NotNull
        public VoxelShape makeMcShape() {
            VoxelShape voxelShape = Shapes.m_83048_((double)(Math.min(this.x1, this.x2) / (double)16), (double)(Math.min(this.y1, this.y2) / (double)16), (double)(Math.min(this.z1, this.z2) / (double)16), (double)(Math.max(this.x1, this.x2) / (double)16), (double)(Math.max(this.y1, this.y2) / (double)16), (double)(Math.max(this.z1, this.z2) / (double)16));
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(\n            min(x1,\u2026        max(z1, z2) / 16)");
            return voxelShape;
        }

        @Override
        @NotNull
        public RotShape rotate180() {
            return RotShape.DefaultImpls.rotate180(this);
        }

        @Override
        @NotNull
        public RotShape rotate270() {
            return RotShape.DefaultImpls.rotate270(this);
        }

        @Override
        @NotNull
        public VoxelShape build() {
            return RotShape.DefaultImpls.build(this);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\u00020\u0001H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/valkyrienskies/eureka/util/RotShapes$Union;", "Lorg/valkyrienskies/eureka/util/RotShape;", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "makeMcShape", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "rotate90", "()Lorg/valkyrienskies/eureka/util/RotShape;", "", "shapes", "Ljava/util/List;", "getShapes", "()Ljava/util/List;", "<init>", "(Ljava/util/List;)V", "eureka-1201"})
    private static final class Union
    implements RotShape {
        @NotNull
        private final List<RotShape> shapes;

        public Union(@NotNull List<? extends RotShape> shapes) {
            Intrinsics.checkNotNullParameter(shapes, (String)"shapes");
            this.shapes = shapes;
        }

        @NotNull
        public final List<RotShape> getShapes() {
            return this.shapes;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public RotShape rotate90() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.shapes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RotShape rotShape = (RotShape)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.rotate90());
            }
            List list = (List)destination$iv$iv;
            return new Union(list);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public VoxelShape makeMcShape() {
            void $this$fold$iv;
            Iterable iterable = this.shapes;
            VoxelShape initial$iv = Shapes.m_83040_();
            boolean $i$f$fold = false;
            VoxelShape accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void n;
                RotShape rotShape = (RotShape)element$iv;
                VoxelShape mc = accumulator$iv;
                boolean bl = false;
                accumulator$iv = Shapes.m_83110_((VoxelShape)mc, (VoxelShape)n.makeMcShape());
            }
            VoxelShape voxelShape = accumulator$iv;
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"shapes.fold(Shapes.empty\u2026or(mc, n.makeMcShape()) }");
            return voxelShape;
        }

        @Override
        @NotNull
        public RotShape rotate180() {
            return RotShape.DefaultImpls.rotate180(this);
        }

        @Override
        @NotNull
        public RotShape rotate270() {
            return RotShape.DefaultImpls.rotate270(this);
        }

        @Override
        @NotNull
        public VoxelShape build() {
            return RotShape.DefaultImpls.build(this);
        }
    }
}

