/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.eureka.ship;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import org.valkyrienskies.core.impl.pipelines.SegmentUtils;
import org.valkyrienskies.eureka.EurekaConfig;
import org.valkyrienskies.physics_api.PoseVel;
import org.valkyrienskies.physics_api.SegmentDisplacement;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u001aE\u0010\r\u001a\u00020\f2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/PhysShipImpl;", "ship", "Lorg/joml/Vector3dc;", "omega", "vel", "Lorg/valkyrienskies/physics_api/SegmentDisplacement;", "segment", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "forces", "", "linear", "yaw", "", "stabilize", "(Lorg/valkyrienskies/core/impl/game/ships/PhysShipImpl;Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;Lorg/valkyrienskies/physics_api/SegmentDisplacement;Lorg/valkyrienskies/core/api/ships/PhysShip;ZZ)V", "eureka-1201"})
public final class StabilizeKt {
    public static final void stabilize(@NotNull PhysShipImpl ship, @NotNull Vector3dc omega, @NotNull Vector3dc vel, @NotNull SegmentDisplacement segment, @NotNull PhysShip forces, boolean linear, boolean yaw) {
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Intrinsics.checkNotNullParameter((Object)omega, (String)"omega");
        Intrinsics.checkNotNullParameter((Object)vel, (String)"vel");
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        Intrinsics.checkNotNullParameter((Object)forces, (String)"forces");
        Vector3d shipUp = new Vector3d(0.0, 1.0, 0.0);
        Vector3d worldUp = new Vector3d(0.0, 1.0, 0.0);
        SegmentUtils.INSTANCE.transformDirectionWithoutScale(ship.getPoseVel(), segment, (Vector3dc)shipUp, shipUp);
        double angleBetween = shipUp.angle((Vector3dc)worldUp);
        Vector3d idealAngularAcceleration = new Vector3d();
        if (angleBetween > 0.01) {
            Vector3d stabilizationRotationAxisNormalized = shipUp.cross((Vector3dc)worldUp, new Vector3d()).normalize();
            idealAngularAcceleration.add((Vector3dc)stabilizationRotationAxisNormalized.mul(angleBetween, stabilizationRotationAxisNormalized));
        }
        idealAngularAcceleration.sub(omega.x(), !yaw ? 0.0 : omega.y(), omega.z());
        PoseVel poseVel = ship.getPoseVel();
        Vector3d vector3d = ship.getInertia().getMomentOfInertiaTensor().transform(SegmentUtils.INSTANCE.invTransformDirectionWithScale(ship.getPoseVel(), segment, (Vector3dc)idealAngularAcceleration, idealAngularAcceleration));
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"ship.inertia.momentOfIne\u2026n\n            )\n        )");
        Vector3d stabilizationTorque = SegmentUtils.INSTANCE.transformDirectionWithScale(poseVel, segment, (Vector3dc)vector3d, idealAngularAcceleration);
        stabilizationTorque.mul(EurekaConfig.SERVER.getStabilizationTorqueConstant());
        forces.applyInvariantTorque((Vector3dc)stabilizationTorque);
        if (linear) {
            Vector3d idealVelocity = new Vector3d(vel).negate();
            idealVelocity.y = 0.0;
            if (idealVelocity.lengthSquared() > EurekaConfig.SERVER.getLinearStabilizeMaxAntiVelocity() * EurekaConfig.SERVER.getLinearStabilizeMaxAntiVelocity()) {
                idealVelocity.normalize(EurekaConfig.SERVER.getLinearStabilizeMaxAntiVelocity());
            }
            idealVelocity.mul(ship.getInertia().getShipMass() * ((double)10 - EurekaConfig.SERVER.getAntiVelocityMassRelevance()));
            Intrinsics.checkNotNullExpressionValue((Object)idealVelocity, (String)"idealVelocity");
            forces.applyInvariantForce((Vector3dc)idealVelocity);
        }
    }
}

