/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.eureka.forge;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.valkyrienskies.core.impl.config.VSConfigClass;
import org.valkyrienskies.eureka.EurekaBlockEntities;
import org.valkyrienskies.eureka.EurekaConfig;
import org.valkyrienskies.eureka.EurekaItems;
import org.valkyrienskies.eureka.EurekaMod;
import org.valkyrienskies.eureka.block.WoodType;
import org.valkyrienskies.eureka.blockentity.renderer.ShipHelmBlockEntityRenderer;
import org.valkyrienskies.eureka.blockentity.renderer.WheelModels;
import org.valkyrienskies.eureka.forge.EurekaBlockTagsProvider;
import org.valkyrienskies.mod.compat.clothconfig.VSClothConfig;

@Mod(value="vs_eureka")
public class EurekaModForge {
    private boolean handledClientSetup = false;
    static IEventBus MOD_BUS;

    public EurekaModForge() {
        MOD_BUS = FMLJavaModLoadingContext.get().getModEventBus();
        boolean isClient = FMLEnvironment.dist.isClient();
        if (isClient) {
            MOD_BUS.addListener(this::clientSetup);
            MOD_BUS.addListener(this::onModelRegistry);
            MOD_BUS.addListener(this::onModelBaked);
            MOD_BUS.addListener(this::entityRenderers);
        }
        MOD_BUS.addListener(this::onGatherData);
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> VSClothConfig.createConfigScreenFor((Screen)parent, (VSConfigClass[])new VSConfigClass[]{VSConfigClass.Companion.getRegisteredConfig(EurekaConfig.class)})));
        EurekaMod.init();
        EurekaModForge.carryOnModSupport();
        DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"vs_eureka");
        deferredRegister.register("general", EurekaItems.INSTANCE::createCreativeTab);
        deferredRegister.register(MOD_BUS);
    }

    private static void carryOnModSupport() {
        if (ModList.get().isLoaded("carryon")) {
            String[] exclusions;
            Logger LOGGER = LogManager.getLogger((String)"vs_eureka");
            LOGGER.info("vs_eureka: Carry On was detected, sending blacklist.");
            for (String item : exclusions = new String[]{"vs_eureka:oak_ship_helm", "vs_eureka:spruce_ship_helm", "vs_eureka:birch_ship_helm", "vs_eureka:jungle_ship_helm", "vs_eureka:acacia_ship_helm", "vs_eureka:dark_oak_ship_helm", "vs_eureka:crimson_ship_helm", "vs_eureka:warped_ship_helm"}) {
                InterModComms.sendTo((String)"carryon", (String)"blacklistBlock", () -> {
                    LOGGER.debug("carryon->blacklistBlock->" + item);
                    return item;
                });
            }
        }
    }

    void clientSetup(FMLClientSetupEvent event) {
        if (this.handledClientSetup) {
            return;
        }
        this.handledClientSetup = true;
        EurekaMod.initClient();
    }

    void entityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(EurekaBlockEntities.INSTANCE.getSHIP_HELM().get(), ShipHelmBlockEntityRenderer::new);
    }

    void onModelRegistry(ModelEvent.RegisterAdditional event) {
        for (WoodType woodType : WoodType.values()) {
            event.register(new ResourceLocation("vs_eureka", "block/" + woodType.getResourceName() + "_ship_helm_wheel"));
        }
    }

    void onModelBaked(ModelEvent.BakingCompleted event) {
        WheelModels.INSTANCE.setModelGetter(woodType -> event.getModelBakery().m_119251_().getOrDefault(new ResourceLocation("vs_eureka", "block/" + woodType.getResourceName() + "_ship_helm_wheel"), Minecraft.m_91087_().m_91304_().m_119409_()));
    }

    void onGatherData(GatherDataEvent event) {
        EurekaBlockTagsProvider blockTagProvider = new EurekaBlockTagsProvider(event.getGenerator().getPackOutput(), event.getLookupProvider(), "vs_eureka", event.getExistingFileHelper());
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)blockTagProvider);
    }
}

