/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.eureka.blockentity;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.impl.api.ServerShipProvider;
import org.valkyrienskies.core.impl.api.ShipValueDelegate;
import org.valkyrienskies.eureka.EurekaBlockEntities;
import org.valkyrienskies.eureka.EurekaConfig;
import org.valkyrienskies.eureka.EurekaProperties;
import org.valkyrienskies.eureka.gui.engine.EngineScreenMenu;
import org.valkyrienskies.eureka.ship.EurekaShipControl;
import org.valkyrienskies.eureka.util.ContainerDataDelegate;
import org.valkyrienskies.eureka.util.KtContainerData;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0017\u0012\u0006\u0010c\u001a\u00020b\u0012\u0006\u0010e\u001a\u00020d\u00a2\u0006\u0004\bf\u0010gJ\u001f\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ)\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J+\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0016H\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010\"\u001a\u00020!H\u0014\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b%\u0010&J\u0019\u0010)\u001a\u00020(2\b\u0010'\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0004\b)\u0010*J\r\u0010+\u001a\u00020\t\u00a2\u0006\u0004\b+\u0010,J\u000f\u0010-\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b-\u0010,J\u0017\u00100\u001a\u00020\u00122\u0006\u0010/\u001a\u00020.H\u0016\u00a2\u0006\u0004\b0\u00101J\u001f\u00103\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b3\u00104J\u0017\u00105\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b5\u0010&J\u0017\u00107\u001a\u00020\u00122\u0006\u00106\u001a\u00020.H\u0014\u00a2\u0006\u0004\b7\u00101J\u001f\u00108\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b8\u00109J\u0017\u0010<\u001a\u00020\t2\u0006\u0010;\u001a\u00020:H\u0016\u00a2\u0006\u0004\b<\u0010=J\r\u0010>\u001a\u00020\u0012\u00a2\u0006\u0004\b>\u0010\u0014R\u0017\u0010@\u001a\u00020?8\u0006\u00a2\u0006\f\n\u0004\b@\u0010A\u001a\u0004\bB\u0010CR\u001d\u0010I\u001a\u0004\u0018\u00010D8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bE\u0010F\u001a\u0004\bG\u0010HR\u0016\u0010J\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u0010KR+\u0010R\u001a\u00020\u00052\u0006\u0010L\u001a\u00020\u00058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bM\u0010N\u001a\u0004\bO\u0010 \"\u0004\bP\u0010QR+\u0010V\u001a\u00020\u00052\u0006\u0010L\u001a\u00020\u00058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bS\u0010N\u001a\u0004\bT\u0010 \"\u0004\bU\u0010QR\u0016\u0010X\u001a\u00020W8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bX\u0010YR+\u0010]\u001a\u00020\u00052\u0006\u0010L\u001a\u00020\u00058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bZ\u0010N\u001a\u0004\b[\u0010 \"\u0004\b\\\u0010QR\u0016\u0010a\u001a\u0004\u0018\u00010^8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b_\u0010`\u00a8\u0006h"}, d2={"Lorg/valkyrienskies/eureka/blockentity/EngineBlockEntity;", "Lnet/minecraft/world/level/block/entity/BaseContainerBlockEntity;", "Lorg/valkyrienskies/core/impl/api/ServerShipProvider;", "Lnet/minecraft/world/inventory/StackedContentsCompatible;", "Lnet/minecraft/world/WorldlyContainer;", "", "index", "Lnet/minecraft/world/item/ItemStack;", "stack", "", "canPlaceItem", "(ILnet/minecraft/world/item/ItemStack;)Z", "itemStack", "Lnet/minecraft/core/Direction;", "direction", "canPlaceItemThroughFace", "(ILnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/Direction;)Z", "canTakeItemThroughFace", "", "clearContent", "()V", "containerId", "Lnet/minecraft/world/entity/player/Inventory;", "inventory", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "createMenu", "(ILnet/minecraft/world/entity/player/Inventory;)Lnet/minecraft/world/inventory/AbstractContainerMenu;", "Lnet/minecraft/world/entity/player/StackedContents;", "helper", "fillStackedContents", "(Lnet/minecraft/world/entity/player/StackedContents;)V", "getContainerSize", "()I", "Lnet/minecraft/network/chat/Component;", "getDefaultName", "()Lnet/minecraft/network/chat/Component;", "slot", "getItem", "(I)Lnet/minecraft/world/item/ItemStack;", "side", "", "getSlotsForFace", "(Lnet/minecraft/core/Direction;)[I", "isBurning", "()Z", "isEmpty", "Lnet/minecraft/nbt/CompoundTag;", "compoundTag", "load", "(Lnet/minecraft/nbt/CompoundTag;)V", "amount", "removeItem", "(II)Lnet/minecraft/world/item/ItemStack;", "removeItemNoUpdate", "tag", "saveAdditional", "setItem", "(ILnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/world/entity/player/Player;", "player", "stillValid", "(Lnet/minecraft/world/entity/player/Player;)Z", "tick", "Lorg/valkyrienskies/eureka/util/KtContainerData;", "data", "Lorg/valkyrienskies/eureka/util/KtContainerData;", "getData", "()Lorg/valkyrienskies/eureka/util/KtContainerData;", "Lorg/valkyrienskies/eureka/ship/EurekaShipControl;", "eurekaShipControl$delegate", "Lorg/valkyrienskies/core/impl/api/ShipValueDelegate;", "getEurekaShipControl", "()Lorg/valkyrienskies/eureka/ship/EurekaShipControl;", "eurekaShipControl", "fuel", "Lnet/minecraft/world/item/ItemStack;", "<set-?>", "fuelLeft$delegate", "Lorg/valkyrienskies/eureka/util/ContainerDataDelegate;", "getFuelLeft", "setFuelLeft", "(I)V", "fuelLeft", "fuelTotal$delegate", "getFuelTotal", "setFuelTotal", "fuelTotal", "", "heat", "F", "heatLevel$delegate", "getHeatLevel", "setHeatLevel", "heatLevel", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "getShip", "()Lorg/valkyrienskies/core/api/ships/ServerShip;", "ship", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "eureka-1201"})
public final class EngineBlockEntity
extends BaseContainerBlockEntity
implements ServerShipProvider,
StackedContentsCompatible,
WorldlyContainer {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ShipValueDelegate eurekaShipControl$delegate;
    @NotNull
    private final KtContainerData data;
    @NotNull
    private final ContainerDataDelegate heatLevel$delegate;
    @NotNull
    private final ContainerDataDelegate fuelLeft$delegate;
    @NotNull
    private final ContainerDataDelegate fuelTotal$delegate;
    @NotNull
    private ItemStack fuel;
    private float heat;

    public EngineBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(EurekaBlockEntities.INSTANCE.getENGINE().get(), pos, state);
        boolean $i$f$shipValue = false;
        this.eurekaShipControl$delegate = new ShipValueDelegate(EurekaShipControl.class, false);
        this.data = new KtContainerData();
        this.heatLevel$delegate = this.data.provideDelegate((Object)this, $$delegatedProperties[1]);
        this.fuelLeft$delegate = this.data.provideDelegate((Object)this, $$delegatedProperties[2]);
        this.fuelTotal$delegate = this.data.provideDelegate((Object)this, $$delegatedProperties[3]);
        ItemStack itemStack = ItemStack.f_41583_;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.fuel = itemStack;
    }

    @Nullable
    public ServerShip getShip() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"this.blockPos");
        return VSGameUtilsKt.getShipManagingPos((ServerLevel)serverLevel, (BlockPos)blockPos);
    }

    private final EurekaShipControl getEurekaShipControl() {
        return (EurekaShipControl)this.eurekaShipControl$delegate.getValue((ServerShipProvider)this, $$delegatedProperties[0]);
    }

    @NotNull
    public final KtContainerData getData() {
        return this.data;
    }

    public final int getHeatLevel() {
        return this.heatLevel$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    public final void setHeatLevel(int n) {
        this.heatLevel$delegate.setValue((Object)this, $$delegatedProperties[1], n);
    }

    public final int getFuelLeft() {
        return this.fuelLeft$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    public final void setFuelLeft(int n) {
        this.fuelLeft$delegate.setValue((Object)this, $$delegatedProperties[2], n);
    }

    public final int getFuelTotal() {
        return this.fuelTotal$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    public final void setFuelTotal(int n) {
        this.fuelTotal$delegate.setValue((Object)this, $$delegatedProperties[3], n);
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int containerId, @NotNull Inventory inventory) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        return new EngineScreenMenu(containerId, inventory, this);
    }

    @NotNull
    protected Component m_6820_() {
        MutableComponent mutableComponent = Component.m_237115_((String)"gui.vs_eureka.engine");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(\"gui.vs_eureka.engine\")");
        return (Component)mutableComponent;
    }

    public final void tick() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!level.f_46443_) {
            Level level2 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level2);
            if (level2.m_276867_(this.m_58899_())) {
                this.setHeatLevel(0);
                Level level3 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level3);
                level3.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)EurekaProperties.INSTANCE.getHEAT(), (Comparable)Integer.valueOf(0)), 11);
                return;
            }
            if (this.getFuelLeft() > 0) {
                int n = this.getFuelLeft();
                this.setFuelLeft(n + -1);
                if (this.heat < 100.0f) {
                    this.heat += EurekaConfig.SERVER.getEngineHeatGain();
                }
            } else if (!this.fuel.m_41619_() && this.heat < 100.0f) {
                Integer n = (Integer)FurnaceBlockEntity.m_58423_().get(this.fuel.m_41720_());
                this.setFuelTotal((n != null ? n : 0) * 2);
                this.setFuelLeft(this.getFuelTotal());
                this.m_7407_(0, 1);
                this.m_6596_();
            }
            int prevHeatLevel = this.getHeatLevel();
            this.setHeatLevel(org.joml.Math.min((int)((int)Math.ceil(this.heat * 4.0f / 100.0f)), (int)4));
            if (prevHeatLevel != this.getHeatLevel()) {
                Level level4 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level4);
                level4.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)EurekaProperties.INSTANCE.getHEAT(), (Comparable)Integer.valueOf(this.getHeatLevel())), 11);
            }
            if (this.heat > 0.0f && this.getShip() != null && this.getEurekaShipControl() != null) {
                EurekaShipControl eurekaShipControl = this.getEurekaShipControl();
                Intrinsics.checkNotNull((Object)eurekaShipControl);
                EurekaShipControl eurekaShipControl2 = eurekaShipControl;
                eurekaShipControl2.setPower(eurekaShipControl2.getPower() + (double)org.joml.Math.lerp((float)(this.heat / 100.0f), (float)EurekaConfig.SERVER.getMinEnginePower(), (float)EurekaConfig.SERVER.getEnginePower()));
                EurekaShipControl eurekaShipControl3 = this.getEurekaShipControl();
                Intrinsics.checkNotNull((Object)eurekaShipControl3);
                this.heat -= eurekaShipControl3.getConsumed();
            }
            if (this.heat > 0.0f) {
                this.heat -= org.joml.Math.min((float)EurekaConfig.SERVER.getEngineHeatLoss(), (float)this.heat);
            }
        }
    }

    public final boolean isBurning() {
        return this.getFuelLeft() > 0;
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.m_128365_("FuelSlot", (Tag)this.fuel.m_41739_(new CompoundTag()));
        tag.m_128405_("FuelLeft", this.getFuelLeft());
        tag.m_128405_("PrevFuelTotal", this.getFuelTotal());
        tag.m_128350_("Heat", this.heat);
        super.m_183515_(tag);
    }

    public void m_142466_(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        ItemStack itemStack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("FuelSlot"));
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"of(compoundTag.getCompound(\"FuelSlot\"))");
        this.fuel = itemStack;
        this.setFuelLeft(compoundTag.m_128451_("FuelLeft"));
        this.setFuelTotal(compoundTag.m_128451_("PrevFuelTotal"));
        this.heat = compoundTag.m_128457_("Heat");
        super.m_142466_(compoundTag);
    }

    public void m_6211_() {
        ItemStack itemStack = ItemStack.f_41583_;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.fuel = itemStack;
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return this.fuel.m_41619_();
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        ItemStack itemStack;
        if (slot == 0) {
            itemStack = this.fuel;
        } else {
            ItemStack itemStack2 = ItemStack.f_41583_;
            itemStack = itemStack2;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
        }
        return itemStack;
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.m_18969_((List)CollectionsKt.listOf((Object)this.fuel), (int)slot, (int)amount);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"removeItem(listOf(fuel), slot, amount)");
        return itemStack;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        if (slot == 0) {
            ItemStack itemStack = ItemStack.f_41583_;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            this.fuel = itemStack;
        }
        ItemStack itemStack = ItemStack.f_41583_;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        return itemStack;
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (slot == 0) {
            this.fuel = stack;
        }
    }

    public boolean m_6542_(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        return level.m_7702_(this.f_58858_) != this ? false : player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @NotNull
    public int[] m_7071_(@Nullable Direction side) {
        int[] nArray;
        if (side == Direction.DOWN) {
            nArray = new int[]{};
        } else {
            int[] nArray2 = new int[]{0};
            nArray = nArray2;
        }
        return nArray;
    }

    public boolean m_7155_(int index, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return direction != Direction.DOWN && this.m_7013_(index, itemStack);
    }

    public boolean m_7157_(int index, @Nullable ItemStack stack, @Nullable Direction direction) {
        return false;
    }

    public boolean m_7013_(int index, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return index == 0 && AbstractFurnaceBlockEntity.m_58399_((ItemStack)stack);
    }

    public void m_5809_(@NotNull StackedContents helper) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        helper.m_36491_(this.fuel);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(EngineBlockEntity.class, "eurekaShipControl", "getEurekaShipControl()Lorg/valkyrienskies/eureka/ship/EurekaShipControl;", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(EngineBlockEntity.class, "heatLevel", "getHeatLevel()I", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(EngineBlockEntity.class, "fuelLeft", "getFuelLeft()I", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(EngineBlockEntity.class, "fuelTotal", "getFuelTotal()I", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

