/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.signtastic.modules.signs.network;

import com.mcjty.signtastic.modules.signs.TextureType;
import com.mcjty.signtastic.modules.signs.blocks.AbstractSignTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateSignData {
    private final BlockPos pos;
    private final Integer backColor;
    private final int textColor;
    private final boolean bright;
    private final boolean transparent;
    private final boolean large;
    private final int imageIndex;
    private final List<String> lines;
    private final TextureType textureType;

    public PacketUpdateSignData(BlockPos pos, List<String> lines, Integer backColor, int textColor, boolean bright, boolean transparent, boolean large, TextureType textureType, int imageIndex) {
        this.pos = pos;
        this.lines = lines;
        this.backColor = backColor;
        this.textColor = textColor;
        this.bright = bright;
        this.large = large;
        this.transparent = transparent;
        this.textureType = textureType;
        this.imageIndex = imageIndex;
    }

    public PacketUpdateSignData(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.backColor = buf.readBoolean() ? Integer.valueOf(buf.readInt()) : null;
        this.textColor = buf.readInt();
        this.bright = buf.readBoolean();
        this.transparent = buf.readBoolean();
        this.large = buf.readBoolean();
        this.textureType = TextureType.values()[buf.readInt()];
        this.imageIndex = buf.readInt();
        int s = buf.readInt();
        this.lines = new ArrayList<String>();
        for (int i = 0; i < s; ++i) {
            this.lines.add(buf.m_130136_(Short.MAX_VALUE));
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        if (this.backColor != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.backColor.intValue());
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(this.textColor);
        buf.writeBoolean(this.bright);
        buf.writeBoolean(this.transparent);
        buf.writeBoolean(this.large);
        buf.writeInt(this.textureType.ordinal());
        buf.writeInt(this.imageIndex);
        buf.writeInt(this.lines.size());
        this.lines.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130070_(arg_0));
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        BlockEntity te = ctx.getSender().m_9236_().m_7702_(this.pos);
        if (te instanceof AbstractSignTileEntity) {
            AbstractSignTileEntity sign = (AbstractSignTileEntity)te;
            sign.setLines(this.lines);
            sign.setBackColor(this.backColor);
            sign.setTextColor(this.textColor);
            sign.setBright(this.bright);
            sign.setLarge(this.large);
            sign.setTransparent(this.transparent);
            sign.setTextureType(this.textureType);
            sign.setIconIndex(this.imageIndex);
        }
        return true;
    }
}

