/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.signtastic.modules.signs.client;

import com.mcjty.signtastic.modules.signs.SignSettings;
import com.mcjty.signtastic.modules.signs.SignsModule;
import com.mcjty.signtastic.modules.signs.TextureType;
import com.mcjty.signtastic.modules.signs.blocks.AbstractSignBlock;
import com.mcjty.signtastic.modules.signs.blocks.AbstractSignTileEntity;
import com.mcjty.signtastic.setup.Config;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.lib.client.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class SignRenderer
implements BlockEntityRenderer<AbstractSignTileEntity> {
    public static final ResourceLocation SIGNS = new ResourceLocation("signtastic", "block/signs");

    public SignRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(AbstractSignTileEntity tileEntity, float v, PoseStack matrixStack, MultiBufferSource buffer, int packedLightIn, int packedOverlayIn) {
        SignRenderer.renderInternal(tileEntity, matrixStack, buffer, packedLightIn, packedOverlayIn);
    }

    public static void renderInternal(AbstractSignTileEntity tileEntity, PoseStack matrixStack, MultiBufferSource buffer, int packedLightIn, int packedOverlayIn) {
        BlockState state = Minecraft.m_91087_().f_91073_.m_8055_(tileEntity.m_58899_());
        if (!(state.m_60734_() instanceof AbstractSignBlock)) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        Direction horizontalFacing = (Direction)state.m_61143_((Property)AbstractSignBlock.HORIZ_FACING);
        matrixStack.m_85836_();
        float yRotation = switch (horizontalFacing) {
            case Direction.NORTH -> -180.0f;
            case Direction.WEST -> -90.0f;
            case Direction.EAST -> 90.0f;
            default -> 0.0f;
        };
        float xRotation = switch (facing) {
            case Direction.DOWN -> 90.0f;
            case Direction.UP -> -90.0f;
            default -> 0.0f;
        };
        matrixStack.m_252880_(0.5f, 0.5f, 0.5f);
        RenderHelper.rotateYP((PoseStack)matrixStack, (float)yRotation);
        RenderHelper.rotateXP((PoseStack)matrixStack, (float)xRotation);
        matrixStack.m_252880_(0.0f, 0.0f, -0.4375f);
        SignSettings settings = tileEntity.getSettings();
        if (!settings.isTransparent()) {
            SignRenderer.renderScreenBoard(matrixStack, buffer, settings.getTextureType(), tileEntity.getRenderOffset(), settings.getBackColor(), packedLightIn);
        }
        if (settings.getIconIndex() > 0) {
            SignRenderer.renderImage(tileEntity, matrixStack, buffer, settings.isBright() ? 0xF000F0 : packedLightIn, settings.getIconIndex());
        }
        Font fontrenderer = Minecraft.m_91087_().f_91062_;
        SignRenderer.renderText(matrixStack, buffer, fontrenderer, tileEntity, settings.isLarge(), packedLightIn);
        matrixStack.m_85849_();
    }

    private static void renderImage(AbstractSignTileEntity tileEntity, PoseStack matrixStack, MultiBufferSource buffer, int packedLightIn, int idx) {
        int cols = (Integer)Config.HORIZONTAL_ICONS.get();
        int rows = (Integer)Config.VERTICAL_ICONS.get();
        matrixStack.m_85836_();
        matrixStack.m_85841_(1.0f, -1.0f, -1.0f);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(SIGNS);
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110463_());
        float dim = 0.46f;
        float offs = -0.01f - tileEntity.getRenderOffset();
        int sx = idx % cols;
        int sy = idx / rows;
        float u0 = sprite.m_118409_();
        float v0 = sprite.m_118411_();
        float v1 = sprite.m_118412_();
        float u1 = sprite.m_118410_();
        float du = (u1 - u0) / (float)cols;
        float dv = (v1 - v0) / (float)rows;
        u1 = (u0 += (float)sx * du) + du;
        v1 = (v0 += (float)sy * dv) + dv;
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)-0.46f, (float)dim, (float)offs, (float)u0, (float)v1, (int)packedLightIn);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)dim, (float)dim, (float)offs, (float)u1, (float)v1, (int)packedLightIn);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)dim, (float)-0.46f, (float)offs, (float)u1, (float)v0, (int)packedLightIn);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)-0.46f, (float)-0.46f, (float)offs, (float)u0, (float)v0, (int)packedLightIn);
        matrixStack.m_85849_();
    }

    private static void renderText(PoseStack matrixStack, MultiBufferSource buffer, Font fontrenderer, AbstractSignTileEntity tileEntity, boolean large, int lightmapValue) {
        SignSettings settings = tileEntity.getSettings();
        float factor = 2.0f + (float)(large ? 2 : 0);
        int currenty = 9 - (large ? 4 : 0);
        float f = 0.005f;
        matrixStack.m_85836_();
        matrixStack.m_252880_(-0.5f, 0.5f, 0.02f + tileEntity.getRenderOffset());
        matrixStack.m_85841_(f * factor, -1.0f * f * factor, f);
        int l = 0;
        int linesSupported = tileEntity.getLinesSupported();
        if (settings.isLarge()) {
            linesSupported /= 2;
        }
        for (String line : tileEntity.getLines()) {
            RenderHelper.renderText((Font)fontrenderer, (String)line, (int)5, (int)currenty, (int)(0xFF000000 | settings.getTextColor()), (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)(settings.isBright() ? 0xF000F0 : lightmapValue));
            currenty += 10;
            if (++l < linesSupported) continue;
            break;
        }
        matrixStack.m_85849_();
    }

    private static void renderScreenBoard(PoseStack matrixStack, @Nullable MultiBufferSource buffer, TextureType textureType, float renderOffset, Integer color, int packedLight) {
        matrixStack.m_85836_();
        matrixStack.m_85841_(1.0f, -1.0f, -1.0f);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(textureType.getId());
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110451_());
        float dim = 0.46f;
        float zback = 0.05f;
        float zfront = -renderOffset;
        float ss = 0.5f;
        float u0 = sprite.m_118409_();
        float v0 = sprite.m_118411_();
        float u1 = sprite.m_118410_();
        float v1 = sprite.m_118412_();
        float su = (u1 - u0) * (0.1f + renderOffset);
        float sv = (v1 - v0) * (0.1f + renderOffset);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)(-ss), (float)(-ss), (float)zback, (float)u0, (float)v0, (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)ss, (float)(-ss), (float)zback, (float)u1, (float)v0, (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)ss, (float)ss, (float)zback, (float)u1, (float)v1, (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)(-ss), (float)ss, (float)zback, (float)u0, (float)v1, (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)(-ss), (float)ss, (float)zfront, (float)u0, (float)v0, (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)ss, (float)ss, (float)zfront, (float)u1, (float)v0, (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)ss, (float)(-ss), (float)zfront, (float)u1, (float)v1, (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)(-ss), (float)(-ss), (float)zfront, (float)u0, (float)v1, (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)(-ss), (float)ss, (float)zback, (float)u0, (float)v0, (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)ss, (float)ss, (float)zback, (float)u1, (float)v0, (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)ss, (float)ss, (float)zfront, (float)u1, (float)(v0 + sv), (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)(-ss), (float)ss, (float)zfront, (float)u0, (float)(v0 + sv), (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)(-ss), (float)(-ss), (float)zfront, (float)u0, (float)v0, (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)ss, (float)(-ss), (float)zfront, (float)u1, (float)v0, (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)ss, (float)(-ss), (float)zback, (float)u1, (float)(v0 + sv), (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)(-ss), (float)(-ss), (float)zback, (float)u0, (float)(v0 + sv), (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)(-ss), (float)(-ss), (float)zfront, (float)u0, (float)v0, (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)(-ss), (float)(-ss), (float)zback, (float)(u0 + su), (float)v0, (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)(-ss), (float)ss, (float)zback, (float)(u0 + su), (float)v1, (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)(-ss), (float)ss, (float)zfront, (float)u0, (float)v1, (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)ss, (float)ss, (float)zfront, (float)u0, (float)v0, (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)ss, (float)ss, (float)zback, (float)(u0 + su), (float)v0, (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)ss, (float)(-ss), (float)zback, (float)(u0 + su), (float)v1, (int)packedLight);
        RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)ss, (float)(-ss), (float)zfront, (float)u0, (float)v1, (int)packedLight);
        if (color != null) {
            builder = buffer.m_6299_(CustomRenderTypes.QUADS_NOTEXTURE);
            float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
            float g = (float)((color & 0xFF00) >> 8) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float offs = -0.01f - renderOffset;
            RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)-0.46f, (float)dim, (float)offs, (float)r, (float)g, (float)b, (int)packedLight);
            RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)dim, (float)dim, (float)offs, (float)r, (float)g, (float)b, (int)packedLight);
            RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)dim, (float)-0.46f, (float)offs, (float)r, (float)g, (float)b, (int)packedLight);
            RenderHelper.vt((VertexConsumer)builder, (PoseStack)matrixStack, (float)-0.46f, (float)-0.46f, (float)offs, (float)r, (float)g, (float)b, (int)packedLight);
        }
        matrixStack.m_85849_();
    }

    public static void register() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)SignsModule.TYPE_SQUARE_SIGN.get()), SignRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)SignsModule.TYPE_BLOCK_SIGN.get()), SignRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)SignsModule.TYPE_SLAB_SIGN.get()), SignRenderer::new);
    }
}

