/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.signtastic.modules.signs.client;

import com.mcjty.signtastic.modules.signs.SignSettings;
import com.mcjty.signtastic.modules.signs.SignsModule;
import com.mcjty.signtastic.modules.signs.TextureType;
import com.mcjty.signtastic.modules.signs.blocks.AbstractSignTileEntity;
import com.mcjty.signtastic.modules.signs.network.PacketUpdateSignData;
import com.mcjty.signtastic.setup.Config;
import com.mcjty.signtastic.setup.Messages;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.ColorSelector;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;

public class SignGui
extends GenericGuiContainer<AbstractSignTileEntity, GenericContainer> {
    public static final ResourceLocation SIGNS_GUI = new ResourceLocation("signtastic", "textures/block/signs.png");
    private static final ResourceLocation BACKGROUND = new ResourceLocation("signtastic", "textures/gui/signgui.png");
    public static final int WIDTH = 215;
    public static final int HEIGHT = 200;
    private TextField[] labels;
    private ToggleButton backColorButton;
    private ColorSelector backColorSelector;
    private ColorSelector textColorSelector;
    private ToggleButton fullBrightButton;
    private ToggleButton transparentButton;
    private ToggleButton largeButton;
    private ChoiceLabel textureTypeLabel;
    private ImageChoiceLabel imageLabel;

    public SignGui(AbstractSignTileEntity tileEntity, GenericContainer container, Inventory inventory) {
        super((GenericTileEntity)tileEntity, (AbstractContainerMenu)container, inventory, ManualEntry.EMPTY);
        this.f_97726_ = 215;
        this.f_97727_ = 200;
    }

    public void m_7856_() {
        super.m_7856_();
        this.labels = new TextField[8];
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i] = Widgets.textfield((int)10, (int)(10 + 18 * i), (int)195, (int)16).event(s -> this.update());
        }
        SignSettings settings = ((AbstractSignTileEntity)this.tileEntity).getSettings();
        this.backColorButton = ((ToggleButton)((ToggleButton)new ToggleButton().hint(10, 160, 13, 16)).text("")).checkMarker(true).pressed(settings.getBackColor() != null).event(this::update);
        this.backColorSelector = ((ColorSelector)((ColorSelector)((ColorSelector)new ColorSelector().hint(23, 160, 45, 16)).text("Back")).currentColor(Integer.valueOf(settings.getBackColor() == null ? 0 : settings.getBackColor())).enabled(settings.getBackColor() != null)).event(s -> this.update());
        this.textColorSelector = ((ColorSelector)((ColorSelector)new ColorSelector().hint(75, 160, 36, 16)).text("Txt")).currentColor(Integer.valueOf(settings.getTextColor())).event(s -> this.update());
        this.textureTypeLabel = ((ChoiceLabel)new ChoiceLabel().hint(116, 160, 60, 16)).choices((String[])Arrays.stream(TextureType.values()).sorted().map(s -> s.name().toLowerCase()).toArray(String[]::new)).choice(settings.getTextureType().name().toLowerCase()).event(s -> this.update());
        this.fullBrightButton = ((ToggleButton)((ToggleButton)new ToggleButton().hint(10, 180, 50, 16)).text("Bright")).checkMarker(true).pressed(settings.isBright()).event(this::update);
        this.transparentButton = ((ToggleButton)((ToggleButton)new ToggleButton().hint(65, 180, 55, 16)).text("Transp")).checkMarker(true).pressed(settings.isTransparent()).event(this::update);
        this.largeButton = ((ToggleButton)((ToggleButton)new ToggleButton().hint(125, 180, 50, 16)).text("Large")).checkMarker(true).pressed(settings.isLarge()).event(this::updateLarge);
        this.imageLabel = ((ImageChoiceLabel)new ImageChoiceLabel().hint(178, 165, ((Integer)Config.ICON_SIZE.get()).intValue(), ((Integer)Config.ICON_SIZE.get()).intValue())).event(s -> this.update());
        for (int i = 0; i <= (Integer)Config.ICONS.get(); ++i) {
            int u = 32 * (i % (Integer)Config.HORIZONTAL_ICONS.get());
            int v = 32 * (i / (Integer)Config.VERTICAL_ICONS.get());
            this.imageLabel.choice("" + i, "", SIGNS_GUI, u, v);
        }
        this.imageLabel.setCurrentChoice(settings.getIconIndex());
        Panel toplevel = (Panel)((Panel)((Panel)Widgets.positional().background(BACKGROUND)).children((Widget[])this.labels)).children(new Widget[]{this.backColorButton, this.backColorSelector, this.textColorSelector, this.fullBrightButton, this.transparentButton, this.textureTypeLabel, this.largeButton, this.imageLabel});
        toplevel.bounds(this.f_97735_, this.f_97736_, 215, 200);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.updateFromTE();
    }

    private void updateFromTE() {
        int linesSupported = ((AbstractSignTileEntity)this.tileEntity).getLinesSupported();
        if (this.largeButton.isPressed()) {
            linesSupported /= 2;
        }
        List<String> lines = ((AbstractSignTileEntity)this.tileEntity).getLines();
        for (int i = 0; i < this.labels.length; ++i) {
            if (i < lines.size()) {
                this.labels[i].text(lines.get(i));
            } else {
                this.labels[i].text("");
            }
            this.labels[i].enabled(i < linesSupported);
        }
    }

    private void updateLarge() {
        this.update();
        this.updateFromTE();
    }

    private void update() {
        Messages.INSTANCE.sendToServer((Object)new PacketUpdateSignData(((AbstractSignTileEntity)this.tileEntity).m_58899_(), Arrays.stream(this.labels).map(TextField::getText).collect(Collectors.toList()), this.backColorButton.isPressed() ? this.backColorSelector.getCurrentColor() : null, this.textColorSelector.getCurrentColor(), this.fullBrightButton.isPressed(), this.transparentButton.isPressed(), this.largeButton.isPressed(), TextureType.getByName(this.textureTypeLabel.getCurrentChoice()), this.imageLabel.getCurrentChoiceIndex()));
    }

    public void m_88315_(GuiGraphics graphics, int xSize_lo, int ySize_lo, float par3) {
        super.m_88315_(graphics, xSize_lo, ySize_lo, par3);
        this.backColorSelector.enabled(this.backColorButton.isPressed());
        this.drawWindow(graphics);
    }

    public static void register() {
        SignGui.register((MenuType)((MenuType)SignsModule.CONTAINER_SIGN.get()), SignGui::new);
    }
}

