/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.signtastic.modules.signs.blocks;

import com.mcjty.signtastic.modules.signs.SignSettings;
import com.mcjty.signtastic.modules.signs.SignsModule;
import com.mcjty.signtastic.modules.signs.TextureType;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LazyOptional;

public abstract class AbstractSignTileEntity
extends GenericTileEntity {
    private SignSettings settings = new SignSettings();
    private List<String> lines = new ArrayList<String>();
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Builder").containerSupplier(DefaultContainerProvider.empty(SignsModule.CONTAINER_SIGN, (GenericTileEntity)this)));

    public AbstractSignTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void setLines(List<String> lines) {
        this.lines = new ArrayList<String>(lines);
        this.markDirtyClient();
    }

    public List<String> getLines() {
        return this.lines;
    }

    public abstract int getLinesSupported();

    public abstract float getRenderOffset();

    public AABB getRenderBoundingBox() {
        int xCoord = this.m_58899_().m_123341_();
        int yCoord = this.m_58899_().m_123342_();
        int zCoord = this.m_58899_().m_123343_();
        int size = 1;
        return new AABB((double)(xCoord - size - 1), (double)(yCoord - size - 1), (double)(zCoord - size - 1), (double)(xCoord + size + 1), (double)(yCoord + size + 1), (double)(zCoord + size + 1));
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        if (tagCompound.m_128441_("Info")) {
            CompoundTag info = tagCompound.m_128469_("Info");
            this.settings.read(info);
            ListTag linesTag = info.m_128437_("lines", 8);
            this.lines.clear();
            for (Tag tag : linesTag) {
                this.lines.add(tag.m_7916_());
            }
        }
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        this.settings.write(info);
        ListTag linesTag = new ListTag();
        for (String line : this.lines) {
            linesTag.add((Object)StringTag.m_129297_((String)line));
        }
        info.m_128365_("lines", (Tag)linesTag);
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        this.loadClientDataFromNBT(tagCompound);
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        this.saveClientDataToNBT(tagCompound);
    }

    public int getSize() {
        return 1;
    }

    public SignSettings getSettings() {
        return this.settings;
    }

    public void setIconIndex(int iconIndex) {
        this.settings.setIconIndex(iconIndex);
        this.markDirtyClient();
    }

    public void setBackColor(Integer backColor) {
        this.settings.setBackColor(backColor);
        this.markDirtyClient();
    }

    public void setTextColor(int textColor) {
        this.settings.setTextColor(textColor);
        this.markDirtyClient();
    }

    public void setBright(boolean bright) {
        this.settings.setBright(bright);
        this.markDirtyClient();
    }

    public void setLarge(boolean large) {
        this.settings.setLarge(large);
        this.markDirtyClient();
    }

    public void setTransparent(boolean transparent) {
        this.settings.setTransparent(transparent);
        this.markDirtyClient();
    }

    public void setTextureType(TextureType type) {
        this.settings.setTextureType(type);
        this.markDirtyClient();
    }
}

