/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.entity;

import com.jesz.createdieselgenerators.blocks.BasinLidBlock;
import com.jesz.createdieselgenerators.recipes.RecipeRegistry;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BasinLidBlockEntity
extends BasinOperatingBlockEntity {
    public int processingTime;
    public boolean running;
    private static final Object BasinFermentingRecipesKey = new Object();

    public BasinLidBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("MeltingTime", this.processingTime);
        compound.m_128379_("Running", this.running);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.processingTime = compound.m_128451_("MeltingTime");
        this.running = compound.m_128471_("Running");
    }

    protected void onBasinRemoved() {
        if (!this.running) {
            return;
        }
        this.processingTime = 0;
        this.currentRecipe = null;
        this.running = false;
    }

    public void tick() {
        super.tick();
        if (!(this.f_58857_.f_46443_ || this.currentRecipe != null && this.processingTime != -1)) {
            this.running = false;
            this.processingTime = -1;
            this.basinChecker.scheduleUpdate();
        }
        if (this.running && this.f_58857_ != null) {
            if (!this.f_58857_.f_46443_ && this.processingTime <= 0) {
                this.processingTime = -1;
                this.applyBasinRecipe();
                this.sendData();
            }
            if (!this.f_58857_.f_46443_ && this.processingTime % 20 == 0) {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11776_, SoundSource.BLOCKS, 0.75f, this.speed < 65.0f ? 0.75f : 1.5f);
            }
            if (this.processingTime > 0) {
                --this.processingTime;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        boolean slow;
        super.tickAudio();
        boolean bl = slow = Math.abs(this.getSpeed()) < 65.0f;
        if (slow && AnimationTickHolder.getTicks() % 2 == 0) {
            return;
        }
        if (this.processingTime == 20) {
            AllSoundEvents.MIXING.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.75f, 1.0f, true);
        }
    }

    protected boolean updateBasin() {
        if (this.running) {
            return true;
        }
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return true;
        }
        if (this.getBasin().filter(BasinBlockEntity::canContinueProcessing).isEmpty()) {
            return true;
        }
        List recipes = this.getMatchingRecipes();
        if (recipes.isEmpty()) {
            return true;
        }
        this.currentRecipe = (Recipe)recipes.get(0);
        this.startProcessingBasin();
        this.sendData();
        return true;
    }

    public void startProcessingBasin() {
        int n;
        if (this.running && this.processingTime > 0) {
            return;
        }
        super.startProcessingBasin();
        this.running = true;
        Recipe recipe = this.currentRecipe;
        if (recipe instanceof ProcessingRecipe) {
            ProcessingRecipe processed = (ProcessingRecipe)recipe;
            n = processed.getProcessingDuration();
        } else {
            n = 20;
        }
        this.processingTime = n;
    }

    protected boolean isRunning() {
        return this.running;
    }

    protected Optional<BasinBlockEntity> getBasin() {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        BlockEntity basinBE = this.f_58857_.m_7702_(this.f_58858_.m_6625_(1));
        if (!(basinBE instanceof BasinBlockEntity)) {
            return Optional.empty();
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)BasinLidBlock.OPEN)).booleanValue()) {
            return Optional.empty();
        }
        return Optional.of((BasinBlockEntity)basinBE);
    }

    protected <C extends Container> boolean matchStaticFilters(Recipe<C> recipe) {
        return recipe.m_6671_() == RecipeRegistry.BASIN_FERMENTING.getType();
    }

    protected Object getRecipeCacheKey() {
        return BasinFermentingRecipesKey;
    }
}

