/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen;

import com.google.common.collect.ImmutableList;
import it.zerono.mods.extremereactors.CommonLocations;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.compat.patchouli.PatchouliCompat;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.AbstractGeneratorMultiblockController;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.AbstractMultiblockScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonIcons;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.FuelRodsLayout;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.OperationalMode;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.ClientFuelRodsLayout;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.FuelGaugeBar;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorControllerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.ButtonState;
import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractButtonControl;
import it.zerono.mods.zerocore.lib.client.gui.control.Button;
import it.zerono.mods.zerocore.lib.client.gui.control.GaugeBar;
import it.zerono.mods.zerocore.lib.client.gui.control.Label;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.Picture;
import it.zerono.mods.zerocore.lib.client.gui.control.Static;
import it.zerono.mods.zerocore.lib.client.gui.control.SwitchButton;
import it.zerono.mods.zerocore.lib.client.gui.control.SwitchPictureButton;
import it.zerono.mods.zerocore.lib.client.gui.databind.BindingGroup;
import it.zerono.mods.zerocore.lib.client.gui.databind.IBinding;
import it.zerono.mods.zerocore.lib.client.gui.databind.MonoConsumerBinding;
import it.zerono.mods.zerocore.lib.client.gui.databind.MultiConsumerBinding;
import it.zerono.mods.zerocore.lib.client.gui.layout.FixedLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.Sprite;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.client.text.BindableTextComponent;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.NonNullSupplier;

@OnlyIn(value=Dist.CLIENT)
public class ReactorControllerScreen
extends AbstractMultiblockScreen<MultiblockReactor, ReactorControllerEntity, ModTileContainer<ReactorControllerEntity>> {
    private static final int VBARPANEL_WIDTH = 18;
    private static final int VBARPANEL_HEIGHT = 84;
    private static final int INFOPANEL_WIDTH = 88;
    private static final Component TEXT_AUTOMATIC_WASTE_EJECT = Component.m_237115_((String)"gui.bigreactors.reactor.controller.wasteeject.mode.automatic").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE);
    private static final Component TEXT_MANUAL_WASTE_EJECT = Component.m_237115_((String)"gui.bigreactors.reactor.controller.wasteeject.mode.manual").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE);
    private static final Component TEXT_EMPTY = Component.m_237115_((String)"gui.bigreactors.generic.empty").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE);
    private final MultiblockReactor _reactor = (MultiblockReactor)this.getMultiblockController().orElseThrow(IllegalStateException::new);
    private final OperationalMode _reactorMode = this._reactor.getOperationalMode();
    private final EnergySystem _outputEnergySystem = this._reactor.getOutputEnergySystem();
    private final double _reactorCapacity = this._reactor.getCapacity(this._outputEnergySystem).doubleValue();
    private final BindingGroup _bindings = new BindingGroup();
    private final FuelGaugeBar _fuelBar = new FuelGaugeBar((ModContainerScreen<? extends ModContainer>)this, "fuelBar", this._reactor);
    private final GaugeBar _coreHeatBar = this.heatBar("coreHeatBar", 2000.0);
    private final GaugeBar _casingHeatBar = this.heatBar("casingHeatBar", 2000.0);
    private final GaugeBar _energyBar;
    private final GaugeBar _coolantBar;
    private final GaugeBar _vaporBar;
    private final Label _lblTemperature = this.infoLabel("temperatureValue", "0 C");
    private final Label _lblFuelUsage = this.infoLabel("fuelUsageValue", "0 mB/t");
    private final Label _lblFuelRichness = this.infoLabel("fuelRichnessValue", "0%");
    private final Label _lblEnergyRatio;
    private final Label _lblVaporRatio;

    public ReactorControllerScreen(ModTileContainer<ReactorControllerEntity> container, Inventory inventory, Component title) {
        super(container, inventory, PlayerInventoryUsage.None, title, ReactorControllerScreen.mainTextureFromVariant((IMultiblockVariant)((ReactorControllerEntity)container.getTileEntity()).getMultiblockVariant().orElse(ReactorVariant.Basic)));
        if (this._reactorMode.isPassive()) {
            this._lblEnergyRatio = this.infoLabel("energyRatioValue", "");
            this._energyBar = new GaugeBar((ModContainerScreen)this, "energyBar", this._reactorCapacity, CommonIcons.PowerBar.get());
            this._vaporBar = null;
            this._coolantBar = null;
            this._lblVaporRatio = null;
        } else {
            this._lblEnergyRatio = null;
            this._energyBar = null;
            this._coolantBar = this.liquidBar("coolantBar", this._reactor.getFluidContainer().getCapacity());
            this._vaporBar = this.liquidBar("vaporBar", this._reactor.getFluidContainer().getCapacity());
            this._lblVaporRatio = this.infoLabel("vaporRatioValue", "");
        }
    }

    public boolean m_6913_() {
        return true;
    }

    @Override
    protected void onScreenCreate() {
        Picture c;
        Panel outerPanel = new Panel((ModContainerScreen)this);
        Panel barsPanel = new Panel((ModContainerScreen)this);
        Panel infoPanel = new Panel((ModContainerScreen)this);
        Panel infoPanelLeft = this.hInfoPanel();
        Panel infoPanelRight = this.hInfoPanel();
        this.addPatchouliHelpButton(PatchouliCompat.HANDBOOK_ID, CommonLocations.REACTOR.buildWithSuffix("part-controller"), 1);
        super.onScreenCreate();
        this.setContentLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setVerticalMargin(1)).setHorizontalMargin(13)).setControlsSpacing(0));
        outerPanel.setDesiredDimension(this.getGuiWidth() - 26, 141);
        outerPanel.setLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setZeroMargins()).setControlsSpacing(2)).setVerticalAlignment(VerticalAlignment.Top)).setHorizontalAlignment(HorizontalAlignment.Left));
        this.addControl((IControl)outerPanel);
        barsPanel.setDesiredDimension(DesiredDimension.Height, 84);
        barsPanel.setLayoutEngine((ILayoutEngine)((HorizontalLayoutEngine)((HorizontalLayoutEngine)new HorizontalLayoutEngine().setZeroMargins()).setVerticalAlignment(VerticalAlignment.Top)).setHorizontalAlignment(HorizontalAlignment.Left));
        outerPanel.addControl((IControl)barsPanel);
        Panel p = new Panel((ModContainerScreen)this);
        p.setDesiredDimension(this.getGuiWidth() - 29, 1);
        p.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine());
        Static s = new Static((ModContainerScreen)this, 0, 0).setColor(Colour.BLACK);
        s.setLayoutEngineHint(FixedLayoutEngine.hint((int)0, (int)0, (int)(this.getGuiWidth() - 29), (int)1));
        p.addControl((IControl)s);
        outerPanel.addControl((IControl)p);
        infoPanel.setLayoutEngine((ILayoutEngine)((HorizontalLayoutEngine)((HorizontalLayoutEngine)new HorizontalLayoutEngine().setZeroMargins()).setVerticalAlignment(VerticalAlignment.Top)).setHorizontalAlignment(HorizontalAlignment.Left));
        infoPanel.addControl(new IControl[]{infoPanelLeft, infoPanelRight});
        outerPanel.addControl((IControl)infoPanel);
        p = this.vBarPanel();
        this.addBarIcon(CommonIcons.FuelIcon, p).useTooltipsFrom((IControl)this._fuelBar);
        this._fuelBar.setDesiredDimension(18, 66);
        this._fuelBar.setBackground(CommonIcons.BarBackground.get());
        this._fuelBar.setPadding(1);
        this.addBinding((Function<MultiblockReactor, Value>)((Function<MultiblockReactor, Integer>)MultiblockReactor::getFuelAmount), (Consumer<Value>)((Consumer<Integer>)value -> this._fuelBar.setValue(ReactantType.Fuel, value.intValue())));
        this.addBinding((Function<MultiblockReactor, Value>)((Function<MultiblockReactor, Integer>)MultiblockReactor::getWasteAmount), (Consumer<Value>)((Consumer<Integer>)value -> this._fuelBar.setValue(ReactantType.Waste, value.intValue())));
        this.addBinding((Function<MultiblockReactor, Value>)((Function<MultiblockReactor, Colour>)reactor -> this.getReactantColour((MultiblockReactor)reactor, ClientFuelRodsLayout::getFuelColor, ReactantType.Fuel.getDefaultColour())), (Consumer<Value>)((Consumer<Colour>)value -> this._fuelBar.setBarSpriteTint(ReactantType.Fuel, (Colour)value)));
        this.addBinding((Function<MultiblockReactor, Value>)((Function<MultiblockReactor, Colour>)reactor -> this.getReactantColour((MultiblockReactor)reactor, ClientFuelRodsLayout::getWasteColor, ReactantType.Waste.getDefaultColour())), (Consumer<Value>)((Consumer<Colour>)value -> this._fuelBar.setBarSpriteTint(ReactantType.Waste, (Colour)value)));
        p.addControl((IControl)this._fuelBar);
        barsPanel.addControl((IControl)p);
        barsPanel.addControl((IControl)this.vSeparatorPanel());
        BindableTextComponent coreHeatText = new BindableTextComponent(heat -> Component.m_237113_((String)String.format("%.0f C", heat)).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
        p = this.vBarPanel();
        this.addBarIcon(CommonIcons.ButtonSensorOutputFuelTemperature, p).useTooltipsFrom((IControl)this._coreHeatBar);
        this._coreHeatBar.setTooltips((List)ImmutableList.of((Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.coreheatbar.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.coreheatbar.line2"), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.coreheatbar.line3"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.coreheatbar.line4"), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.coreheatbar.line5"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.coreheatbar.line6"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.coreheatbar.line7"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.coreheatbar.line8")), (List)ImmutableList.of((Object)coreHeatText));
        this.addBinding((MultiblockReactor reactor) -> reactor.getFuelHeat().getAsDouble(), new Consumer[]{value -> {
            this._coreHeatBar.setValue(value.doubleValue());
            this._lblTemperature.setText("%d C", new Object[]{value.intValue()});
        }, coreHeatText});
        p.addControl((IControl)this._coreHeatBar);
        barsPanel.addControl((IControl)p);
        barsPanel.addControl((IControl)this.vTempScalePanel());
        BindableTextComponent reactorHeatText = new BindableTextComponent(heat -> Component.m_237113_((String)String.format("%.0f C", heat)).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
        p = this.vBarPanel();
        this.addBarIcon(CommonIcons.ButtonSensorOutputCasingTemperature, p).useTooltipsFrom((IControl)this._casingHeatBar);
        this._casingHeatBar.setTooltips((List)ImmutableList.of((Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.casingheatbar.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.casingheatbar.line2"), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.casingheatbar.line3"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.casingheatbar.line4"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.casingheatbar.line5")), (List)ImmutableList.of((Object)reactorHeatText));
        Consumer[] consumerArray = new Consumer[2];
        consumerArray[0] = arg_0 -> ((GaugeBar)this._casingHeatBar).setValue(arg_0);
        consumerArray[1] = reactorHeatText;
        this.addBinding((MultiblockReactor reactor) -> reactor.getReactorHeat().getAsDouble(), consumerArray);
        p.addControl((IControl)this._casingHeatBar);
        barsPanel.addControl((IControl)p);
        barsPanel.addControl((IControl)this.vSeparatorPanel());
        if (this._reactorMode.isPassive()) {
            p = new Panel((ModContainerScreen)this);
            p.setDesiredDimension(47, 84);
            p.setLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setHorizontalAlignment(HorizontalAlignment.Left)).setZeroMargins()).setControlsSpacing(2));
            this.addBarIcon(CommonIcons.PowerBattery, 16, 16, p).useTooltipsFrom((IControl)this._energyBar);
            BindableTextComponent energyStoredText = new BindableTextComponent(stored -> Component.m_237113_((String)CodeHelper.formatAsHumanReadableNumber((double)stored, (String)this._outputEnergySystem.getUnit())).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
            BindableTextComponent energyStoredPercentageText = new BindableTextComponent(percentage -> Component.m_237113_((String)String.format("%d", (int)(percentage * 100.0))).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
            this._energyBar.setDesiredDimension(18, 66);
            this._energyBar.setBackground(CommonIcons.BarBackground.get());
            this._energyBar.setPadding(1);
            this._energyBar.setTooltips((List)ImmutableList.of((Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.energybar.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.energybar.line2a").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE).m_7220_((Component)Component.m_237110_((String)"gui.bigreactors.reactor.controller.energybar.line2b", (Object[])new Object[]{CodeHelper.formatAsHumanReadableNumber((double)this._reactorCapacity, (String)this._outputEnergySystem.getUnit())})), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.energybar.line3a").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE).m_7220_((Component)Component.m_237115_((String)"gui.bigreactors.reactor.controller.energybar.line3b")), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.energybar.line4"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.energybar.line5"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.energybar.line6"), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.energybar.line7"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.energybar.line8")), (List)ImmutableList.of((Object)energyStoredText, (Object)energyStoredPercentageText));
            Consumer[] consumerArray2 = new Consumer[2];
            consumerArray2[0] = arg_0 -> ((GaugeBar)this._energyBar).setValue(arg_0);
            consumerArray2[1] = energyStoredText;
            this.addBinding((MultiblockReactor reactor) -> reactor.getEnergyStored(EnergySystem.REFERENCE).doubleValue(), consumerArray2);
            this.addBinding((Function<MultiblockReactor, Value>)((Function<MultiblockReactor, Double>)AbstractGeneratorMultiblockController::getEnergyStoredPercentage), (Consumer<Value>)((Consumer)energyStoredPercentageText));
            p.addControl((IControl)this._energyBar);
            barsPanel.addControl((IControl)p);
            BindableTextComponent energyGeneratedText = new BindableTextComponent(generated -> Component.m_237113_((String)String.format("%.2f %s", generated, this._outputEnergySystem.getUnit())).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
            p = this.hInfoPanelSlot();
            c = new Picture((ModContainerScreen)this, "energyRatio", CommonIcons.EnergyRatioIcon.get(), 16, 16);
            c.useTooltipsFrom((IControl)this._lblEnergyRatio);
            p.addControl((IControl)c);
            this._lblEnergyRatio.setTooltips((List)ImmutableList.of((Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.energyratio.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.energyratio.line2a").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE).m_7220_((Component)Component.m_237115_((String)"gui.bigreactors.reactor.controller.energyratio.line2b")), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.energyratio.line3"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.energyratio.line4"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.energyratio.line5"), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.energyratio.line6"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.energyratio.line7"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.energyratio.line8")), (List)ImmutableList.of((Object)energyGeneratedText));
            this.addBinding((MultiblockReactor reactor) -> reactor.getUiStats().getAmountGeneratedLastTick(), new Consumer[]{value -> this._lblEnergyRatio.setText(CodeHelper.formatAsHumanReadableNumber((double)value, (String)(this._outputEnergySystem.getUnit() + "/t"))), energyGeneratedText});
            p.addControl((IControl)this._lblEnergyRatio);
            infoPanelRight.addControl((IControl)p);
        } else {
            BindableTextComponent tankCapacity = new BindableTextComponent(capacity -> Component.m_237113_((String)CodeHelper.formatAsHumanReadableNumber((long)(capacity / 1000), (String)"B")).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
            this.addBinding((MultiblockReactor reactor) -> this._reactor.getFluidContainer().getCapacity(), new Consumer[]{v -> {
                this._coolantBar.setMaxValue((double)v.intValue());
                this._vaporBar.setMaxValue((double)v.intValue());
            }, tankCapacity});
            BindableTextComponent coolantFluidName = new BindableTextComponent(name -> name);
            BindableTextComponent coolantAmount = new BindableTextComponent(amount -> Component.m_237113_((String)CodeHelper.formatAsHumanReadableNumber((long)(amount / 1000), (String)"B")).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
            BindableTextComponent coolantStoredPercentage = new BindableTextComponent(percentage -> Component.m_237113_((String)String.format("%d", (int)(percentage * 100.0))).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
            p = this.vBarPanel();
            this.addBarIcon(CommonIcons.CoolantIcon, p).useTooltipsFrom((IControl)this._coolantBar);
            this._coolantBar.setTooltips((List)ImmutableList.of((Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.coolantbar.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.coreheatbar.line2").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.coolantbar.line3a").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE).m_7220_((Component)Component.m_237115_((String)"gui.bigreactors.reactor.controller.coolantbar.line3b")), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.coolantbar.line4a").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE).m_7220_((Component)Component.m_237115_((String)"gui.bigreactors.reactor.controller.coolantbar.line4b")), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.coolantbar.line5"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.coolantbar.line6")), (List)ImmutableList.of((Object)coolantFluidName, (Object)coolantAmount, (Object)tankCapacity, (Object)coolantStoredPercentage));
            this.addBinding((MultiblockReactor reactor) -> ReactorControllerScreen.getFluidName(reactor.getFluidContainer().getLiquid()), new Consumer[]{v -> {
                this._coolantBar.setBarSprite(Sprite.EMPTY);
                this._coolantBar.setBarSpriteTint(Colour.WHITE);
                this._reactor.getFluidContainer().getLiquid().ifPresent(fluid -> {
                    this._coolantBar.setBarSprite(ModRenderHelper.getFlowingFluidSprite((Fluid)fluid));
                    this._coolantBar.setBarSpriteTint(ModRenderHelper.getFluidTintColour((Fluid)fluid));
                });
            }, coolantFluidName});
            Consumer[] consumerArray3 = new Consumer[2];
            consumerArray3[0] = arg_0 -> ((GaugeBar)this._coolantBar).setValue(arg_0);
            consumerArray3[1] = coolantAmount;
            this.addBinding((MultiblockReactor reactor) -> reactor.getFluidContainer().getLiquidAmount(), consumerArray3);
            this.addBinding((MultiblockReactor reactor) -> reactor.getFluidContainer().getLiquidStoredPercentage(), new Consumer[]{v -> {}, coolantStoredPercentage});
            p.addControl((IControl)this._coolantBar);
            barsPanel.addControl((IControl)p);
            barsPanel.addControl((IControl)this.vTempScalePanel());
            BindableTextComponent vaporFluidName = new BindableTextComponent(name -> name);
            BindableTextComponent vaporAmount = new BindableTextComponent(amount -> Component.m_237113_((String)CodeHelper.formatAsHumanReadableNumber((long)(amount / 1000), (String)"B")).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
            BindableTextComponent vaporStoredPercentage = new BindableTextComponent(percentage -> Component.m_237113_((String)String.format("%d", (int)(percentage * 100.0))).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
            p = this.vBarPanel();
            this.addBarIcon(CommonIcons.VaporIcon, p).useTooltipsFrom((IControl)this._vaporBar);
            this._vaporBar.setTooltips((List)ImmutableList.of((Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.vaporbar.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.vaporbar.line2").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.vaporbar.line3a").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE).m_7220_((Component)Component.m_237115_((String)"gui.bigreactors.reactor.controller.vaporbar.line3b")), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.vaporbar.line4a").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE).m_7220_((Component)Component.m_237115_((String)"gui.bigreactors.reactor.controller.vaporbar.line4b")), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.vaporbar.line5"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.vaporbar.line6"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.vaporbar.line7")), (List)ImmutableList.of((Object)vaporFluidName, (Object)vaporAmount, (Object)tankCapacity, (Object)vaporStoredPercentage));
            this.addBinding((MultiblockReactor reactor) -> ReactorControllerScreen.getFluidName(reactor.getFluidContainer().getGas()), new Consumer[]{v -> {
                this._vaporBar.setBarSprite(Sprite.EMPTY);
                this._vaporBar.setBarSpriteTint(Colour.WHITE);
                this._reactor.getFluidContainer().getGas().ifPresent(fluid -> {
                    this._vaporBar.setBarSprite(ModRenderHelper.getFlowingFluidSprite((Fluid)fluid));
                    this._vaporBar.setBarSpriteTint(ModRenderHelper.getFluidTintColour((Fluid)fluid));
                });
            }, vaporFluidName});
            Consumer[] consumerArray4 = new Consumer[2];
            consumerArray4[0] = arg_0 -> ((GaugeBar)this._vaporBar).setValue(arg_0);
            consumerArray4[1] = vaporAmount;
            this.addBinding((MultiblockReactor reactor) -> reactor.getFluidContainer().getGasAmount(), consumerArray4);
            this.addBinding((MultiblockReactor reactor) -> reactor.getFluidContainer().getGasStoredPercentage(), new Consumer[]{v -> {}, vaporStoredPercentage});
            p.addControl((IControl)this._vaporBar);
            barsPanel.addControl((IControl)p);
            BindableTextComponent vaporGeneratedText = new BindableTextComponent(generated -> Component.m_237113_((String)String.format("%.2f %s", generated / 1000.0, "B")).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
            p = this.hInfoPanelSlot();
            c = new Picture((ModContainerScreen)this, "vaporRatio", CommonIcons.VaporIcon.get(), 16, 16);
            c.useTooltipsFrom((IControl)this._lblVaporRatio);
            p.addControl((IControl)c);
            this._lblVaporRatio.setTooltips((List)ImmutableList.of((Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.vaporratio.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.vaporratio.line2a").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE).m_7220_((Component)Component.m_237115_((String)"gui.bigreactors.reactor.controller.vaporratio.line2b")), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.vaporratio.line3"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.vaporratio.line4"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.vaporratio.line5")), (List)ImmutableList.of((Object)vaporGeneratedText));
            this.addBinding((MultiblockReactor reactor) -> reactor.getUiStats().getAmountGeneratedLastTick(), new Consumer[]{generated -> this._lblVaporRatio.setText(CodeHelper.formatAsHumanReadableNumber((double)(generated / 1000.0), (String)"B/t")), vaporGeneratedText});
            p.addControl((IControl)this._lblVaporRatio);
            infoPanelRight.addControl((IControl)p);
        }
        barsPanel.addControl((IControl)this.vSeparatorPanel());
        p = this.hInfoPanelSlot();
        c = new Picture((ModContainerScreen)this, "temperature", CommonIcons.TemperatureIcon.get(), 16, 16);
        c.useTooltipsFrom((IControl)this._lblTemperature);
        p.addControl((IControl)c);
        this._lblTemperature.setTooltips(this._coreHeatBar.getTooltips(), this._coreHeatBar.getTooltipsObjects());
        p.addControl((IControl)this._lblTemperature);
        infoPanelLeft.addControl((IControl)p);
        p = this.hInfoPanelSlot();
        c = new Picture((ModContainerScreen)this, "fuelusage", CommonIcons.FuelMix.get(), 16, 16);
        c.useTooltipsFrom((IControl)this._lblFuelUsage);
        p.addControl((IControl)c);
        this._lblFuelUsage.setTooltips(new Component[]{Component.m_237115_((String)"gui.bigreactors.reactor.controller.fuelusage.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), CodeHelper.TEXT_EMPTY_LINE, Component.m_237115_((String)"gui.bigreactors.reactor.controller.fuelusage.line2"), Component.m_237115_((String)"gui.bigreactors.reactor.controller.fuelusage.line3")});
        this.addBinding((Function<MultiblockReactor, Value>)((Function<MultiblockReactor, Float>)reactor -> Float.valueOf(reactor.getUiStats().getFuelConsumedLastTick())), (Consumer<Value>)((Consumer<Float>)value -> this._lblFuelUsage.setText(CodeHelper.formatAsMillibuckets((float)value.floatValue()) + "/t")));
        p.addControl((IControl)this._lblFuelUsage);
        infoPanelLeft.addControl((IControl)p);
        p = this.hInfoPanelSlot();
        c = new Picture((ModContainerScreen)this, "fuelReactivity", CommonIcons.ReactivityIcon.get(), 16, 16);
        c.useTooltipsFrom((IControl)this._lblFuelRichness);
        p.addControl((IControl)c);
        this._lblFuelRichness.setTooltips(new Component[]{Component.m_237115_((String)"gui.bigreactors.reactor.controller.fuelrichness.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), CodeHelper.TEXT_EMPTY_LINE, Component.m_237115_((String)"gui.bigreactors.reactor.controller.fuelrichness.line2"), Component.m_237115_((String)"gui.bigreactors.reactor.controller.fuelrichness.line3"), Component.m_237115_((String)"gui.bigreactors.reactor.controller.fuelrichness.line4")});
        this.addBinding((Function<MultiblockReactor, Value>)((Function<MultiblockReactor, Float>)reactor -> Float.valueOf(reactor.getUiStats().getFuelRichness())), (Consumer<Value>)((Consumer<Float>)value -> this._lblFuelRichness.setText("%2.0f%%", new Object[]{Float.valueOf(value.floatValue() * 100.0f)})));
        p.addControl((IControl)this._lblFuelRichness);
        infoPanelLeft.addControl((IControl)p);
        Panel commandPanel = this.vCommandPanel();
        barsPanel.addControl((IControl)commandPanel);
        int x = 0;
        int y = 0;
        int w = 25;
        SwitchButton on = new SwitchButton((ModContainerScreen)this, "on", "ON", false, "onoff");
        SwitchButton off = new SwitchButton((ModContainerScreen)this, "off", "OFF", true, "onoff");
        on.setLayoutEngineHint(FixedLayoutEngine.hint((int)x, (int)y, (int)w, (int)16));
        on.setTooltips(new Component[]{Component.m_237115_((String)"gui.bigreactors.reactor.controller.on.line1")});
        on.Activated.subscribe(this::onActiveStateChanged);
        on.Deactivated.subscribe(this::onActiveStateChanged);
        this.addBinding((Function<MultiblockReactor, Value>)((Function<MultiblockReactor, Boolean>)MultiblockReactor::isMachineActive), (Consumer<Value>)((Consumer<Boolean>)arg_0 -> ((SwitchButton)on).setActive(arg_0)));
        off.setLayoutEngineHint(FixedLayoutEngine.hint((int)(x + w), (int)y, (int)w, (int)16));
        off.setTooltips(new Component[]{Component.m_237115_((String)"gui.bigreactors.reactor.controller.off.line1")});
        this.addBinding((Function<MultiblockReactor, Value>)((Function<MultiblockReactor, Boolean>)MultiblockReactor::isMachineActive), (Consumer<Value>)((Consumer<Boolean>)active -> off.setActive(active == false)));
        commandPanel.addControl(new IControl[]{on, off});
        Button btn = new Button((ModContainerScreen)this, "voidreactants", "");
        btn.Clicked.subscribe(this::onVoidReactants);
        btn.setIconForState(CommonIcons.TrashCan.get(), ButtonState.Default);
        btn.setLayoutEngineHint(FixedLayoutEngine.hint((int)(x + 17), (int)(y += 18), (int)18, (int)18));
        btn.enablePaintBlending(true);
        btn.setPadding(1);
        btn.setTooltips((List)ImmutableList.of((Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.voidreactants.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.voidreactants.line2")));
        commandPanel.addControl((IControl)btn);
        y += 21;
        BindableTextComponent wasteEjectionText = new BindableTextComponent(automatic -> automatic != false ? TEXT_AUTOMATIC_WASTE_EJECT : TEXT_MANUAL_WASTE_EJECT);
        SwitchPictureButton swp = new SwitchPictureButton((ModContainerScreen)this, "wasteeject", false);
        swp.Activated.subscribe(this::onWasteEjectionChanged);
        swp.Deactivated.subscribe(this::onWasteEjectionChanged);
        this.setButtonSpritesAndOverlayForState((AbstractButtonControl)swp, ButtonState.Default, CommonIcons.ButtonDumpWaste);
        this.setButtonSpritesAndOverlayForState((AbstractButtonControl)swp, ButtonState.Active, CommonIcons.ButtonDumpWasteActive);
        swp.setLayoutEngineHint(FixedLayoutEngine.hint((int)(x + 17), (int)y, (int)18, (int)18));
        swp.setBackground(CommonIcons.ImageButtonBackground.get());
        swp.enablePaintBlending(true);
        swp.setPadding(1);
        swp.setTooltips((List)ImmutableList.of((Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.wasteeject.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.wasteeject.line2"), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.wasteeject.line3"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.wasteeject.line4"), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.wasteeject.line5"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.wasteeject.line6"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.wasteeject.line7")), (List)ImmutableList.of((Object)wasteEjectionText));
        Consumer[] consumerArray5 = new Consumer[2];
        consumerArray5[0] = arg_0 -> ((SwitchPictureButton)swp).setActive(arg_0);
        consumerArray5[1] = wasteEjectionText;
        this.addBinding((MultiblockReactor r) -> r.getWasteEjectionMode().isAutomatic(), consumerArray5);
        commandPanel.addControl((IControl)swp);
        Button scram = new Button((ModContainerScreen)this, "scram", "SCRAM");
        scram.setLayoutEngineHint(FixedLayoutEngine.hint((int)x, (int)(y += 21), (int)50, (int)25));
        scram.setTooltips(new Component[]{Component.m_237115_((String)"gui.bigreactors.reactor.controller.scram.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), CodeHelper.TEXT_EMPTY_LINE, Component.m_237115_((String)"gui.bigreactors.reactor.controller.scram.line2"), Component.m_237115_((String)"gui.bigreactors.reactor.controller.scram.line3"), Component.m_237115_((String)"gui.bigreactors.reactor.controller.scram.line4").m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true)))});
        scram.Clicked.subscribe(this::onScram);
        commandPanel.addControl((IControl)scram);
    }

    @Override
    protected void onDataUpdated() {
        super.onDataUpdated();
        this._bindings.update();
    }

    private Panel vCommandPanel() {
        Panel p = new Panel((ModContainerScreen)this);
        p.setDesiredDimension(DesiredDimension.Height, 84);
        p.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine());
        return p;
    }

    private Panel vBarPanel() {
        Panel p = new Panel((ModContainerScreen)this);
        p.setDesiredDimension(18, 84);
        p.setLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setZeroMargins()).setControlsSpacing(2));
        return p;
    }

    private Panel vSeparatorPanel() {
        Panel p = new Panel((ModContainerScreen)this);
        Static s = new Static((ModContainerScreen)this, 1, 84);
        p.setDesiredDimension(11, 84);
        p.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine());
        s.setColor(Colour.BLACK);
        s.setLayoutEngineHint(FixedLayoutEngine.hint((int)5, (int)0, (int)1, (int)84));
        p.addControl((IControl)s);
        return p;
    }

    private Panel vTempScalePanel() {
        Panel p = new Panel((ModContainerScreen)this);
        Picture pic = new Picture((ModContainerScreen)this, this.nextGenericName(), CommonIcons.TemperatureScale.get(), 5, 59);
        p.setDesiredDimension(11, 84);
        p.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine());
        pic.setLayoutEngineHint(FixedLayoutEngine.hint((int)3, (int)23, (int)5, (int)59));
        p.addControl((IControl)pic);
        return p;
    }

    private Panel hInfoPanel() {
        Panel p = new Panel((ModContainerScreen)this);
        p.setDesiredDimension(DesiredDimension.Width, 88);
        p.setLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setZeroMargins()).setControlsSpacing(1));
        return p;
    }

    private Panel hInfoPanelSlot() {
        Panel p = new Panel((ModContainerScreen)this);
        p.setDesiredDimension(88, 16);
        p.setLayoutEngine((ILayoutEngine)((HorizontalLayoutEngine)new HorizontalLayoutEngine().setZeroMargins()).setControlsSpacing(3));
        return p;
    }

    private Label infoLabel(String name, String value) {
        Label l = new Label((ModContainerScreen)this, name, value);
        l.setAutoSize(false);
        l.setDesiredDimension(68, 10);
        return l;
    }

    private GaugeBar heatBar(String name, double maxValue) {
        GaugeBar bar = new GaugeBar((ModContainerScreen)this, name, maxValue, CommonIcons.TemperatureBar.get());
        bar.setDesiredDimension(18, 66);
        bar.setBackground(CommonIcons.BarBackground.get());
        bar.setPadding(1);
        return bar;
    }

    private GaugeBar liquidBar(String name, double maxValue) {
        GaugeBar bar = new GaugeBar((ModContainerScreen)this, name, maxValue, CommonIcons.BarBackground.get());
        bar.setDesiredDimension(18, 66);
        bar.setBackground(CommonIcons.BarBackground.get());
        bar.setPadding(1);
        return bar;
    }

    private IControl addBarIcon(NonNullSupplier<ISprite> icon, Panel parent) {
        return this.addBarIcon(icon, 16, 16, parent);
    }

    private IControl addBarIcon(NonNullSupplier<ISprite> icon, int width, int height, Panel parent) {
        Picture c = new Picture((ModContainerScreen)this, this.nextGenericName(), (ISprite)icon.get(), width, height);
        c.setDesiredDimension(width, height);
        parent.addControl((IControl)c);
        return c;
    }

    private static Component getFluidName(Optional<Fluid> fluid) {
        return fluid.map(FluidHelper::getFluidName).map(c -> c.m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE)).orElse(TEXT_EMPTY);
    }

    private void onActiveStateChanged(SwitchButton button) {
        this.sendCommandToServer(button.getActive() ? CommonConstants.COMMAND_ACTIVATE : CommonConstants.COMMAND_DEACTIVATE);
    }

    private void onWasteEjectionChanged(SwitchPictureButton button) {
        this.sendCommandToServer(button.getActive() ? ReactorControllerEntity.COMMAND_WASTE_AUTOMATIC : ReactorControllerEntity.COMMAND_WASTE_MANUAL);
    }

    private void onScram(Button button, Integer mouseButton) {
        this.sendCommandToServer(ReactorControllerEntity.COMMAND_SCRAM);
    }

    private void onVoidReactants(Button button, Integer mouseButton) {
        this.sendCommandToServer(ReactorControllerEntity.COMMAND_VOID_REACTANTS);
    }

    private final <Value> void addBinding(Function<MultiblockReactor, Value> supplier, Consumer<Value> consumer) {
        this._bindings.addBinding((IBinding)new MonoConsumerBinding((Object)this._reactor, supplier, consumer));
    }

    @SafeVarargs
    private final <Value> void addBinding(Function<MultiblockReactor, Value> supplier, Consumer<Value> ... consumers) {
        this._bindings.addBinding((IBinding)new MultiConsumerBinding((Object)this._reactor, supplier, (Consumer[])consumers));
    }

    private Colour getReactantColour(MultiblockReactor reactor, Function<ClientFuelRodsLayout, Colour> colourGetter, int defaultColour) {
        FuelRodsLayout layout = reactor.getFuelRodsLayout();
        return layout instanceof ClientFuelRodsLayout ? colourGetter.apply((ClientFuelRodsLayout)layout) : Colour.fromRGB((int)defaultColour);
    }
}

