/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.unimi.dsi.fastutil.shorts.Short2ObjectArrayMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CachedSprites;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model.ReactorFuelRodModelData;
import it.zerono.mods.zerocore.lib.block.BlockFacings;
import it.zerono.mods.zerocore.lib.client.model.AbstractDynamicBakedModel;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Vector3f;

public class ReactorFuelRodModel
extends AbstractDynamicBakedModel {
    public static int HORIZONTAL_MAX_STEPS = 10;
    public static int VERTICAL_MAX_STEPS = 12;
    private static final List<BakedQuad> EMPTY_QUADS = ObjectLists.emptyList();
    private static final ResourceLocation FAKE_RESOURCELOCATION = new ResourceLocation("fake");
    private static final ModelState IDENTITY_MODEL_STATE = new SimpleModelState(Transformation.m_121093_(), false);
    private final StampedLock _lock = new StampedLock();
    private final ModelSubType[] _subTypes;
    private final FaceBakery _faceBakery = new FaceBakery();

    protected ReactorFuelRodModel(Map<Direction.Axis, BakedModel> baseModels) {
        super(true, false);
        this._subTypes = new ModelSubType[baseModels.size()];
        baseModels.forEach((axis, model) -> {
            this._subTypes[axis.ordinal()] = new ModelSubType((Direction.Axis)axis, (BakedModel)model);
        });
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData modelData, @Nullable RenderType renderType) {
        long writeLockStamp;
        if (side != null || ReactorFuelRodModelData.isOccluded(modelData)) {
            return EMPTY_QUADS;
        }
        ModelSubType modelSubType = this._subTypes[ReactorFuelRodModelData.getOrientation(modelData).ordinal()];
        short modelIndex = ReactorFuelRodModelData.getModelKey(modelData);
        if (0 == modelIndex) {
            return modelSubType._baseModel.getQuads(state, null, rand, ModelData.EMPTY, renderType);
        }
        long lockStamp = this._lock.readLock();
        List quads = (List)modelSubType._cachedQuads.get(modelIndex);
        if (null != quads) {
            this._lock.unlockRead(lockStamp);
            return quads;
        }
        while (true) {
            if (0L != (writeLockStamp = this._lock.tryConvertToWriteLock(lockStamp))) break;
            this._lock.unlockRead(lockStamp);
            lockStamp = this._lock.writeLock();
        }
        LinkedList tempQuads = Lists.newLinkedList((Iterable)modelSubType._baseModel.getQuads(state, null, rand, ModelData.EMPTY, renderType));
        tempQuads.addAll(this.buildQuads(ReactorFuelRodModelData.getFuelLevel(modelData), ReactorFuelRodModelData.getWasteLevel(modelData), modelSubType._axis));
        quads = new ObjectArrayList((Collection)tempQuads);
        modelSubType._cachedQuads.put(modelIndex, (Object)quads);
        lockStamp = writeLockStamp;
        this._lock.unlock(lockStamp);
        return quads;
    }

    public TextureAtlasSprite m_6160_() {
        return this._subTypes[0]._baseModel.getParticleIcon(ModelData.EMPTY);
    }

    public TextureAtlasSprite getParticleIcon(@Nonnull ModelData modelData) {
        return this._subTypes[ReactorFuelRodModelData.getOrientation((ModelData)modelData).ordinal()]._baseModel.getParticleIcon(modelData);
    }

    public ItemOverrides m_7343_() {
        return this._subTypes[0]._baseModel.m_7343_();
    }

    public ItemTransforms m_7442_() {
        return this._subTypes[0]._baseModel.m_7442_();
    }

    public boolean m_7521_() {
        return false;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7541_() {
        return false;
    }

    private List<BakedQuad> buildQuads(byte fuelLevel, byte wasteLevel, Direction.Axis axis) {
        Vector3f to;
        Vector3f from;
        BlockFacings fuelVisibleFaces;
        float[] stillUV;
        float[] wasteFlowingUV;
        float[] fuelFlowingUV;
        float baseWidth;
        float fromZ;
        float fromY;
        float fromX;
        TextureAtlasSprite fuelColumnStill = CachedSprites.REACTOR_FUEL_COLUMN_STILL.get().getAtlasSprite().orElse(ModRenderHelper.getMissingTexture());
        TextureAtlasSprite fuelColumnFlowing = CachedSprites.REACTOR_FUEL_COLUMN_FLOWING.get().getAtlasSprite().orElse(ModRenderHelper.getMissingTexture());
        BlockFacings wasteVisibleFaces = switch (axis.m_122480_()) {
            default -> {
                BlockFacings visibleFaces;
                fuelLevel = (byte)Math.min(fuelLevel, 12);
                wasteLevel = (byte)Math.min(wasteLevel, 12);
                fromX = 3.0f;
                fromY = 2.0f;
                fromZ = 3.0f;
                baseWidth = 10.0f;
                fuelFlowingUV = new float[]{3.0f, 2.0f, 13.0f, 2 + fuelLevel};
                wasteFlowingUV = new float[]{3.0f, 2.0f, 13.0f, 2 + wasteLevel};
                stillUV = new float[]{3.0f, 3.0f, 13.0f, 13.0f};
                fuelVisibleFaces = visibleFaces = BlockFacings.ALL.set(Direction.UP, fuelLevel + wasteLevel < 12).set(Direction.DOWN, false);
                yield visibleFaces.set(Direction.UP, 0 == fuelLevel && wasteLevel < 12);
            }
            case Direction.Plane.HORIZONTAL -> {
                fuelLevel = (byte)Math.min(fuelLevel, 10);
                wasteLevel = (byte)Math.min(wasteLevel, 10);
                fromX = 2.0f;
                fromY = 3.0f;
                fromZ = 2.0f;
                baseWidth = 12.0f;
                fuelFlowingUV = new float[]{2.0f, 3.0f, 14.0f, 2 + fuelLevel};
                wasteFlowingUV = new float[]{2.0f, 3.0f, 14.0f, 2 + wasteLevel};
                stillUV = new float[]{2.0f, 2.0f, 14.0f, 14.0f};
                BlockFacings visibleFaces = BlockFacings.ALL;
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    if (direction.m_122434_() != axis) continue;
                    visibleFaces = visibleFaces.set(direction, false);
                }
                fuelVisibleFaces = visibleFaces.set(Direction.DOWN, 0 == wasteLevel);
                yield visibleFaces.set(Direction.UP, 0 == fuelLevel);
            }
        };
        LinkedList quads = Lists.newLinkedList();
        if (wasteLevel > 0) {
            from = new Vector3f(fromX, fromY, fromZ);
            to = new Vector3f(fromX + baseWidth, fromY + (float)wasteLevel, fromZ + baseWidth);
            wasteVisibleFaces.stream().forEach(direction -> quads.add(this.createFace((Direction)direction, from, to, wasteFlowingUV, stillUV, 1, fuelColumnFlowing, fuelColumnStill)));
        }
        if (fuelLevel > 0) {
            from = new Vector3f(fromX, fromY + (float)wasteLevel, fromZ);
            to = new Vector3f(fromX + baseWidth, fromY + (float)wasteLevel + (float)fuelLevel, fromZ + baseWidth);
            fuelVisibleFaces.stream().forEach(direction -> quads.add(this.createFace((Direction)direction, from, to, fuelFlowingUV, stillUV, 0, fuelColumnFlowing, fuelColumnStill)));
        }
        return quads;
    }

    private BakedQuad createFace(Direction direction, Vector3f cubeFrom, Vector3f cubeTo, float[] flowingUV, float[] stillUV, int tintIndex, TextureAtlasSprite flowingTexture, TextureAtlasSprite stillTexture) {
        boolean isVertical = direction.m_122434_().m_122478_();
        float[] uv = isVertical ? stillUV : flowingUV;
        TextureAtlasSprite sprite = isVertical ? stillTexture : flowingTexture;
        BlockElementFace partFace = new BlockElementFace(null, tintIndex, "", new BlockFaceUV(uv, 0));
        return this._faceBakery.m_111600_(cubeFrom, cubeTo, partFace, sprite, direction, IDENTITY_MODEL_STATE, null, true, FAKE_RESOURCELOCATION);
    }

    private static class ModelSubType {
        private final Direction.Axis _axis;
        private final BakedModel _baseModel;
        private final Short2ObjectMap<List<BakedQuad>> _cachedQuads;

        public ModelSubType(Direction.Axis axis, BakedModel baseModel) {
            Preconditions.checkNotNull((Object)axis, (Object)"Axis cannot be null");
            Preconditions.checkNotNull((Object)baseModel, (Object)"Base model cannot be null");
            this._axis = axis;
            this._baseModel = baseModel;
            this._cachedQuads = new Short2ObjectArrayMap(208);
        }
    }
}

