/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.model.data;

import com.google.common.collect.Lists;
import it.zerono.mods.zerocore.lib.block.BlockFacings;
import it.zerono.mods.zerocore.lib.block.property.BlockFacingsProperty;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class ModelTransformers {
    public static final int MODEL_DEFAULT = 0;
    public static final int MODEL_VARIANT_1 = 1;
    public static final int MODEL_VARIANT_2 = 2;
    public static final int MODEL_VARIANT_3 = 3;
    public static final int MODEL_VARIANT_4 = 4;
    private static final Object s_lock = new Object();
    private static volatile List<BlockFacings> s_casingFacings;

    public static int defaultModelTransformer(ModelData data) {
        return 0;
    }

    public static <C extends AbstractCuboidMultiblockController<C>> byte getGlassVariantIndexFrom(AbstractMultiblockPart<C> entity) {
        if (!entity.isMachineAssembled()) {
            return 0;
        }
        Level world = entity.getPartWorldOrFail();
        BlockPos position = entity.getWorldPosition();
        BlockState entityBlockState = world.m_8055_(position);
        Block entityBlock = entityBlockState.m_60734_();
        Direction[] directions = Direction.values();
        boolean[] actualFacings = new boolean[directions.length];
        for (int i = 0; i < directions.length; ++i) {
            actualFacings[i] = entityBlock == world.m_8055_(position.m_121945_(directions[i])).m_60734_();
        }
        BlockFacingsProperty propertyValue = BlockFacings.from((boolean[])actualFacings).toProperty();
        return (byte)propertyValue.ordinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte getCasingVariantIndexFrom(BlockFacings facings) {
        int variantIndex;
        if (facings.none()) {
            return 0;
        }
        if (facings.one()) {
            return 1;
        }
        ArrayList casingFacings = s_casingFacings;
        if (null == casingFacings) {
            Object object = s_lock;
            synchronized (object) {
                casingFacings = s_casingFacings;
                if (null == casingFacings) {
                    s_casingFacings = casingFacings = Lists.newArrayListWithCapacity((int)20);
                    casingFacings.add(BlockFacings.from((Direction[])new Direction[]{Direction.DOWN, Direction.SOUTH}));
                    casingFacings.add(BlockFacings.from((Direction[])new Direction[]{Direction.DOWN, Direction.EAST}));
                    casingFacings.add(BlockFacings.from((Direction[])new Direction[]{Direction.DOWN, Direction.NORTH}));
                    casingFacings.add(BlockFacings.from((Direction[])new Direction[]{Direction.DOWN, Direction.WEST}));
                    casingFacings.add(BlockFacings.from((Direction[])new Direction[]{Direction.UP, Direction.SOUTH}));
                    casingFacings.add(BlockFacings.from((Direction[])new Direction[]{Direction.UP, Direction.EAST}));
                    casingFacings.add(BlockFacings.from((Direction[])new Direction[]{Direction.UP, Direction.NORTH}));
                    casingFacings.add(BlockFacings.from((Direction[])new Direction[]{Direction.UP, Direction.WEST}));
                    casingFacings.add(BlockFacings.from((Direction[])new Direction[]{Direction.SOUTH, Direction.EAST}));
                    casingFacings.add(BlockFacings.from((Direction[])new Direction[]{Direction.NORTH, Direction.EAST}));
                    casingFacings.add(BlockFacings.from((Direction[])new Direction[]{Direction.NORTH, Direction.WEST}));
                    casingFacings.add(BlockFacings.from((Direction[])new Direction[]{Direction.SOUTH, Direction.WEST}));
                    casingFacings.add(BlockFacings.from((Direction[])new Direction[]{Direction.DOWN, Direction.SOUTH, Direction.WEST}));
                    casingFacings.add(BlockFacings.from((Direction[])new Direction[]{Direction.DOWN, Direction.SOUTH, Direction.EAST}));
                    casingFacings.add(BlockFacings.from((Direction[])new Direction[]{Direction.DOWN, Direction.NORTH, Direction.EAST}));
                    casingFacings.add(BlockFacings.from((Direction[])new Direction[]{Direction.DOWN, Direction.NORTH, Direction.WEST}));
                    casingFacings.add(BlockFacings.from((Direction[])new Direction[]{Direction.UP, Direction.SOUTH, Direction.WEST}));
                    casingFacings.add(BlockFacings.from((Direction[])new Direction[]{Direction.UP, Direction.SOUTH, Direction.EAST}));
                    casingFacings.add(BlockFacings.from((Direction[])new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST}));
                    casingFacings.add(BlockFacings.from((Direction[])new Direction[]{Direction.UP, Direction.NORTH, Direction.WEST}));
                }
            }
        }
        return (byte)((variantIndex = casingFacings.indexOf(facings)) >= 0 ? 2 + variantIndex : 0);
    }

    private static <T> Optional<T> getPropertyValue(ModelData data, ModelProperty<T> property) {
        return data.has(property) ? Optional.ofNullable(data.get(property)) : Optional.empty();
    }
}

