/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.emi.emi.EmiPort;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.EmiScreenManager;
import dev.emi.emi.search.EmiSearch;
import dev.emi.emi.search.QueryType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;

public class EmiSearchWidget
extends EditBox {
    private static final Pattern ESCAPE = Pattern.compile("\\\\.");
    private List<Tuple<Integer, Style>> styles;
    private long lastClick = 0L;
    private String last = "";
    private long lastRender = System.currentTimeMillis();
    private long accumulatedSpin = 0L;
    public boolean highlight = false;
    public boolean isFocused;

    public EmiSearchWidget(Font textRenderer, int x, int y, int width, int height) {
        super(textRenderer, x, y, width, height, (Component)EmiPort.literal(""));
        this.m_94190_(true);
        this.m_94202_(-1);
        this.m_94205_(-1);
        this.m_94199_(256);
        this.m_94149_((string, stringStart) -> {
            int end;
            Tuple<Integer, Style> style;
            int s;
            MutableComponent text = null;
            int last = 0;
            for (s = 0; s < this.styles.size(); ++s) {
                style = this.styles.get(s);
                end = (Integer)style.m_14418_();
                if (end <= stringStart) continue;
                if (end - stringStart >= string.length()) {
                    text = EmiPort.literal(string.substring(0, string.length()), (Style)style.m_14419_());
                    s = this.styles.size();
                    break;
                }
                text = EmiPort.literal(string.substring(0, end - stringStart), (Style)style.m_14419_());
                last = end - stringStart;
                ++s;
                break;
            }
            while (s < this.styles.size()) {
                style = this.styles.get(s);
                end = (Integer)style.m_14418_();
                if (end - stringStart >= string.length()) {
                    EmiPort.append(text, (Component)EmiPort.literal(string.substring(last, string.length()), (Style)style.m_14419_()));
                    break;
                }
                EmiPort.append(text, (Component)EmiPort.literal(string.substring(last, end - stringStart), (Style)style.m_14419_()));
                last = end - stringStart;
                ++s;
            }
            return EmiPort.ordered(text);
        });
        this.m_94151_(string -> {
            if (string.isEmpty()) {
                this.m_94167_(I18n.m_118938_((String)"emi.search", (Object[])new Object[0]));
                EmiScreenManager.focusSearchSidebarType(EmiConfig.emptySearchSidebarFocus);
            } else {
                this.m_94167_("");
                EmiScreenManager.focusSearchSidebarType(EmiConfig.searchSidebarFocus);
            }
            Matcher matcher = EmiSearch.TOKENS.matcher((CharSequence)string);
            ArrayList styles = Lists.newArrayList();
            int last = 0;
            while (matcher.find()) {
                String group;
                int start = matcher.start();
                int end = matcher.end();
                if (last < start) {
                    styles.add(new Tuple((Object)start, (Object)Style.f_131099_.m_131157_(ChatFormatting.WHITE)));
                }
                if ((group = matcher.group()).startsWith("-")) {
                    styles.add(new Tuple((Object)(start + 1), (Object)Style.f_131099_.m_131157_(ChatFormatting.RED)));
                    ++start;
                    group = group.substring(1);
                }
                QueryType type = QueryType.fromString(group);
                int subStart = type.prefix.length();
                if (group.length() > 1 + subStart && group.substring(subStart).startsWith("/") && group.endsWith("/")) {
                    int rOff = start + subStart + 1;
                    styles.add(new Tuple((Object)rOff, (Object)type.slashColor));
                    Matcher rMatcher = ESCAPE.matcher(string.substring(rOff, end - 1));
                    int rLast = 0;
                    while (rMatcher.find()) {
                        int rStart = rMatcher.start();
                        int rEnd = rMatcher.end();
                        if (rLast < rStart) {
                            styles.add(new Tuple((Object)(rStart + rOff), (Object)type.regexColor));
                        }
                        styles.add(new Tuple((Object)(rEnd + rOff), (Object)type.escapeColor));
                        rLast = rEnd;
                    }
                    if (rLast < end - 1) {
                        styles.add(new Tuple((Object)(end - 1), (Object)type.regexColor));
                    }
                    styles.add(new Tuple((Object)end, (Object)type.slashColor));
                } else {
                    styles.add(new Tuple((Object)end, (Object)type.color));
                }
                last = end;
            }
            if (last < string.length()) {
                styles.add(new Tuple((Object)string.length(), (Object)Style.f_131099_.m_131157_(ChatFormatting.WHITE)));
            }
            this.styles = styles;
            EmiSearch.search(string);
        });
    }

    public void update() {
        this.m_94144_(this.m_94155_());
    }

    public void swap() {
        String last = this.m_94155_();
        this.m_94144_(this.last);
        this.last = last;
    }

    public void m_93692_(boolean focused) {
        this.isFocused = focused;
        super.m_93692_(focused);
    }

    public boolean m_93696_() {
        return this.isFocused;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.m_5953_(mouseX, mouseY) || !EmiConfig.enabled) {
            this.m_93692_(false);
            return false;
        }
        boolean b = super.m_6375_(mouseX, mouseY, button == 1 ? 0 : button);
        if (this.m_5953_(mouseX, mouseY)) {
            this.m_93692_(true);
        }
        if (this.m_93696_()) {
            if (button == 0) {
                if (System.currentTimeMillis() - this.lastClick < 500L) {
                    this.highlight = !this.highlight;
                    this.lastClick = 0L;
                } else {
                    this.lastClick = System.currentTimeMillis();
                }
            } else if (button == 1) {
                this.m_94144_("");
                this.m_93692_(true);
            }
        }
        return b;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.m_93696_()) {
            if (EmiConfig.clearSearch.matchesKey(keyCode, scanCode)) {
                this.m_94144_("");
                return true;
            }
            if (EmiConfig.focusSearch.matchesKey(keyCode, scanCode) || keyCode == 257 || keyCode == 256) {
                this.m_93692_(false);
                this.m_93692_(false);
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics raw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        this.m_94186_(EmiConfig.enabled);
        String lower = this.m_94155_().toLowerCase();
        boolean dinnerbone = lower.contains("dinnerbone");
        this.accumulatedSpin += (long)(dinnerbone ? 1 : -1) * Math.abs(System.currentTimeMillis() - this.lastRender);
        if (this.accumulatedSpin < 0L) {
            this.accumulatedSpin = 0L;
        } else if (this.accumulatedSpin > 500L) {
            this.accumulatedSpin = 500L;
        }
        this.lastRender = System.currentTimeMillis();
        long deg = this.accumulatedSpin * -180L / 500L;
        PoseStack view = RenderSystem.getModelViewStack();
        view.m_85836_();
        if (deg != 0L) {
            view.m_252880_((float)(this.f_93620_ + this.f_93618_ / 2), (float)(this.f_93621_ + this.f_93619_ / 2), 0.0f);
            view.m_252781_(Axis.f_252393_.m_252977_((float)deg));
            view.m_252880_((float)(-(this.f_93620_ + this.f_93618_ / 2)), (float)(-(this.f_93621_ + this.f_93619_ / 2)), 0.0f);
            RenderSystem.applyModelViewMatrix();
        }
        if (lower.contains("jeb_")) {
            int amount = 1023;
            float h = (float)(this.lastRender & (long)amount) % (float)amount / (float)amount;
            int rgb = Mth.m_14169_((float)h, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderColor((float)((float)(rgb >> 16 & 0xFF) / 255.0f), (float)((float)(rgb >> 8 & 0xFF) / 255.0f), (float)((float)(rgb >> 0 & 0xFF) / 255.0f), (float)1.0f);
        }
        if (EmiConfig.enabled) {
            super.m_88315_(context.raw(), mouseX, mouseY, delta);
            if (this.highlight) {
                int border = -1118720;
                context.fill(this.f_93620_ - 1, this.f_93621_ - 1, this.f_93618_ + 2, 1, border);
                context.fill(this.f_93620_ - 1, this.f_93621_ + this.f_93619_, this.f_93618_ + 2, 1, border);
                context.fill(this.f_93620_ - 1, this.f_93621_ - 1, 1, this.f_93619_ + 2, border);
                context.fill(this.f_93620_ + this.f_93618_, this.f_93621_ - 1, 1, this.f_93619_ + 2, border);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        view.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }
}

