/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.jemi.impl;

import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.jemi.JemiUtil;
import dev.emi.emi.jemi.impl.JemiRecipeSlotBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;

public class JemiRecipeSlot
implements IRecipeSlotView {
    public final RecipeIngredientRole role;
    public final int x;
    public final int y;
    public final Optional<String> name;
    public final IRecipeSlotTooltipCallback tooltipCallback;
    public final OffsetDrawable background;
    public final OffsetDrawable overlay;
    public final Map<IIngredientType<?>, IngredientRenderer<?>> renderers;
    public final TankInfo tankInfo;
    public final EmiIngredient stack;
    public SlotWidget widget;

    public JemiRecipeSlot(JemiRecipeSlotBuilder builder) {
        this.role = builder.acceptor.role;
        this.x = builder.x;
        this.y = builder.y;
        this.name = builder.name;
        this.tooltipCallback = builder.tooltipCallback;
        this.background = builder.background;
        this.overlay = builder.overlay;
        this.renderers = builder.renderers;
        this.tankInfo = builder.tankInfo;
        this.stack = builder.acceptor.build();
    }

    public JemiRecipeSlot(RecipeIngredientRole role, EmiStack stack) {
        this.role = role;
        this.x = 0;
        this.y = 0;
        this.name = Optional.empty();
        this.tooltipCallback = null;
        this.background = null;
        this.overlay = null;
        this.renderers = null;
        this.tankInfo = null;
        this.stack = stack;
    }

    public <T> Stream<T> getIngredients(IIngredientType<T> ingredientType) {
        return this.getAllIngredients().filter(t -> t.getType() == ingredientType).map(t -> t.getIngredient());
    }

    public Stream<ITypedIngredient<?>> getAllIngredients() {
        return this.stack.getEmiStacks().stream().map(JemiUtil::getTyped).filter(Optional::isPresent).map(Optional::get);
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public <T> Optional<T> getDisplayedIngredient(IIngredientType<T> ingredientType) {
        Optional<ITypedIngredient<?>> ing = this.getDisplayedIngredient();
        if (ing.isPresent() && ing.get().getType() == ingredientType) {
            return Optional.of(ing.get().getIngredient());
        }
        return Optional.empty();
    }

    public Optional<ITypedIngredient<?>> getDisplayedIngredient() {
        return JemiUtil.getTyped(this.stack.getEmiStacks().get(0));
    }

    public Optional<String> getSlotName() {
        return this.name;
    }

    public RecipeIngredientRole getRole() {
        return this.role;
    }

    public void drawHighlight(GuiGraphics raw, int color) {
    }

    public record OffsetDrawable(IDrawable drawable, int xOff, int yOff) {
    }

    public record TankInfo(int width, int height, long capacity, boolean showCapacity) {
    }

    public record IngredientRenderer<T>(IIngredientType<T> type, IIngredientRenderer<T> renderer) {
    }
}

