/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.jemi;

import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.jemi.JemiRecipe;
import dev.emi.emi.jemi.JemiUtil;
import dev.emi.emi.jemi.impl.JemiRecipeLayoutBuilder;
import dev.emi.emi.jemi.impl.JemiRecipeSlot;
import dev.emi.emi.jemi.impl.JemiRecipeSlotsView;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;

public class JemiRecipeHandler<T extends AbstractContainerMenu, R>
implements EmiRecipeHandler<T> {
    private final RecipeType<R> type;
    public IRecipeTransferHandler<T, R> handler;

    public JemiRecipeHandler(IRecipeTransferHandler<T, R> handler) {
        this.handler = handler;
        this.type = handler.getRecipeType();
    }

    @Override
    public boolean alwaysDisplaySupport(EmiRecipe recipe) {
        return this.type != null;
    }

    @Override
    public EmiPlayerInventory getInventory(AbstractContainerScreen<T> screen) {
        return new EmiPlayerInventory(List.of());
    }

    @Override
    public boolean supportsRecipe(EmiRecipe recipe) {
        return (this.type == null || this.getRawRecipe(recipe) != null) && recipe.supportsRecipeTree();
    }

    @Override
    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<T> context) {
        IRecipeTransferError err = this.jeiCraft(recipe, context, false);
        return err == null || err.getType().allowsTransfer;
    }

    @Override
    public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
        IRecipeTransferError err = this.jeiCraft(recipe, context, true);
        if (err == null || err.getType().allowsTransfer) {
            Minecraft.m_91087_().m_91152_(context.getScreen());
        }
        return err == null || err.getType().allowsTransfer;
    }

    @Override
    public void render(EmiRecipe recipe, EmiCraftContext<T> context, List<Widget> widgets, GuiGraphics raw) {
    }

    private IRecipeTransferError jeiCraft(EmiRecipe recipe, EmiCraftContext<T> context, boolean craft) {
        try {
            Minecraft client = Minecraft.m_91087_();
            R rawRecipe = this.getRawRecipe(recipe);
            JemiRecipeSlotsView view = this.createSlotsView(recipe, rawRecipe);
            if (view == null) {
                return () -> IRecipeTransferError.Type.INTERNAL;
            }
            return this.handler.transferRecipe(context.getScreenHandler(), rawRecipe != null ? rawRecipe : recipe, (IRecipeSlotsView)view, (Player)client.f_91074_, context.getAmount() > 1, craft);
        }
        catch (Exception e) {
            e.printStackTrace();
            return () -> IRecipeTransferError.Type.INTERNAL;
        }
    }

    private JemiRecipeSlotsView createSlotsView(EmiRecipe recipe, R rawRecipe) {
        JemiRecipeLayoutBuilder builder = null;
        if (rawRecipe == null && this.type != null) {
            return null;
        }
        if (builder == null) {
            builder = new JemiRecipeLayoutBuilder();
            this.addIngredients(builder, recipe.getInputs(), RecipeIngredientRole.INPUT);
            this.addIngredients(builder, recipe.getCatalysts(), RecipeIngredientRole.CATALYST);
            this.addIngredients(builder, recipe.getOutputs(), RecipeIngredientRole.OUTPUT);
        }
        return new JemiRecipeSlotsView(builder.slots.stream().map(JemiRecipeSlot::new).toList());
    }

    private R getRawRecipe(EmiRecipe recipe) {
        try {
            Optional opt;
            Minecraft client = Minecraft.m_91087_();
            RecipeManager manager = client.f_91073_.m_7465_();
            if (this.type != null && this.type.getRecipeClass() != null) {
                if (recipe instanceof JemiRecipe) {
                    JemiRecipe jr = (JemiRecipe)recipe;
                    if (jr.recipe != null && this.type.getRecipeClass().isAssignableFrom(jr.recipe.getClass())) {
                        return (R)this.type.getRecipeClass().cast(jr.recipe);
                    }
                }
                if (manager != null && (opt = manager.m_44043_(recipe.getId())).isPresent()) {
                    Recipe r = (Recipe)opt.get();
                    if (this.type.getRecipeClass().isAssignableFrom(r.getClass())) {
                        return (R)this.type.getRecipeClass().cast(r);
                    }
                }
            }
            if (manager != null && (opt = manager.m_44043_(recipe.getId())).isPresent()) {
                return (R)opt.get();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void addIngredients(JemiRecipeLayoutBuilder builder, List<? extends EmiIngredient> stacks, RecipeIngredientRole role) {
        for (EmiIngredient emiIngredient : stacks) {
            IRecipeSlotBuilder acceptor = builder.addSlot(role, 0, 0);
            for (EmiStack stack : emiIngredient.getEmiStacks()) {
                Optional<ITypedIngredient<?>> opt = JemiUtil.getTyped(stack);
                if (!opt.isPresent()) continue;
                ITypedIngredient<?> typed = opt.get();
                acceptor.addIngredient(typed.getType(), typed.getIngredient());
            }
        }
    }
}

