/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.jemi;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.jemi.JemiCategory;
import dev.emi.emi.jemi.JemiRecipe;
import dev.emi.emi.jemi.JemiRecipeHandler;
import dev.emi.emi.jemi.JemiStack;
import dev.emi.emi.jemi.JemiStackSerializer;
import dev.emi.emi.jemi.JemiUtil;
import dev.emi.emi.jemi.impl.JemiIngredientAcceptor;
import dev.emi.emi.jemi.impl.JemiRecipeLayoutBuilder;
import dev.emi.emi.jemi.runtime.JemiBookmarkOverlay;
import dev.emi.emi.jemi.runtime.JemiDragDropHandler;
import dev.emi.emi.jemi.runtime.JemiIngredientFilter;
import dev.emi.emi.jemi.runtime.JemiIngredientListOverlay;
import dev.emi.emi.jemi.runtime.JemiRecipesGui;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.registry.EmiPluginContainer;
import dev.emi.emi.registry.EmiRecipeFiller;
import dev.emi.emi.registry.EmiRecipes;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.runtime.EmiReloadLog;
import dev.emi.emi.runtime.EmiReloadManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiIngredientInfoRecipe;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRuntimeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IBookmarkOverlay;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientFilter;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.library.ingredients.subtypes.SubtypeInterpreters;
import mezz.jei.library.load.registration.SubtypeRegistration;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.level.material.Fluid;

@JeiPlugin
public class JemiPlugin
implements IModPlugin,
EmiPlugin {
    private static final Map<EmiRecipeCategory, IRecipeCategory<?>> CATEGORY_MAP = Maps.newHashMap();
    private static ISubtypeManager subtypeManager;
    public static IJeiRuntime runtime;
    public static BiPredicate<IIngredientTypeWithSubtypes<? extends Object, ? extends Object>, Object> hasSubtype;

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("emi:jemi");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        try {
            if (((SubtypeRegistration)registration).getInterpreters() != null) {
                hasSubtype = (type, ingredient) -> {
                    IIngredientTypeWithSubtypes castedType = type;
                    SubtypeInterpreters interpreters = ((SubtypeRegistration)registration).getInterpreters();
                    return interpreters.contains(castedType, castedType.getBase(ingredient));
                };
            }
            return;
        }
        catch (Throwable t) {
            t.printStackTrace();
            hasSubtype = (type, ingredient) -> {
                IIngredientTypeWithSubtypes castedType = type;
                return subtypeManager.getSubtypeInfo(castedType, ingredient, UidContext.Recipe) != "";
            };
            return;
        }
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        subtypeManager = registration.getSubtypeManager();
    }

    public void registerRuntime(IRuntimeRegistration registration) {
        registration.setIngredientListOverlay((IIngredientListOverlay)new JemiIngredientListOverlay());
        registration.setBookmarkOverlay((IBookmarkOverlay)new JemiBookmarkOverlay());
        registration.setRecipesGui((IRecipesGui)new JemiRecipesGui());
        registration.setIngredientFilter((IIngredientFilter)new JemiIngredientFilter());
    }

    public void onRuntimeAvailable(IJeiRuntime runtime) {
        JemiPlugin.runtime = runtime;
    }

    public void onRuntimeUnavailable() {
        runtime = null;
    }

    @Override
    public void register(EmiRegistry registry) {
        EmiLog.info("[JEMI] Waiting for JEI to finish reloading...");
        EmiReloadManager.step((Component)EmiPort.literal("Waiting for JEI to finish..."), 20000L);
        try {
            while (runtime == null) {
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            return;
        }
        EmiLog.info("[JEMI] JEI reloaded!");
        Set handledNamespaces = EmiAgnos.getPlugins().stream().map(EmiPluginContainer::id).collect(Collectors.toSet());
        EmiReloadManager.step((Component)EmiPort.literal("Loading information from JEI..."), 5000L);
        registry.addGenericExclusionArea((screen, consumer) -> {
            if (runtime != null && runtime.getScreenHelper() != null) {
                List areas = runtime.getScreenHelper().getGuiExclusionAreas(screen).toList();
                for (Rect2i r : areas) {
                    if (r == null) continue;
                    consumer.accept(new Bounds(r.m_110085_(), r.m_110086_(), r.m_110090_(), r.m_110091_()));
                }
            }
        });
        registry.addGenericStackProvider((screen, x, y) -> new EmiStackInteraction(runtime.getScreenHelper().getClickableIngredientUnderMouse(screen, (double)x, (double)y).map(IClickableIngredient::getTypedIngredient).map(JemiUtil::getStack).findFirst().orElse(EmiStack.EMPTY), null, false));
        registry.addGenericDragDropHandler(new JemiDragDropHandler());
        registry.addIngredientSerializer(JemiStack.class, new JemiStackSerializer(runtime.getIngredientManager()));
        EmiReloadManager.step((Component)EmiPort.literal("Processing JEI stacks..."), 5000L);
        for (IIngredientType type : runtime.getIngredientManager().getRegisteredIngredientTypes()) {
            if (type == JemiUtil.getFluidType() || type == VanillaTypes.ITEM_STACK) continue;
            for (Object o : runtime.getIngredientManager().getAllIngredients(type)) {
                EmiStack stack = JemiUtil.getStack(type, o);
                if (stack.isEmpty()) continue;
                registry.addEmiStack(stack);
            }
        }
        registry.removeEmiStacks(s -> {
            try {
                Optional<ITypedIngredient<?>> opt = JemiUtil.getTyped(s);
                if (opt.isPresent()) {
                    return !runtime.getIngredientVisibility().isIngredientVisible(opt.get());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        });
        EmiReloadManager.step((Component)EmiPort.literal("Processing JEI subtypes..."), 5000L);
        JemiPlugin.safely("subtype comparison", () -> this.parseSubtypes(registry));
        EmiReloadManager.step((Component)EmiPort.literal("Processing JEI recipes..."), 5000L);
        Set existingCategories = EmiRecipes.categories.stream().map(EmiRecipeCategory::getId).collect(Collectors.toSet());
        HashMap categoryMap = Maps.newHashMap();
        categoryMap.put(RecipeTypes.CRAFTING, VanillaEmiRecipeCategories.CRAFTING);
        categoryMap.put(RecipeTypes.SMELTING, VanillaEmiRecipeCategories.SMELTING);
        categoryMap.put(RecipeTypes.BLASTING, VanillaEmiRecipeCategories.BLASTING);
        categoryMap.put(RecipeTypes.SMOKING, VanillaEmiRecipeCategories.SMOKING);
        categoryMap.put(RecipeTypes.CAMPFIRE_COOKING, VanillaEmiRecipeCategories.CAMPFIRE_COOKING);
        categoryMap.put(RecipeTypes.STONECUTTING, VanillaEmiRecipeCategories.STONECUTTING);
        categoryMap.put(RecipeTypes.SMITHING, VanillaEmiRecipeCategories.SMITHING);
        categoryMap.put(RecipeTypes.ANVIL, VanillaEmiRecipeCategories.ANVIL_REPAIRING);
        categoryMap.put(RecipeTypes.BREWING, VanillaEmiRecipeCategories.BREWING);
        categoryMap.put(RecipeTypes.FUELING, VanillaEmiRecipeCategories.FUEL);
        categoryMap.put(RecipeTypes.COMPOSTING, VanillaEmiRecipeCategories.COMPOSTING);
        categoryMap.put(RecipeTypes.INFORMATION, VanillaEmiRecipeCategories.INFO);
        CATEGORY_MAP.clear();
        EmiRecipeFiller.extraHandlers = JemiPlugin::getRecipeHandler;
        List categories = runtime.getRecipeManager().createRecipeCategoryLookup().includeHidden().get().toList();
        for (IRecipeCategory c : categories) {
            EmiLog.info("[JEMI] Collecing data for " + c.getTitle().getString());
            EmiReloadManager.step((Component)EmiPort.literal("Loading JEI data for ").m_7220_(c.getTitle()), 5000L);
            try {
                EmiRecipeCategory category;
                RecipeType type = c.getRecipeType();
                ResourceLocation id = type.getUid();
                List<EmiStack> catalysts = runtime.getRecipeManager().createRecipeCatalystLookup(type).includeHidden().get().map(JemiUtil::getStack).toList();
                if (categoryMap.containsKey(type)) {
                    category = (EmiRecipeCategory)categoryMap.get(type);
                    CATEGORY_MAP.put(category, c);
                    for (EmiStack catalyst : catalysts) {
                        if (catalyst.isEmpty()) continue;
                        registry.addWorkstation(category, catalyst);
                    }
                    if (type == RecipeTypes.INFORMATION) {
                        this.addInfoRecipes(registry, (IRecipeCategory<IJeiIngredientInfoRecipe>)c);
                        continue;
                    }
                    if (type != RecipeTypes.CRAFTING) continue;
                    this.addCraftingRecipes(registry, (IRecipeCategory<CraftingRecipe>)c);
                    continue;
                }
                if (handledNamespaces.contains(id.m_135827_())) {
                    EmiLog.info("[JEMI] Skipping recipe category " + id + " because mod is already handled");
                    continue;
                }
                if (existingCategories.contains(id)) {
                    EmiLog.info("[JEMI] Skipping recipe category " + id + " because native EMI recipe category already exists");
                    continue;
                }
                category = new JemiCategory(c);
                CATEGORY_MAP.put(category, c);
                registry.addCategory(category);
                for (EmiStack catalyst : catalysts) {
                    if (catalyst.isEmpty()) continue;
                    registry.addWorkstation(category, catalyst);
                }
                List recipes = runtime.getRecipeManager().createRecipeLookup(type).includeHidden().get().toList();
                for (Object r : recipes) {
                    try {
                        registry.addRecipe(new JemiRecipe(category, c, r));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void addInfoRecipes(EmiRegistry registry, IRecipeCategory<IJeiIngredientInfoRecipe> category) {
        List recipes = runtime.getRecipeManager().createRecipeLookup(RecipeTypes.INFORMATION).includeHidden().get().toList();
        HashMap grouped = Maps.newHashMap();
        for (IJeiIngredientInfoRecipe recipe : recipes) {
            grouped.computeIfAbsent(recipe.getIngredients().stream().map(JemiUtil::getStack).toList(), k -> Lists.newArrayList()).add(recipe);
        }
        HashMap identical = Maps.newHashMap();
        for (Map.Entry group : grouped.entrySet()) {
            MutableComponent text = EmiPort.literal("");
            for (IJeiIngredientInfoRecipe recipe : (List)group.getValue()) {
                for (FormattedText sv : recipe.getDescription()) {
                    MutableComponent current = EmiPort.literal("");
                    sv.m_7451_((style, string) -> {
                        current.m_7220_((Component)EmiPort.literal(string, style));
                        return Optional.empty();
                    }, Style.f_131099_);
                    if (current.getString().isBlank()) continue;
                    if (!text.getString().isEmpty()) {
                        text.m_130946_(" ");
                    }
                    text.m_7220_((Component)current);
                }
            }
            identical.computeIfAbsent(text, k -> Lists.newArrayList()).addAll((Collection)group.getKey());
        }
        for (Component text : identical.keySet()) {
            registry.addRecipe(new EmiInfoRecipe(((List)identical.get(text)).stream().map(s -> s).toList(), List.of(text), null));
        }
    }

    private void addCraftingRecipes(EmiRegistry registry, IRecipeCategory<CraftingRecipe> category) {
        HashSet replaced = Sets.newHashSet();
        HashSet replacements = Sets.newHashSet();
        for (final CraftingRecipe recipe : registry.getRecipeManager().m_44013_(net.minecraft.world.item.crafting.RecipeType.f_44107_)) {
            try {
                if (!category.isHandled((Object)recipe)) continue;
                JemiRecipeLayoutBuilder builder = new JemiRecipeLayoutBuilder();
                category.setRecipe((IRecipeLayoutBuilder)builder, (Object)recipe, runtime.getJeiHelpers().getFocusFactory().getEmptyFocusGroup());
                final ArrayList inputs = Lists.newArrayList();
                final ArrayList outputs = Lists.newArrayList();
                for (JemiIngredientAcceptor acceptor : builder.ingredients) {
                    EmiIngredient stack = acceptor.build();
                    if (acceptor.role == RecipeIngredientRole.INPUT) {
                        inputs.add(stack);
                        continue;
                    }
                    if (acceptor.role == RecipeIngredientRole.CATALYST) {
                        inputs.add(stack);
                        continue;
                    }
                    if (acceptor.role != RecipeIngredientRole.OUTPUT) continue;
                    outputs.addAll(stack.getEmiStacks());
                }
                if (!inputs.stream().anyMatch(i -> !i.isEmpty()) || !outputs.stream().anyMatch(o -> !o.isEmpty())) continue;
                EmiCraftingRecipe replacement = outputs.size() > 1 ? new EmiPatternCraftingRecipe(inputs, EmiStack.EMPTY, category.getRegistryName((Object)recipe), builder.shapeless){

                    @Override
                    public List<EmiStack> getOutputs() {
                        return outputs;
                    }

                    @Override
                    public SlotWidget getInputWidget(int slot, int x, int y) {
                        if (slot <= inputs.size()) {
                            return new SlotWidget((EmiIngredient)inputs.get(slot), x, y);
                        }
                        return new SlotWidget(EmiStack.EMPTY, x, y);
                    }

                    @Override
                    public SlotWidget getOutputWidget(int x, int y) {
                        return new GeneratedSlotWidget(r -> (EmiIngredient)outputs.get(r.nextInt(outputs.size())), recipe.hashCode(), x, y);
                    }
                } : new EmiCraftingRecipe(inputs, (EmiStack)outputs.get(0), category.getRegistryName((Object)recipe), builder.shapeless);
                if (replacement.getId() != null) {
                    replaced.add(replacement.getId());
                }
                replacements.add(replacement);
                registry.addRecipe(replacement);
            }
            catch (Throwable t) {
                EmiLog.error("[JEMI] Exception thrown setting JEI crafting recipe");
            }
        }
        registry.removeRecipes(r -> r instanceof EmiCraftingRecipe && replaced.contains(r.getId()) && !replacements.contains(r));
    }

    private void parseSubtypes(EmiRegistry registry) {
        if (subtypeManager != null) {
            IIngredientManager im = runtime.getIngredientManager();
            ArrayList types = Lists.newArrayList((Iterable)im.getRegisteredIngredientTypes());
            for (Item item : EmiPort.getItemRegistry()) {
                if (!hasSubtype.test((IIngredientTypeWithSubtypes<? extends Object, ? extends Object>)VanillaTypes.ITEM_STACK, item.m_7968_())) continue;
                registry.setDefaultComparison((Object)item, Comparison.compareData(stack -> subtypeManager.getSubtypeInfo(stack.getItemStack(), UidContext.Recipe)));
            }
            for (Fluid fluid : EmiPort.getFluidRegistry()) {
                IIngredientTypeWithSubtypes type = (IIngredientTypeWithSubtypes)JemiUtil.getFluidType();
                if (!hasSubtype.test((IIngredientTypeWithSubtypes<? extends Object, ? extends Object>)type, JemiUtil.getFluidHelper().create(fluid, 1000L))) continue;
                registry.setDefaultComparison((Object)fluid, Comparison.compareData(stack -> {
                    ITypedIngredient typed = JemiUtil.getTyped(stack).orElse(null);
                    if (typed != null) {
                        return subtypeManager.getSubtypeInfo(type, typed.getIngredient(), UidContext.Recipe);
                    }
                    return null;
                }));
            }
            for (IIngredientType type : types) {
                if (type == VanillaTypes.ITEM_STACK || type == JemiUtil.getFluidType() || !(type instanceof IIngredientTypeWithSubtypes)) continue;
                IIngredientTypeWithSubtypes iitws = (IIngredientTypeWithSubtypes)type;
                ArrayList ings = Lists.newArrayList((Iterable)im.getAllIngredients(type));
                for (Object o : ings) {
                    try {
                        if (!hasSubtype.test((IIngredientTypeWithSubtypes<? extends Object, ? extends Object>)iitws, o)) continue;
                        registry.setDefaultComparison(iitws.getBase(o), Comparison.compareData(stack -> {
                            if (stack instanceof JemiStack) {
                                JemiStack jemi = (JemiStack)stack;
                                return subtypeManager.getSubtypeInfo(iitws, jemi.ingredient, UidContext.Recipe);
                            }
                            return null;
                        }));
                    }
                    catch (Throwable t) {
                        EmiReloadLog.warn("Exception adding default comparison for JEI ingredient");
                        EmiReloadLog.error(t);
                    }
                }
            }
        }
    }

    private static EmiRecipeHandler<?> getRecipeHandler(AbstractContainerMenu handler, EmiRecipe recipe) {
        IRecipeCategory category = CATEGORY_MAP.getOrDefault(recipe.getCategory(), null);
        if (category != null) {
            return runtime.getRecipeTransferManager().getRecipeTransferHandler(handler, category).map(JemiRecipeHandler::new).orElse(null);
        }
        return null;
    }

    private static void safely(String name, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            EmiReloadLog.warn("Exception thrown when reloading " + name + " step in JEMI plugin");
            EmiReloadLog.error(t);
        }
    }

    static {
        hasSubtype = (a, b) -> true;
    }
}

