/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeSorting;
import dev.emi.emi.api.recipe.EmiWorldInteractionRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import dev.emi.emi.data.EmiAlias;
import dev.emi.emi.data.EmiDataLoader;
import dev.emi.emi.data.EmiRecipeCategoryProperties;
import dev.emi.emi.data.EmiResourceReloadListener;
import dev.emi.emi.data.EmiTagExclusionsLoader;
import dev.emi.emi.data.IndexStackData;
import dev.emi.emi.data.RecipeDefaultLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class EmiData {
    public static Map<String, EmiRecipeCategoryProperties> categoryPriorities = Map.of();
    public static List<Predicate<EmiRecipe>> recipeFilters = List.of();
    public static List<Supplier<IndexStackData>> stackData = List.of();
    public static List<Supplier<EmiAlias>> aliases = List.of();
    public static List<Supplier<EmiRecipe>> recipes = List.of();

    public static void init(Consumer<EmiResourceReloadListener> register) {
        register.accept(new RecipeDefaultLoader());
        register.accept(new EmiTagExclusionsLoader());
        register.accept(new EmiDataLoader<Map>(new ResourceLocation("emi:category_properties"), "category/properties", Maps::newHashMap, (map, json, id) -> {
            for (String k : json.keySet()) {
                JsonObject icon;
                if (!GsonHelper.m_144772_((JsonObject)json, (String)k)) continue;
                EmiRecipeCategoryProperties props = map.computeIfAbsent(k, s -> new EmiRecipeCategoryProperties());
                JsonObject val = json.getAsJsonObject(k);
                if (GsonHelper.m_144762_((JsonObject)val, (String)"order")) {
                    props.order = val.get("order").getAsInt();
                }
                if (GsonHelper.m_144772_((JsonObject)val, (String)"icon")) {
                    icon = val.getAsJsonObject("icon");
                    if (GsonHelper.m_13813_((JsonObject)icon, (String)"texture")) {
                        props.icon = () -> new EmiTexture(new ResourceLocation(GsonHelper.m_13906_((JsonObject)icon, (String)"texture")), 0, 0, 16, 16, 16, 16, 16, 16);
                    } else if (GsonHelper.m_13813_((JsonObject)icon, (String)"stack")) {
                        props.icon = () -> EmiIngredientSerializer.getDeserialized(icon.get("stack"));
                    }
                }
                if (GsonHelper.m_144772_((JsonObject)val, (String)"simplified_icon")) {
                    icon = val.getAsJsonObject("simplified_icon");
                    if (GsonHelper.m_13813_((JsonObject)icon, (String)"texture")) {
                        props.simplified = () -> new EmiTexture(new ResourceLocation(GsonHelper.m_13906_((JsonObject)icon, (String)"texture")), 0, 0, 16, 16, 16, 16, 16, 16);
                    } else if (GsonHelper.m_13813_((JsonObject)icon, (String)"stack")) {
                        props.simplified = () -> EmiIngredientSerializer.getDeserialized(icon.get("stack"));
                    }
                }
                if (!GsonHelper.m_13813_((JsonObject)val, (String)"sort")) continue;
                switch (GsonHelper.m_13906_((JsonObject)val, (String)"sort")) {
                    case "none": {
                        props.sort = EmiRecipeSorting.none();
                        break;
                    }
                    case "input_then_output": {
                        props.sort = EmiRecipeSorting.compareInputThenOutput();
                        break;
                    }
                    case "output_then_input": {
                        props.sort = EmiRecipeSorting.compareOutputThenInput();
                    }
                }
            }
        }, map -> {
            categoryPriorities = map;
        }));
        register.accept(new EmiDataLoader<List>(new ResourceLocation("emi:recipe_filters"), "recipe/filters", Lists::newArrayList, (list, json, oid) -> {
            JsonArray arr = GsonHelper.m_13832_((JsonObject)json, (String)"filters", (JsonArray)new JsonArray());
            for (JsonElement el : arr) {
                Pattern pat;
                String id;
                if (!el.isJsonObject()) continue;
                JsonObject obj = el.getAsJsonObject();
                ArrayList predicates = Lists.newArrayList();
                if (GsonHelper.m_13813_((JsonObject)obj, (String)"id")) {
                    id = GsonHelper.m_13906_((JsonObject)obj, (String)"id");
                    if (id.startsWith("/") && id.endsWith("/")) {
                        pat = Pattern.compile(id.substring(1, id.length() - 1));
                        predicates.add(r -> {
                            String rid = r.getId() == null ? "null" : r.getId().toString();
                            return pat.matcher(rid).find();
                        });
                    } else {
                        predicates.add(r -> {
                            String rid = r.getId() == null ? "null" : r.getId().toString();
                            return rid.equals(id);
                        });
                    }
                }
                if (GsonHelper.m_13813_((JsonObject)obj, (String)"category")) {
                    id = GsonHelper.m_13906_((JsonObject)obj, (String)"category");
                    if (id.startsWith("/") && id.endsWith("/")) {
                        pat = Pattern.compile(id.substring(1, id.length() - 1));
                        predicates.add(r -> pat.matcher(r.getCategory().getId().toString()).find());
                    } else {
                        predicates.add(r -> r.getCategory().getId().toString().equals(id));
                    }
                }
                if (predicates.size() <= 1) {
                    list.addAll(predicates);
                    continue;
                }
                list.add(r -> {
                    for (Predicate p : predicates) {
                        if (p.test(r)) continue;
                        return false;
                    }
                    return true;
                });
            }
        }, list -> {
            recipeFilters = list;
        }));
        register.accept(new EmiDataLoader<List>(new ResourceLocation("emi:index_stacks"), "index/stacks", Lists::newArrayList, (list, json, oid) -> list.add(() -> {
            ArrayList added = Lists.newArrayList();
            ArrayList removed = Lists.newArrayList();
            ArrayList filters = Lists.newArrayList();
            if (GsonHelper.m_13885_((JsonObject)json, (String)"added")) {
                for (JsonElement el : json.getAsJsonArray("added")) {
                    if (!el.isJsonObject()) continue;
                    JsonObject obj = el.getAsJsonObject();
                    EmiIngredient stack = EmiIngredientSerializer.getDeserialized(obj.get("stack"));
                    EmiIngredient after = EmiStack.EMPTY;
                    if (obj.has("after")) {
                        after = EmiIngredientSerializer.getDeserialized(obj.get("after"));
                    }
                    added.add(new IndexStackData.Added(stack, after));
                }
            }
            if (GsonHelper.m_13885_((JsonObject)json, (String)"removed")) {
                for (JsonElement el : json.getAsJsonArray("removed")) {
                    removed.add(EmiIngredientSerializer.getDeserialized(el));
                }
            }
            if (GsonHelper.m_13885_((JsonObject)json, (String)"filters")) {
                for (JsonElement el : json.getAsJsonArray("filters")) {
                    if (!GsonHelper.m_13803_((JsonElement)el)) continue;
                    String id = el.getAsString();
                    if (id.startsWith("/") && id.endsWith("/")) {
                        Pattern pat = Pattern.compile(id.substring(1, id.length() - 1));
                        filters.add(new IndexStackData.Filter(s -> pat.matcher((CharSequence)s).find()));
                        continue;
                    }
                    filters.add(new IndexStackData.Filter(s -> s.equals(id)));
                }
            }
            boolean disable = GsonHelper.m_13855_((JsonObject)json, (String)"disable", (boolean)false);
            return new IndexStackData(disable, added, removed, filters);
        }), list -> {
            stackData = list;
        }));
        register.accept(new EmiDataLoader<List>(new ResourceLocation("emi:aliases"), "aliases", Lists::newArrayList, (list, json, id) -> {
            if (GsonHelper.m_13885_((JsonObject)json, (String)"aliases")) {
                for (JsonElement el : json.getAsJsonArray("aliases")) {
                    if (!el.isJsonObject()) continue;
                    JsonObject obj = el.getAsJsonObject();
                    list.add(() -> new EmiAlias(EmiData.getArrayOrSingleton(obj, "stacks").map(e -> EmiIngredientSerializer.getDeserialized(e)).toList(), EmiData.getArrayOrSingleton(obj, "text").map(e -> e.getAsString()).toList()));
                }
            }
        }, list -> {
            aliases = list;
        }));
        register.accept(new EmiDataLoader<List>(new ResourceLocation("emi:recipe_additions"), "recipe/additions", Lists::newArrayList, (list, json, oid) -> {
            String s = GsonHelper.m_13851_((JsonObject)json, (String)"type", (String)"");
            ResourceLocation id = new ResourceLocation("emi:/generated/" + oid.m_135815_());
            if (s.equals("emi:info")) {
                list.add(() -> new EmiInfoRecipe(EmiData.getArrayOrSingleton(json, "stacks").map(EmiIngredientSerializer::getDeserialized).toList(), EmiData.getArrayOrSingleton(json, "text").map(t -> EmiPort.translatable(t.getAsString())).toList(), id));
            } else if (s.equals("emi:world_interaction")) {
                EmiWorldInteractionRecipe.Builder builder = EmiWorldInteractionRecipe.builder();
                EmiData.getArrayOrSingleton(json, "left").map(EmiIngredientSerializer::getDeserialized).forEach(i -> builder.leftInput((EmiIngredient)i));
                EmiData.getArrayOrSingleton(json, "right").map(EmiIngredientSerializer::getDeserialized).forEach(i -> builder.rightInput((EmiIngredient)i, false));
                EmiData.getArrayOrSingleton(json, "output").map(EmiIngredientSerializer::getDeserialized).forEach(i -> builder.output(i.getEmiStacks().get(0)));
                builder.id(id);
                list.add(() -> builder.build());
            }
        }, list -> {
            recipes = list;
        }));
    }

    private static Stream<JsonElement> getArrayOrSingleton(JsonObject json, String key) {
        if (GsonHelper.m_13885_((JsonObject)json, (String)key)) {
            return StreamSupport.stream(json.getAsJsonArray(key).spliterator(), false);
        }
        return Stream.of(json.get(key));
    }
}

