/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.network.v2;

import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.network.v2.MessageDirection;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.puzzleslib.impl.core.ModContext;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface NetworkHandlerV2 {
    public static NetworkHandlerV2 build(String modId) {
        return NetworkHandlerV2.build(modId, false, false);
    }

    public static NetworkHandlerV2 build(String modId, boolean clientAcceptsVanillaOrMissing, boolean serverAcceptsVanillaOrMissing) {
        return ModContext.get(modId).getNetworkHandlerV2(clientAcceptsVanillaOrMissing, serverAcceptsVanillaOrMissing);
    }

    public <T extends MessageV2<T>> void register(Class<? extends T> var1, Supplier<T> var2, MessageDirection var3);

    public Packet<ServerGamePacketListener> toServerboundPacket(MessageV2<?> var1);

    public Packet<ClientGamePacketListener> toClientboundPacket(MessageV2<?> var1);

    default public void sendToServer(MessageV2<?> message) {
        Proxy.INSTANCE.getClientPacketListener().m_104955_(this.toServerboundPacket(message));
    }

    default public void sendTo(MessageV2<?> message, ServerPlayer player) {
        player.f_8906_.m_9829_(this.toClientboundPacket(message));
    }

    default public void sendToAll(MessageV2<?> message) {
        Proxy.INSTANCE.getGameServer().m_6846_().m_11268_(this.toClientboundPacket(message));
    }

    default public void sendToAllExcept(MessageV2<?> message, ServerPlayer exclude) {
        for (ServerPlayer player : Proxy.INSTANCE.getGameServer().m_6846_().m_11314_()) {
            if (player == exclude) continue;
            this.sendTo(message, player);
        }
    }

    default public void sendToAllNear(MessageV2<?> message, BlockPos pos, Level level) {
        this.sendToAllNearExcept(message, null, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 64.0, level);
    }

    default public void sendToAllNear(MessageV2<?> message, double posX, double posY, double posZ, double distance, Level level) {
        this.sendToAllNearExcept(message, null, posX, posY, posZ, 64.0, level);
    }

    default public void sendToAllNearExcept(MessageV2<?> message, @Nullable ServerPlayer exclude, double posX, double posY, double posZ, double distance, Level level) {
        Proxy.INSTANCE.getGameServer().m_6846_().m_11241_((Player)exclude, posX, posY, posZ, distance, level.m_46472_(), this.toClientboundPacket(message));
    }

    default public void sendToAllTracking(MessageV2<?> message, Entity entity) {
        ((ServerChunkCache)entity.m_20193_().m_7726_()).m_8445_(entity, this.toClientboundPacket(message));
    }

    default public void sendToAllTrackingAndSelf(MessageV2<?> message, Entity entity) {
        ((ServerChunkCache)entity.m_20193_().m_7726_()).m_8394_(entity, this.toClientboundPacket(message));
    }

    default public void sendToDimension(MessageV2<?> message, Level level) {
        this.sendToDimension(message, (ResourceKey<Level>)level.m_46472_());
    }

    default public void sendToDimension(MessageV2<?> message, ResourceKey<Level> dimension) {
        Proxy.INSTANCE.getGameServer().m_6846_().m_11270_(this.toClientboundPacket(message), dimension);
    }
}

