/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.trapdoor.fancy;

import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.FancyTrapdoorBlock;
import com.ldtteam.domumornamentum.block.types.FancyTrapdoorType;
import com.ldtteam.domumornamentum.datagen.MateriallyTexturedModelBuilder;
import com.ldtteam.domumornamentum.datagen.utils.ModelBuilderUtils;
import java.util.Iterator;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class FancyTrapdoorsBlockStateProvider
extends BlockStateProvider {
    public FancyTrapdoorsBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "domum_ornamentum", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.createBlockstateFile(ModBlocks.getInstance().getFancyTrapdoor());
    }

    private void createBlockstateFile(FancyTrapdoorBlock shingle) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)shingle);
        for (Direction facingValue : BlockStateProperties.f_61374_.m_6908_()) {
            for (FancyTrapdoorType typeValue : FancyTrapdoorBlock.TYPE.m_6908_()) {
                for (Half halfValue : TrapDoorBlock.f_57515_.m_6908_()) {
                    Iterator iterator = BlockStateProperties.f_61446_.m_6908_().iterator();
                    while (iterator.hasNext()) {
                        boolean openValue = (Boolean)iterator.next();
                        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/trapdoor/fancy/trapdoor_" + typeValue.m_7912_(), this.modLoc("block/trapdoor/fancy/trapdoor_" + typeValue.m_7912_() + "_spec"))).customLoader(MateriallyTexturedModelBuilder::new)).end()).rotationX(this.getXFromOpenAndHalf(openValue, halfValue)).rotationY(this.getYFromFacing(facingValue) + this.getYFromOpenAndHalf(openValue, halfValue)).addModel()).condition((Property)BlockStateProperties.f_61374_, (Comparable[])new Direction[]{facingValue}).condition(FancyTrapdoorBlock.TYPE, (Comparable[])new FancyTrapdoorType[]{typeValue}).condition((Property)TrapDoorBlock.f_57515_, (Comparable[])new Half[]{halfValue}).condition((Property)BlockStateProperties.f_61446_, (Comparable[])new Boolean[]{openValue}).end();
                    }
                }
            }
        }
        ItemModelBuilder itemModelBuilderSpec = (ItemModelBuilder)this.itemModels().withExistingParent(ModBlocks.getInstance().getFancyTrapdoor().getRegistryName().m_135815_() + "_spec", this.mcLoc("block/thin_block"));
        ModelBuilderUtils.applyDefaultItemTransforms(itemModelBuilderSpec);
        FancyTrapdoorType[] values = FancyTrapdoorType.values();
        for (int i = 0; i < values.length; ++i) {
            FancyTrapdoorType value = values[i];
            itemModelBuilderSpec.override().model((ModelFile)this.itemModels().getExistingFile(this.modLoc("block/trapdoor/fancy/trapdoor_" + value.m_7912_() + "_spec"))).predicate(new ResourceLocation("domum_ornamentum:trapdoor_type"), (float)i).end();
        }
        ItemModelBuilder itemModelBuilder = (ItemModelBuilder)((MateriallyTexturedModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(ModBlocks.getInstance().getFancyTrapdoor().getRegistryName().m_135815_())).parent((ModelFile)itemModelBuilderSpec)).customLoader(MateriallyTexturedModelBuilder::new)).end();
        ModelBuilderUtils.applyDefaultItemTransforms(itemModelBuilder);
    }

    private int getYFromFacing(Direction facing) {
        return switch (facing) {
            default -> 0;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            case Direction.EAST -> 90;
        };
    }

    private int getYFromOpenAndHalf(boolean open, Half half) {
        if (!open) {
            return half == Half.TOP ? 0 : 180;
        }
        return half == Half.TOP ? 180 : 0;
    }

    private int getXFromOpenAndHalf(boolean open, Half half) {
        if (!open) {
            return half == Half.TOP ? 180 : 0;
        }
        return half == Half.TOP ? -90 : 90;
    }

    @NotNull
    public String m_6055_() {
        return "FancyTrapdoors BlockStates Provider";
    }
}

