/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.client.screens;

import com.ldtteam.domumornamentum.block.MateriallyTexturedBlockManager;
import com.ldtteam.domumornamentum.container.ArchitectsCutterContainer;
import com.ldtteam.domumornamentum.recipe.architectscutter.ArchitectsCutterRecipe;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class ArchitectsCutterScreen
extends AbstractContainerScreen<ArchitectsCutterContainer> {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("domum_ornamentum", "textures/gui/container/architectscutter.png");
    private float sliderProgress;
    private boolean clickedOnSroll;
    private int recipeIndexOffset;
    private boolean hasItemsInInputSlot;

    public ArchitectsCutterScreen(ArchitectsCutterContainer containerIn, Inventory playerInv, Component titleIn) {
        super((AbstractContainerMenu)containerIn, playerInv, titleIn);
        containerIn.setInventoryUpdateListener(this::onInventoryUpdate);
        --this.f_97729_;
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTicks, int x, int y) {
        this.m_280273_(graphics);
        int guiLeft = this.f_97735_;
        int guiTop = this.f_97736_;
        graphics.m_280218_(BACKGROUND_TEXTURE, guiLeft, guiTop, 0, 0, this.f_97726_, this.f_97727_);
        int sliderOffset = (int)(41.0f * this.sliderProgress);
        graphics.m_280218_(BACKGROUND_TEXTURE, guiLeft + 119, guiTop + 15 + sliderOffset, 176 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        int recipeAreaLeft = this.f_97735_ + 52;
        int recipeAreaTop = this.f_97736_ + 14;
        int recipeIndexDrawOffset = this.recipeIndexOffset + 12;
        this.drawSlotBackgrounds(graphics);
        this.drawRecipeButtonBackgrounds(graphics, x, y, recipeAreaLeft, recipeAreaTop, recipeIndexDrawOffset);
        this.drawRecipesItems(graphics, recipeAreaLeft, recipeAreaTop, recipeIndexDrawOffset);
    }

    protected void m_280072_(@NotNull GuiGraphics graphics, int x, int y) {
        super.m_280072_(graphics, x, y);
        if (this.hasItemsInInputSlot) {
            int i = this.f_97735_ + 52;
            int j = this.f_97736_ + 14;
            int k = this.recipeIndexOffset + 12;
            List<ArchitectsCutterRecipe> list = ((ArchitectsCutterContainer)this.f_97732_).getRecipeList();
            for (int l = this.recipeIndexOffset; l < k && l < ((ArchitectsCutterContainer)this.f_97732_).getRecipeListSize(); ++l) {
                int i1 = l - this.recipeIndexOffset;
                int j1 = i + i1 % 4 * 16;
                int k1 = j + i1 / 4 * 18 + 2;
                if (x < j1 || x >= j1 + 16 || y < k1 || y >= k1 + 18) continue;
                graphics.m_280153_(this.f_96547_, list.get(l).m_5874_(((ArchitectsCutterContainer)this.f_97732_).inputInventory, this.f_96541_.f_91073_.m_9598_()), x, y);
            }
        }
    }

    private void drawRecipeButtonBackgrounds(GuiGraphics graphics, int x, int y, int recipeAreaLeft, int recipeAreaTop, int recipeIndexDrawOffset) {
        for (int i = this.recipeIndexOffset; i < recipeIndexDrawOffset && i < ((ArchitectsCutterContainer)this.f_97732_).getRecipeListSize(); ++i) {
            int drawIndex = i - this.recipeIndexOffset;
            int drawLeft = recipeAreaLeft + drawIndex % 4 * 16;
            int rowIndex = drawIndex / 4;
            int drawTop = recipeAreaTop + rowIndex * 18 + 2;
            int ySize = this.f_97727_;
            if (i == ((ArchitectsCutterContainer)this.f_97732_).getSelectedRecipe()) {
                ySize += 18;
            } else if (x >= drawLeft && y >= drawTop && x < drawLeft + 16 && y < drawTop + 18) {
                ySize += 36;
            }
            graphics.m_280218_(BACKGROUND_TEXTURE, drawLeft, drawTop - 1, 0, ySize, 16, 18);
        }
    }

    private void drawSlotBackgrounds(GuiGraphics graphics) {
        int sourceLeft = 16;
        int sourceTop = 166;
        for (int i = 0; i < MateriallyTexturedBlockManager.getInstance().getMaxTexturableComponentCount(); ++i) {
            int rowIndex = i / 2;
            int columnIndex = i % 2;
            int drawLeft = 9 + columnIndex * 20 + this.f_97735_;
            int drawTop = 15 + rowIndex * 18 + this.f_97736_;
            graphics.m_280218_(BACKGROUND_TEXTURE, drawLeft, drawTop, 16, 166, 18, 18);
        }
    }

    private void drawRecipesItems(@NotNull GuiGraphics graphics, int left, int top, int recipeIndexOffsetMax) {
        List<ArchitectsCutterRecipe> list = ((ArchitectsCutterContainer)this.f_97732_).getRecipeList();
        for (int i = this.recipeIndexOffset; i < recipeIndexOffsetMax && i < ((ArchitectsCutterContainer)this.f_97732_).getRecipeListSize(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = left + j % 4 * 16;
            int l = j / 4;
            int i1 = top + l * 18 + 2;
            graphics.m_280480_(list.get(i).m_5874_(((ArchitectsCutterContainer)this.f_97732_).inputInventory, this.f_96541_.f_91073_.m_9598_()), k, i1);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.clickedOnSroll = false;
        if (this.hasItemsInInputSlot) {
            int var6 = this.f_97735_ + 52;
            int var7 = this.f_97736_ + 14;
            int var8 = this.recipeIndexOffset + 12;
            for (int var9 = this.recipeIndexOffset; var9 < var8; ++var9) {
                int var10 = var9 - this.recipeIndexOffset;
                double var11 = mouseX - (double)(var6 + var10 % 4 * 16);
                double var13 = mouseY - (double)(var7 + var10 / 4 * 18);
                if (!(var11 >= 0.0) || !(var13 >= 0.0) || !(var11 < 16.0) || !(var13 < 18.0) || !((ArchitectsCutterContainer)this.f_97732_).m_6366_((Player)Objects.requireNonNull(Objects.requireNonNull(this.f_96541_).f_91074_), var9)) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                Objects.requireNonNull(this.f_96541_.f_91072_).m_105208_(((ArchitectsCutterContainer)this.f_97732_).f_38840_, var9);
                return true;
            }
            var6 = this.f_97735_ + 119;
            var7 = this.f_97736_ + 9;
            if (mouseX >= (double)var6 && mouseX < (double)(var6 + 12) && mouseY >= (double)var7 && mouseY < (double)(var7 + 54)) {
                this.clickedOnSroll = true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.clickedOnSroll && this.canScroll()) {
            int i = this.f_97736_ + 14;
            int j = i + 54;
            this.sliderProgress = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.sliderProgress = Mth.m_14036_((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.canScroll()) {
            int i = this.getHiddenRows();
            this.sliderProgress = (float)((double)this.sliderProgress - delta / (double)i);
            this.sliderProgress = Mth.m_14036_((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean canScroll() {
        return this.hasItemsInInputSlot && ((ArchitectsCutterContainer)this.f_97732_).getRecipeListSize() > 12;
    }

    protected int getHiddenRows() {
        return (((ArchitectsCutterContainer)this.f_97732_).getRecipeListSize() + 4 - 1) / 4 - 3;
    }

    private void onInventoryUpdate() {
        this.hasItemsInInputSlot = ((ArchitectsCutterContainer)this.f_97732_).hasItemsInInputSlots();
        if (!this.hasItemsInInputSlot) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        }
    }
}

