/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block;

import com.google.common.collect.Lists;
import com.ldtteam.domumornamentum.block.ArchitectsCutterBlock;
import com.ldtteam.domumornamentum.block.IModBlocks;
import com.ldtteam.domumornamentum.block.decorative.BarrelBlock;
import com.ldtteam.domumornamentum.block.decorative.BrickBlock;
import com.ldtteam.domumornamentum.block.decorative.ExtraBlock;
import com.ldtteam.domumornamentum.block.decorative.FancyDoorBlock;
import com.ldtteam.domumornamentum.block.decorative.FancyTrapdoorBlock;
import com.ldtteam.domumornamentum.block.decorative.FloatingCarpetBlock;
import com.ldtteam.domumornamentum.block.decorative.FramedLightBlock;
import com.ldtteam.domumornamentum.block.decorative.PanelBlock;
import com.ldtteam.domumornamentum.block.decorative.PaperWallBlock;
import com.ldtteam.domumornamentum.block.decorative.PillarBlock;
import com.ldtteam.domumornamentum.block.decorative.PostBlock;
import com.ldtteam.domumornamentum.block.decorative.ShingleBlock;
import com.ldtteam.domumornamentum.block.decorative.ShingleSlabBlock;
import com.ldtteam.domumornamentum.block.decorative.TimberFrameBlock;
import com.ldtteam.domumornamentum.block.types.BrickType;
import com.ldtteam.domumornamentum.block.types.ExtraBlockType;
import com.ldtteam.domumornamentum.block.types.FramedLightType;
import com.ldtteam.domumornamentum.block.types.TimberFrameType;
import com.ldtteam.domumornamentum.block.vanilla.DoorBlock;
import com.ldtteam.domumornamentum.block.vanilla.FenceBlock;
import com.ldtteam.domumornamentum.block.vanilla.FenceGateBlock;
import com.ldtteam.domumornamentum.block.vanilla.SlabBlock;
import com.ldtteam.domumornamentum.block.vanilla.StairBlock;
import com.ldtteam.domumornamentum.block.vanilla.TrapdoorBlock;
import com.ldtteam.domumornamentum.block.vanilla.WallBlock;
import com.ldtteam.domumornamentum.item.decoration.ExtraBlockItem;
import com.ldtteam.domumornamentum.item.decoration.FancyDoorBlockItem;
import com.ldtteam.domumornamentum.item.decoration.FancyTrapdoorBlockItem;
import com.ldtteam.domumornamentum.item.decoration.FramedLightBlockItem;
import com.ldtteam.domumornamentum.item.decoration.PanelBlockItem;
import com.ldtteam.domumornamentum.item.decoration.PaperwallBlockItem;
import com.ldtteam.domumornamentum.item.decoration.PillarBlockItem;
import com.ldtteam.domumornamentum.item.decoration.PostBlockItem;
import com.ldtteam.domumornamentum.item.decoration.ShingleBlockItem;
import com.ldtteam.domumornamentum.item.decoration.ShingleSlabBlockItem;
import com.ldtteam.domumornamentum.item.decoration.TimberFrameBlockItem;
import com.ldtteam.domumornamentum.item.vanilla.DoorBlockItem;
import com.ldtteam.domumornamentum.item.vanilla.FenceBlockItem;
import com.ldtteam.domumornamentum.item.vanilla.FenceGateBlockItem;
import com.ldtteam.domumornamentum.item.vanilla.SlabBlockItem;
import com.ldtteam.domumornamentum.item.vanilla.StairsBlockItem;
import com.ldtteam.domumornamentum.item.vanilla.TrapdoorBlockItem;
import com.ldtteam.domumornamentum.item.vanilla.WallBlockItem;
import com.ldtteam.domumornamentum.shingles.ShingleHeightType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="domum_ornamentum", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModBlocks
implements IModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"domum_ornamentum");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"domum_ornamentum");
    private static final List<RegistryObject<TimberFrameBlock>> TIMBER_FRAMES = Lists.newArrayList();
    private static final List<RegistryObject<FramedLightBlock>> FRAMED_LIGHT = Lists.newArrayList();
    private static final List<RegistryObject<FloatingCarpetBlock>> FLOATING_CARPETS = Lists.newArrayList();
    private static final List<RegistryObject<ExtraBlock>> EXTRA_TOP_BLOCKS = Lists.newArrayList();
    private static final List<RegistryObject<BrickBlock>> BRICK = new ArrayList<RegistryObject<BrickBlock>>();
    private static final List<RegistryObject<PillarBlock>> PILLARS = new ArrayList<RegistryObject<PillarBlock>>();
    private static final ModBlocks INSTANCE = new ModBlocks();
    private static final RegistryObject<ArchitectsCutterBlock> ARCHITECTS_CUTTER = ModBlocks.register("architectscutter", ArchitectsCutterBlock::new, b -> new BlockItem((Block)b, new Item.Properties()));
    private static final RegistryObject<ShingleBlock> SHINGLE;
    private static final RegistryObject<ShingleBlock> SHINGLE_FLAT;
    private static final RegistryObject<ShingleBlock> SHINGLE_FLAT_LOWER;
    private static final RegistryObject<ShingleSlabBlock> SHINGLE_SLAB;
    private static final RegistryObject<PaperWallBlock> PAPER_WALL;
    private static final RegistryObject<BarrelBlock> STANDING_BARREL;
    private static final RegistryObject<BarrelBlock> LAYING_BARREL;
    private static final RegistryObject<FenceBlock> FENCE;
    private static final RegistryObject<FenceGateBlock> FENCE_GATE;
    private static final RegistryObject<SlabBlock> SLAB;
    private static final RegistryObject<WallBlock> WALL;
    private static final RegistryObject<StairBlock> STAIR;
    private static final RegistryObject<TrapdoorBlock> TRAPDOOR;
    private static final RegistryObject<DoorBlock> DOOR;
    private static final RegistryObject<PostBlock> POST;
    private static final RegistryObject<PanelBlock> PANEL;
    private static final RegistryObject<FancyDoorBlock> FANCY_DOOR;
    private static final RegistryObject<FancyTrapdoorBlock> FANCY_TRAPDOOR;

    private ModBlocks() {
    }

    public static ModBlocks getInstance() {
        return INSTANCE;
    }

    public static <B extends Block, I extends Item> RegistryObject<B> register(String name, Supplier<B> block, Function<B, I> item) {
        RegistryObject registered = BLOCKS.register(name.toLowerCase(), block);
        ITEMS.register(name.toLowerCase(), () -> (Item)item.apply((Block)registered.get()));
        return registered;
    }

    @Override
    public ArchitectsCutterBlock getArchitectsCutter() {
        return (ArchitectsCutterBlock)ARCHITECTS_CUTTER.get();
    }

    public ShingleBlock getShingle(ShingleHeightType heightType) {
        return switch (heightType) {
            default -> throw new IncompatibleClassChangeError();
            case ShingleHeightType.DEFAULT -> (ShingleBlock)SHINGLE.get();
            case ShingleHeightType.FLAT -> (ShingleBlock)SHINGLE_FLAT.get();
            case ShingleHeightType.FLAT_LOWER -> (ShingleBlock)SHINGLE_FLAT_LOWER.get();
        };
    }

    public List<TimberFrameBlock> getTimberFrames() {
        return TIMBER_FRAMES.stream().map(RegistryObject::get).collect(Collectors.toList());
    }

    public List<FramedLightBlock> getFramedLights() {
        return FRAMED_LIGHT.stream().map(RegistryObject::get).collect(Collectors.toList());
    }

    public List<PillarBlock> getPillars() {
        return PILLARS.stream().map(RegistryObject::get).collect(Collectors.toList());
    }

    public ShingleSlabBlock getShingleSlab() {
        return (ShingleSlabBlock)SHINGLE_SLAB.get();
    }

    public PaperWallBlock getPaperWall() {
        return (PaperWallBlock)PAPER_WALL.get();
    }

    public List<ExtraBlock> getExtraTopBlocks() {
        return EXTRA_TOP_BLOCKS.stream().map(RegistryObject::get).toList();
    }

    public List<FloatingCarpetBlock> getFloatingCarpets() {
        return FLOATING_CARPETS.stream().map(RegistryObject::get).toList();
    }

    @Override
    public BarrelBlock getStandingBarrel() {
        return (BarrelBlock)STANDING_BARREL.get();
    }

    @Override
    public BarrelBlock getLayingBarrel() {
        return (BarrelBlock)LAYING_BARREL.get();
    }

    public FenceBlock getFence() {
        return (FenceBlock)FENCE.get();
    }

    public FenceGateBlock getFenceGate() {
        return (FenceGateBlock)FENCE_GATE.get();
    }

    public SlabBlock getSlab() {
        return (SlabBlock)SLAB.get();
    }

    public List<BrickBlock> getBricks() {
        return BRICK.stream().map(RegistryObject::get).toList();
    }

    public WallBlock getWall() {
        return (WallBlock)WALL.get();
    }

    public StairBlock getStair() {
        return (StairBlock)STAIR.get();
    }

    public TrapdoorBlock getTrapdoor() {
        return (TrapdoorBlock)TRAPDOOR.get();
    }

    public PanelBlock getPanel() {
        return (PanelBlock)PANEL.get();
    }

    public PostBlock getPost() {
        return (PostBlock)POST.get();
    }

    public DoorBlock getDoor() {
        return (DoorBlock)DOOR.get();
    }

    public FancyDoorBlock getFancyDoor() {
        return (FancyDoorBlock)FANCY_DOOR.get();
    }

    public FancyTrapdoorBlock getFancyTrapdoor() {
        return (FancyTrapdoorBlock)FANCY_TRAPDOOR.get();
    }

    private static /* synthetic */ BrickBlock lambda$static$17(BrickType type) {
        return new BrickBlock(type);
    }

    private static /* synthetic */ FloatingCarpetBlock lambda$static$15(DyeColor color) {
        return new FloatingCarpetBlock(color);
    }

    private static /* synthetic */ FramedLightBlock lambda$static$13(FramedLightType blockType) {
        return new FramedLightBlock(blockType);
    }

    private static /* synthetic */ ExtraBlock lambda$static$11(ExtraBlockType blockType) {
        return new ExtraBlock(blockType);
    }

    static {
        for (TimberFrameType timberFrameType : TimberFrameType.values()) {
            TIMBER_FRAMES.add(ModBlocks.register(timberFrameType.getName(), () -> new TimberFrameBlock(timberFrameType), b -> new TimberFrameBlockItem((TimberFrameBlock)b, new Item.Properties())));
        }
        SHINGLE = ModBlocks.register("shingle", ShingleBlock::new, b -> new ShingleBlockItem((ShingleBlock)b, new Item.Properties()));
        SHINGLE_FLAT = ModBlocks.register("shingle_flat", ShingleBlock::new, b -> new ShingleBlockItem((ShingleBlock)b, new Item.Properties()));
        SHINGLE_FLAT_LOWER = ModBlocks.register("shingle_flat_lower", ShingleBlock::new, b -> new ShingleBlockItem((ShingleBlock)b, new Item.Properties()));
        SHINGLE_SLAB = ModBlocks.register("shingle_slab", ShingleSlabBlock::new, b -> new ShingleSlabBlockItem((ShingleSlabBlock)b, new Item.Properties()));
        PAPER_WALL = ModBlocks.register("blockpaperwall", PaperWallBlock::new, b -> new PaperwallBlockItem((PaperWallBlock)b, new Item.Properties()));
        PILLARS.add(ModBlocks.register("blockpillar", PillarBlock::new, b -> new PillarBlockItem((PillarBlock)b, new Item.Properties())));
        PILLARS.add(ModBlocks.register("blockypillar", PillarBlock::new, b -> new PillarBlockItem((PillarBlock)b, new Item.Properties())));
        PILLARS.add(ModBlocks.register("squarepillar", PillarBlock::new, b -> new PillarBlockItem((PillarBlock)b, new Item.Properties())));
        for (Enum enum_ : ExtraBlockType.values()) {
            EXTRA_TOP_BLOCKS.add(ModBlocks.register(((ExtraBlockType)enum_).m_7912_(), () -> ModBlocks.lambda$static$11((ExtraBlockType)enum_), b -> new ExtraBlockItem((ExtraBlock)b, new Item.Properties())));
        }
        for (Enum enum_ : FramedLightType.values()) {
            FRAMED_LIGHT.add(ModBlocks.register(((FramedLightType)enum_).getName(), () -> ModBlocks.lambda$static$13((FramedLightType)enum_), b -> new FramedLightBlockItem((FramedLightBlock)b, new Item.Properties())));
        }
        for (Enum enum_ : DyeColor.values()) {
            FLOATING_CARPETS.add(ModBlocks.register(enum_.m_41065_().toLowerCase(Locale.ROOT) + "_floating_carpet", () -> ModBlocks.lambda$static$15((DyeColor)enum_), b -> new BlockItem((Block)b, new Item.Properties())));
        }
        for (Enum enum_ : BrickType.values()) {
            BRICK.add(ModBlocks.register(((BrickType)enum_).m_7912_(), () -> ModBlocks.lambda$static$17((BrickType)enum_), b -> new BlockItem((Block)b, new Item.Properties())));
        }
        STANDING_BARREL = ModBlocks.register("blockbarreldeco_standing", BarrelBlock::new, b -> new BlockItem((Block)b, new Item.Properties()));
        LAYING_BARREL = ModBlocks.register("blockbarreldeco_onside", BarrelBlock::new, b -> new BlockItem((Block)b, new Item.Properties()));
        FENCE = ModBlocks.register("vanilla_fence_compat", FenceBlock::new, b -> new FenceBlockItem((FenceBlock)b, new Item.Properties()));
        FENCE_GATE = ModBlocks.register("vanilla_fence_gate_compat", FenceGateBlock::new, b -> new FenceGateBlockItem((FenceGateBlock)b, new Item.Properties()));
        SLAB = ModBlocks.register("vanilla_slab_compat", SlabBlock::new, b -> new SlabBlockItem((SlabBlock)b, new Item.Properties()));
        WALL = ModBlocks.register("vanilla_wall_compat", WallBlock::new, b -> new WallBlockItem((WallBlock)b, new Item.Properties()));
        STAIR = ModBlocks.register("vanilla_stairs_compat", StairBlock::new, b -> new StairsBlockItem((StairBlock)b, new Item.Properties()));
        TRAPDOOR = ModBlocks.register("vanilla_trapdoors_compat", TrapdoorBlock::new, b -> new TrapdoorBlockItem((TrapdoorBlock)b, new Item.Properties()));
        DOOR = ModBlocks.register("vanilla_doors_compat", DoorBlock::new, b -> new DoorBlockItem((DoorBlock)b, new Item.Properties()));
        PANEL = ModBlocks.register("panel", PanelBlock::new, b -> new PanelBlockItem((PanelBlock)b, new Item.Properties()));
        POST = ModBlocks.register("post", PostBlock::new, b -> new PostBlockItem((PostBlock)b, new Item.Properties()));
        FANCY_DOOR = ModBlocks.register("fancy_door", FancyDoorBlock::new, b -> new FancyDoorBlockItem((FancyDoorBlock)b, new Item.Properties()));
        FANCY_TRAPDOOR = ModBlocks.register("fancy_trapdoors", FancyTrapdoorBlock::new, b -> new FancyTrapdoorBlockItem((FancyTrapdoorBlock)b, new Item.Properties()));
    }
}

