/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.recipe.ModRecipeSerializers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IMateriallyTexturedBlock {
    @NotNull
    public Block getBlock();

    @NotNull
    public Collection<IMateriallyTexturedBlockComponent> getComponents();

    @NotNull
    default public Collection<FinishedRecipe> getValidCutterRecipes() {
        return Lists.newArrayList((Object[])new FinishedRecipe[]{new FinishedRecipe(){

            public void m_7917_(@NotNull JsonObject json) {
            }

            @NotNull
            public ResourceLocation m_6445_() {
                return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)IMateriallyTexturedBlock.this.getBlock()));
            }

            @NotNull
            public RecipeSerializer<?> m_6637_() {
                return (RecipeSerializer)ModRecipeSerializers.ARCHITECTS_CUTTER.get();
            }

            @Nullable
            public JsonObject m_5860_() {
                return null;
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return null;
            }
        }});
    }

    @NotNull
    default public MaterialTextureData getRandomMaterials() {
        HashMap textureData = Maps.newHashMap();
        for (IMateriallyTexturedBlockComponent component : this.getComponents()) {
            ArrayList<Block> candidates = new ArrayList<Block>(StreamSupport.stream(BuiltInRegistries.f_256975_.m_206058_(component.getValidSkins()).spliterator(), false).map(Holder::m_203334_).toList());
            if (candidates.isEmpty()) continue;
            Block texture = (Block)candidates.get(ThreadLocalRandom.current().nextInt(candidates.size()));
            textureData.put(component.getId(), texture);
        }
        return new MaterialTextureData(textureData);
    }
}

