/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.network.packet;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.colossalchests.inventory.container.ContainerColossalChest;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;

public class ServerboundContainerClickPacketOverride
extends PacketCodec {
    @CodecField
    private int windowId;
    @CodecField
    private int stateId;
    @CodecField
    private int slotId;
    @CodecField
    private int usedButton;
    @CodecField
    private ItemStack clickedItem;
    @CodecField
    private String mode;
    private Int2ObjectMap<ItemStack> changedSlots;

    public ServerboundContainerClickPacketOverride() {
    }

    public ServerboundContainerClickPacketOverride(int windowId, int stateId, int slotId, int usedButton, ClickType mode, ItemStack clickedItem, Int2ObjectMap<ItemStack> changedSlots) {
        this.windowId = windowId;
        this.stateId = stateId;
        this.slotId = slotId;
        this.usedButton = usedButton;
        this.clickedItem = clickedItem != null ? clickedItem.m_41777_() : null;
        this.mode = mode.name();
        this.changedSlots = changedSlots;
    }

    public void encode(FriendlyByteBuf output) {
        super.encode(output);
        output.m_236831_(this.changedSlots, FriendlyByteBuf::writeInt, FriendlyByteBuf::m_130055_);
    }

    public void decode(FriendlyByteBuf input) {
        super.decode(input);
        IntFunction intfunction = FriendlyByteBuf.m_182695_(Int2ObjectOpenHashMap::new, (int)128);
        this.changedSlots = Int2ObjectMaps.unmodifiable((Int2ObjectMap)((Int2ObjectMap)input.m_236841_(intfunction, FriendlyByteBuf::readInt, FriendlyByteBuf::m_130267_)));
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        player.m_9243_();
        if (player.f_36096_.f_38840_ == this.windowId) {
            if (player.m_5833_()) {
                ArrayList arraylist = Lists.newArrayList();
                for (int i = 0; i < player.f_36096_.f_38839_.size(); ++i) {
                    arraylist.add(((Slot)player.f_36096_.f_38839_.get(i)).m_7993_());
                }
                ((ContainerColossalChest)player.f_36096_).updateCraftingInventory(player, arraylist);
            } else {
                boolean flag = this.stateId != player.f_36096_.m_182424_();
                player.f_36096_.m_150443_();
                player.f_36096_.m_150399_(this.slotId, this.usedButton, ClickType.valueOf((String)this.mode), (Player)player);
                for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(this.changedSlots)) {
                    player.f_36096_.m_182414_(entry.getIntKey(), (ItemStack)entry.getValue());
                }
                player.f_36096_.m_150422_(this.clickedItem);
                player.f_36096_.m_150444_();
                if (flag) {
                    NonNullList nonnulllist1 = NonNullList.m_122779_();
                    for (int j = 0; j < player.f_36096_.f_38839_.size(); ++j) {
                        nonnulllist1.add((Object)((Slot)player.f_36096_.f_38839_.get(j)).m_7993_());
                    }
                    ((ContainerColossalChest)player.f_36096_).updateCraftingInventory(player, (List<ItemStack>)nonnulllist1);
                } else {
                    player.f_36096_.m_38946_();
                }
            }
        }
    }
}

